/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MenuBar.cc,v $
$Revision: 1.6 $
$Date: 1997/07/02 04:44:51 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MenuBar.cc,v $
Revision 1.6  1997/07/02 04:44:51  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.5  1997/03/04 06:32:48  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.4  1997/02/23 23:44:05  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1996/10/01 04:40:29  andrewm
checkpoint and revision

// Revision 1.2  1996/09/22  01:46:34  andrewm
// pre-alpha release
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "MenuBar.h"
#include "MainWindow.h"
#include "MenuPulldown.h"
#include <Xm/RowColumn.h>
#include <algorithm>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MenuBar.cc,v $ $Revision: 1.6 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MenuBar::
MenuBar(
	const char *name,
	MainWindow *parent)
{
	_widget = XmCreateMenuBar(parent->widget(), (char *)name, NULL, 0) ;
	installDestroyHandler() ;
}

void MenuBar::
build_pulldowns()
{
	MenuPulldown *pd ;

	pd = template_create_file_menu("file", this) ;
	if (pd)
		add(pd) ;

	pd = template_create_edit_menu("edit", this) ;
	if (pd)
		add(pd) ;

	pd = template_create_view_menu("view", this) ;
	if (pd)
		add(pd) ;

	pd = template_create_special_menu("special", this) ;
	if (pd)
		add(pd) ;

	pd = template_create_options_menu("options", this) ;
	if (pd)
		add(pd) ;

	pd = template_create_help_menu("help", this) ;
	if (pd)
	{
		add(pd) ;
		setValue(XmNmenuHelpWidget, (XtArgVal)pd->button()) ;
	}

	template_create_other_menus(this) ;
}
