/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: MainWindow.cc,v $
$Revision: 1.5 $
$Date: 1997/07/02 04:44:51 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: MainWindow.cc,v $
Revision 1.5  1997/07/02 04:44:51  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.4  1997/03/04 06:32:48  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.3  1997/02/23 23:44:04  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.2  1996/09/22 01:46:34  andrewm
pre-alpha release

// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
// MainWindow.C: Support a top-level window
////////////////////////////////////////////////////////////////////
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "MainWindow.h"
#include "Application.h"
#include "MenuBar.h"
#include "DrawingArea.h"
#include "MessageArea.h"
#include <Xm/Form.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: MainWindow.cc,v $ $Revision: 1.5 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

MainWindow::
MainWindow(
	const char *name,
	Application *parent) :
		_menu_bar(NULL),
		_drawing_area(NULL),
		_message_area(NULL)
{
	_widget = XmCreateForm(parent->widget(), (char *)name, NULL, 0) ;
}

MainWindow::
~MainWindow(void)
{
	delete _menu_bar ;
	delete _drawing_area ;
	delete _message_area ;
}

void MainWindow::
initialize(void)
{
	_menu_bar = template_create_menu_bar("menuBar", this) ;
	_menu_bar->build_pulldowns() ;
	_menu_bar->manage() ;
	_drawing_area = template_create_drawing_area("drawingArea", this) ;
	_drawing_area->manage() ;
	_message_area = template_create_message_area("messageArea", this) ;
	_message_area->manage() ;
}
