/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: FileSelectionDialog.cc,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:44:50 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: FileSelectionDialog.cc,v $
Revision 1.8  1997/07/02 04:44:50  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/06/15 00:43:52  andrewm
Another checkpoint.  Reworked the way text is specfied to be drawn
for the benefit of the post script renderer.

Revision 1.6  1997/04/12 21:14:56  andrewm
Checkpoint after adding the event dialog.

Revision 1.5  1997/02/23 23:44:03  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.4  1996/10/01 04:40:29  andrewm
checkpoint and revision

// Revision 1.3  1996/09/22  01:46:34  andrewm
// pre-alpha release
//
// Revision 1.2  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.2  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "FileSelectionDialog.h"

#include <Xm/FileSB.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: FileSelectionDialog.cc,v $ $Revision: 1.8 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

/*
FUNCTION DEFINITIONS
*/

FileSelectionDialog::
FileSelectionDialog(
	const char *name,
	UIComponent *parent)
{
	Arg args[5] ;
	Cardinal n = 0 ;

	XtSetArg(args[n], XmNautoUnmanage, True) ; n++ ;
	_widget = XmCreateFileSelectionDialog(parent->widget(), (char *)name,
		args, n) ;
	installDestroyHandler() ;
	install_callbacks() ;
}

void FileSelectionDialog::
manage() const
{
	if (!_ok_command)
	{
		Widget w = XtNameToWidget(_widget, "OK") ;
		if (w) XtSetSensitive(w, False) ;
	}
	if (!_cancel_command)
	{
		Widget w = XtNameToWidget(_widget, "Cancel") ;
		if (w) XtSetSensitive(w, False) ;
	}
	if (!_help_command)
	{
		Widget w = XtNameToWidget(_widget, "Help") ;
		if (w) XtSetSensitive(w, False) ;
	}
	do_search() ;
	UIComponent::manage() ;
}

void FileSelectionDialog::
dir_mask(
	const char *new_mask)
{
	_dir_mask = XmCxxString(new_mask) ;
	do_search() ;
}

void FileSelectionDialog::
do_search() const
{
		// Hack necessary because Motif does not declare the
		// type conversion operator from a XmCxxString to a XmString
		// to be "const" even though it truly is.
	FileSelectionDialog *fsd = (FileSelectionDialog *)this ;
	XmFileSelectionDoSearch(_widget, (XmString)fsd->_dir_mask) ;
}
