/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: DrawingArea.h,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:44:50 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: DrawingArea.h,v $
Revision 1.8  1997/07/02 04:44:50  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/03/04 06:32:48  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.6  1997/02/23 23:44:03  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.5  1996/09/22 01:46:34  andrewm
pre-alpha release

 * Revision 1.4  1996/08/18  17:59:20  andrewm
 * checkpoint
 *
 * Revision 1.4  1996/08/18  17:59:20  andrewm
 * checkpoint
 *
 * Revision 1.3  1996/07/27  20:58:10  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/15  01:22:04  andrewm
 * checkpoint again
 *
 * Revision 1.1  1996/07/13  19:32:43  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _DrawingArea_h_
#define _DrawingArea_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/

#include "UIComponent.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class MainWindow ;
class XmCommand ;

class DrawingArea :
	public UIComponent
{
public:
	DrawingArea(const char *name, MainWindow *parent) ;
	virtual ~DrawingArea() ;

	virtual const char *className() const { return "DrawingArea" ; }
	Widget draw_widget() const { return _draw_widget ; }
	void input_command(XmCommand *new_command) ;
	void expose_command(XmCommand *new_command) ;

private:
	Widget _draw_widget ;
	XmCommand *_input_command ;
	XmCommand *_expose_command ;

private:
	static const char *_draw_trans ;

private:
	static void inputCallback(Widget widget, XtPointer closure,
		XtPointer call_data) ;
	static void exposeCallback(Widget widget, XtPointer closure,
		XtPointer call_data) ;
} ;


#endif /* _DrawingArea_h_ */
