/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: DrawingArea.cc,v $
$Revision: 1.7 $
$Date: 1997/07/02 04:44:49 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: DrawingArea.cc,v $
Revision 1.7  1997/07/02 04:44:49  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.6  1997/03/04 06:32:47  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.5  1997/02/23 23:44:03  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.4  1996/09/22 01:46:34  andrewm
pre-alpha release

// Revision 1.3  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.3  1996/07/27  20:58:10  andrewm
// checkpoint
//
// Revision 1.2  1996/07/15  01:22:04  andrewm
// checkpoint again
//
// Revision 1.1  1996/07/13  19:32:43  andrewm
// Initial revision
//
 *--
 */

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma implementation
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "DrawingArea.h"
#include "MainWindow.h"
#include "Command.h"
#include <Xm/ScrolledW.h>
#include <Xm/DrawingA.h>

/*
MACRO DEFINITIONS
*/

/*
TYPE DEFINITIONS
*/

/*
EXTERNAL FUNCTION REFERENCES
*/

/*
FORWARD FUNCTION REFERENCES
*/

/*
FORWARD CLASS REFERENCES
*/

/*
EXTERNAL DATA REFERENCES
*/

/*
EXTERNAL DATA DEFINITIONS
*/

/*
STATIC DATA ALLOCATION
*/
static char rcsid[] = "@(#) $RCSfile: DrawingArea.cc,v $ $Revision: 1.7 $" ;

/*
STATIC MEMBER DEFINITIONS
*/

const char *DrawingArea::_draw_trans =
	"<BtnMotion>:	DrawingAreaInput()\n\
	 <BtnDown>:		DrawingAreaInput()\n\
	 <BtnUp>:		DrawingAreaInput()\n\
	 <KeyDown>:		DrawingAreaInput()\n\
	 <KeyUp>:		DrawingAreaInput()" ;

/*
FUNCTION DEFINITIONS
*/

DrawingArea::
DrawingArea(
	const char *name,
	MainWindow *parent) :
		_input_command(NULL),
		_expose_command(NULL)
{
	Arg args[10] ;
	Cardinal n = 0 ;

	XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC) ; n++ ;
	_widget = XmCreateScrolledWindow(parent->widget(), (char *)name, args, n) ;
	installDestroyHandler() ;

	n = 0 ;
	XtSetArg(args[n], XmNscrolledWindowChildType, XmWORK_AREA) ; n++ ;
	XtSetArg(args[n],
		XmNtranslations, XtParseTranslationTable(_draw_trans)) ; n++ ;
	_draw_widget = XmCreateDrawingArea(_widget, "working", args, n) ;
	XtManageChild(_draw_widget) ;

	XtAddCallback(_draw_widget, XmNinputCallback, inputCallback,
		(XtPointer)this) ;
	XtAddCallback(_draw_widget, XmNexposeCallback, exposeCallback,
		(XtPointer)this) ;
}

DrawingArea::
~DrawingArea()
{
	delete _input_command ;
	delete _expose_command ;
}

void DrawingArea::
input_command(XmCommand *new_command)
{
	delete _input_command ;
	_input_command = new_command ;
}

void DrawingArea::
expose_command(XmCommand *new_command)
{
	delete _expose_command ;
	_expose_command = new_command ;
}

void DrawingArea::
inputCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	DrawingArea *da = (DrawingArea *)closure ;
	if (da->_input_command)
		da->_input_command->execute((XmAnyCallbackStruct *)call_data) ;
}

void DrawingArea::
exposeCallback(
	Widget w,
	XtPointer closure,
	XtPointer call_data)
{
	DrawingArea *da = (DrawingArea *)closure ;
	if (da->_expose_command)
		da->_expose_command->execute((XmAnyCallbackStruct *)call_data) ;
}
