/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Document.h,v $
$Revision: 1.10 $
$Date: 1997/07/02 04:44:49 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Document.h,v $
Revision 1.10  1997/07/02 04:44:49  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.9  1997/04/08 04:34:24  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.8  1997/03/30 02:07:23  andrewm
Checkpoint.  Things working well. About to change the way
machines are stored in the backing file.

Revision 1.7  1997/03/18 06:50:58  andrewm
Checkpoint.  Mouse select, insert, and delete working.
Some changes to improve robustness in the face of an arbitrary input file.

Revision 1.6  1997/03/12 03:13:04  andrewm
Checkpoint.  Things are working rather well.

Revision 1.5  1997/03/04 06:32:47  andrewm
Another check point.  The editor can draw output from files.
The crashing during the dtor for MachineGroup is fixed.

Revision 1.4  1997/02/23 23:44:03  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.3  1996/09/22 01:46:34  andrewm
pre-alpha release

 * Revision 1.2  1996/07/27  20:58:10  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/27  20:58:10  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/07/13  19:32:43  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _Document_h_
#define _Document_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "FileName.h"
#include "Geom2d.h"
#include "Observer.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Document :
	public Subject
{
public:
	virtual ~Document() ;

	virtual void open(const char *filename, bool draw = true) = 0 ;
	virtual void new_doc() = 0 ;
	virtual void close() = 0 ;
	virtual void save() = 0 ;
	virtual void save(const char *filename) = 0 ;
	virtual bool modified() = 0 ;
	virtual void redraw() = 0 ;
	virtual void refresh() = 0 ;

	virtual void button_1_press(const Point& p) = 0 ;
	virtual void button_1_release(const Point& p) = 0 ;
	virtual void button_1_motion(const Point& p) = 0 ;
	virtual void button_2_press(const Point& p) = 0 ;
	virtual void button_2_release(const Point& p) = 0 ;
	virtual void button_2_motion(const Point& p) = 0 ;
	virtual void button_3_press(const Point& p) = 0 ;
	virtual void button_3_release(const Point& p) = 0 ;
	virtual void button_3_motion(const Point& p) = 0 ;

	virtual void select_all() = 0 ;
	virtual void deselect_all() = 0 ;
	virtual void set_change_mode() = 0 ;
	virtual void set_insert_mode() = 0 ;
	virtual void set_delete_mode() = 0 ;

	virtual void first_page() = 0 ;
	virtual void last_page() = 0 ;
	virtual void next_page() = 0 ;
	virtual void previous_page() = 0 ;
	virtual void delete_page() = 0 ;

	virtual void edit_document_params() = 0 ;
	virtual void edit_page_params() = 0 ;
	virtual void edit_page_events() = 0 ;
	virtual void edit_component_params() = 0 ;

	virtual void check_states() = 0 ;
	virtual void check_transitions() = 0 ;

	const FileName& filename() { return _filename ; }
	bool check_file() ;

protected:
	Document() {}

protected:
	FileName _filename ;
} ;


#endif /* _Document_h_ */
