/*
 *++
COPYRIGHT:
This file is part of the GSM Suite, a set of programs for
manipulating state machines in a graphical fashion.
Copyright (C) 1996, 1997  G. Andrew Mangogna.

LICENSE:
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.,
59 Temple Place - Suite 330,
Boston, MA  02111-1307, USA.

MODULE:

$RCSfile: Dialog.h,v $
$Revision: 1.8 $
$Date: 1997/07/02 04:44:48 $

ABSTRACT:

CONDITIONAL COMPILATION:

MODIFICATION HISTORY:
$Log: Dialog.h,v $
Revision 1.8  1997/07/02 04:44:48  andrewm
Added copyright and license notices to the tops of the files.

Revision 1.7  1997/04/08 04:34:24  andrewm
Checkpoint as dialogs are added.
Decided to make sure that the name part of a name/value pair in
the hierarchical file is not used for id purposes.  Specifically
state machine names need to be contained within the machine not as
the key to the machine.

Revision 1.6  1997/02/23 23:44:02  andrewm
Checkpoint.  Things seem to be working reasonably well.

Revision 1.5  1996/11/14 06:20:45  andrewm
checkpoint

 * Revision 1.4  1996/10/01  04:40:29  andrewm
 * checkpoint and revision
 *
 * Revision 1.3  1996/09/22  01:46:34  andrewm
 * pre-alpha release
 *
 * Revision 1.2  1996/07/27  20:58:10  andrewm
 * checkpoint
 *
 * Revision 1.2  1996/07/27  20:58:10  andrewm
 * checkpoint
 *
 * Revision 1.1  1996/07/13  19:32:43  andrewm
 * Initial revision
 *
 *--
 */
#ifndef _Dialog_h_
#define _Dialog_h_

/*
PRAGMAS
*/
#ifdef __GNUG__
#	pragma interface
#endif /* __GNUG__ */

/*
INCLUDE FILES
*/
#include "UIComponent.h"

/*
MACRO DEFINITIONS
*/

/*
CLASS DEFINITIONS
*/

class Command ;

class Dialog :
	public UIComponent
{
public:
	virtual ~Dialog() ;

	virtual void manage() const ;
	virtual const char *className() const { return "Dialog" ; }

	virtual void ok_command(Command *command) ;
	virtual void cancel_command(Command *command) ;
	virtual void help_command(Command *command) ;

protected:
	Command *_ok_command ;
	Command *_cancel_command ;
	Command *_help_command ;

protected:
	Dialog() ;
	virtual void ok() ;
	virtual void cancel() ;
	virtual void help() ;

protected:
	void install_callbacks() ;
	static void okCallback(Widget w, XtPointer closure, XtPointer call_data) ;
	static void cancelCallback(Widget w, XtPointer closure,
		XtPointer call_data) ;
	static void helpCallback(Widget w, XtPointer closure, XtPointer call_data) ;
} ;



#endif /* _Dialog_h_ */
