


/* VPK */

/*  V  P  K   */

/*INCLUDE FILES */

#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <ncurses.h>
#include <time.h>

/*MACRO DEFINITIONS */

#define BORDER 1
#define X_SIZE 80  
#define Y_SIZE 24  
#define MX 0 
#define MY LINES - 2 
#define DX COLS - 12 
#define PX COLS - 8
#define FX  0
#define HY 0
#define HX (COLS/2 - 5) 


// Variable Declarations

WINDOW *winptr;
static int x,y,SKIP=0,ERASE=0;
static int maxx,maxy,begx,begy,ch;
static int ty,tx;
char filename[50]="Untitled.tp",oldfilename[50]="Untitled.tp",ext[3]=".tp";
char timestr[50];
char point[10];
FILE *winfp;
int FIL=0,LOA=0;
int err=0,opt=0;
int bkc=' ',bchar=' ';
int D_CHAR='.',TCH='.';
char MODE[3][7] = { "Draw","Skip","Erase"};
int MOC=0;
int X_MAX=0,Y_MAX=0;
int i=0,j=0;
int RO=0,CO=0;
char *buffer;
int DELET=0;
int MOVE=0;
int COPY=0;
int BOX=0;


struct tm *tim;
long t=0;

struct point {
    int pix;
};

struct point win[Y_SIZE][X_SIZE];





main (int argc, char *argv[])
{

    
/*  CTRL-C  TRAP */ signal (2, SIG_IGN);


  opterr = 0;
  while ((opt = getopt (argc, argv, "d:b:f:")) != -1)
    {
      switch (opt)
	{
	case 'd':
	  D_CHAR = (char) optarg[0];
	  break;
	case 'b':
	  bkc = (char) optarg[0];
	  break;
	case '?':
	  fprintf (stderr, "Invalid Option %c or value required\n", optopt);
	  err = 1;
	  break;
	case 'f':
	  FIL = 1;
	  strcpy (filename, optarg);
	  break;
	}
    }
  for (; optind < argc; optind++)
    {
      fprintf (stderr, "Invalid Arguments %s \n", argv[optind]);
      err = 1;
    }
  if (err)
  {
      printf("\nUsage: %s  [-d drawing_char] [-b background_char] [-f file]\n",argv[0]);
      exit(EINVAL);
      
  }

   putenv("TERM=vt100");

   slk_init(1);
 
   if (!initscr ())
      error("paint");
   slk_touch();

        Y_MAX = LINES - 4;
	X_MAX = COLS-1;
	

 	slk_touch();
 	slk_refresh();
  	maxy= LINES-3;
  	maxx= COLS;
  	begy=1;  begx=0;
        x=1; y=1;
	
  	winptr = subwin(stdscr,maxy,maxx,begy,begx);
	
  	if (BORDER) {
      		box(winptr,0,0);
  			}
	
  wbkgd(winptr,bkc);
  wrefresh (winptr);
  getbegyx (winptr, begy, begx);
  getmaxyx (winptr, maxy, maxx);
  
  


  noecho ();
  timeout (-1);
  nonl ();
/*  Following Two Functions Implement the kbhit() function    */

  cbreak ();			/*  return after 1 character in typehead */
  nodelay (winptr, TRUE);	/* don't wait for input */
  keypad (stdscr, 1);
  wrefresh(stdscr);
  wmove(winptr, x,y);
  clear_struc();
  draw();

  
  begx=1;
  begy=1;
  maxx-=1;
  maxy-=1;

  // Main Loop
  
      if(!access(filename,F_OK))
      {
      LOA=1;
      load();
      }
  
  while (1)
    {
      ch = getch ();
      switch (ch)
	{
	    case  '2': 
	    case KEY_DOWN:
	  
	         y =  (y >= (maxy -2 )) ? maxy-1 : y+1;
		 break;
	    case '8': case KEY_UP:
		 y =  (y <= (begy)) ? begy : y-1;
		break;
	    case '4': case  KEY_LEFT:
		x = (x <= (begx)) ? begy : x-1;
		break;
	    case '6': case KEY_RIGHT:
	    x = (x >= (maxx - 2)) ? maxx -1 : x+1;
		break;
	    case '7':
	    x = (x <= (begx)) ? begx : x-1;
	    y = (y <= (begy)) ? begy : y-1;
		break;
	    case '1':
		y= (y >= (maxy - 1)) ? maxy-1 : y+1;
		x= (x <= (begx) ) ? begx : x-1;
		
		break;
	    case '3':
	    x = ( x >= (maxx -1)) ? maxx-1 : x+1;
	    y = ( y >= maxy - 1 ) ? maxy -1 :  y+1;
		break;
	    case '9':
		x = ( x >= (maxx-1)) ? maxx - 1 : x+1;
		y = ( y <= (begy)) ? begy : y-1;
		break;
	    case 'f':
	    case 'F':
		echo();
		wattron(stdscr,A_BOLD);
	showmsg("Enter Drawing Character: ");
		TCH = wgetch(stdscr);
		if(iscntrl(TCH))
		    ;
		else
		    D_CHAR = TCH;
		noecho();
		status();
		wmove(winptr,y,x);
		wrefresh(winptr);
		continue;
	    case 'M':
	    case 'm':
		MOVE=1;
		copy_move();
		continue;
	    case 'D':
	    case 'd':
		DELET=1;
		copy_move();
		continue;
	    case 'O':
	    case 'o':
		COPY=1;
		copy_move();
		continue;
	    case 'P':
	    case 'p':
		paste_buffer();
		continue;
	    case 'X':
	    case 'x':
		BOX=1;
		copy_move();
		continue;
	    case 'b':
	    case 'B':
		echo();
		wattron(stdscr,A_BOLD);
		showmsg("Enter BackGround Character: ");
		bchar = wgetch(stdscr);
		if(iscntrl(bchar) != 0 || isprint(bchar) == 0 )
		bchar = bkc; 
		noecho();
		draw_back(bchar);
		status();
		wmove(winptr,y,x);
		wrefresh(winptr);
		continue;
	case 'q':
	case 'Q':
		quit();
	  break;
	case 'V':
	case 'v':
	  save();
	  continue;
	case 'l':
	case 'L':
	  load();
	  continue;
	case 'e':
	case 'E':
	  if(ERASE)
	  {
	      ERASE=0;
	      SKIP=0;
	  }
	  else
	      ERASE =1;
	      
	  break;
	case 's':
	case 'S':
	  if(SKIP)
	      SKIP=0;
	  else
	      SKIP=1;
	  break;
	case 'c':
	case 'C':
	  SKIP=0;
	  ERASE=0;
	  wclear(winptr);
      	  box(winptr,0,0);
	  status();
	  FIL=0;
	  LOA=0;
	  clear_struc();
	  draw_back(bkc);
	  x=1;y=1;
	  wmove(winptr,y,x);
	  wrefresh(winptr);
	  continue;
	default:
	  continue;
	}

draw();
      
    }



  
  getchar();

  errno = 0;

  delwin (winptr);
  endwin ();
  system ("clear");
}

//  END OF MAIN


// Error Handler 
error(char *s)
{
    endwin();
    system("clear");
    perror(s);
    exit(errno);
}
// Pixel Drawing Routine
draw()
{
    
    if(SKIP)
    {
	wmove(winptr,x,y);
	    MOC=1;
    }
    else if(ERASE)
    {
	mvwaddch(winptr,y,x,bkc);
        win[y][x].pix= bkc;
	MOC=2;
    }
    else
    {
	mvwaddch(winptr,y,x,D_CHAR);
        win[y][x].pix=D_CHAR;
	MOC=0;
    }
    
    
    status();
    wmove(winptr,y,x);
    wrefresh(winptr);
}
// Status Line Display	
status()
{
sprintf(point,"%02d %02d",y,x);   
slk_set(1,"L-load ",1);
slk_set(2,"V-Save ",1);
slk_set(3,"S-Skip ",1);
slk_set(4,"E-Erase",1);
slk_set(5,"C-Clear",1);
slk_set(6,"F-Dchar",1);
slk_set(7,"B-BChar",1);
slk_set(8,"Q-Quit ",1);
sta_clear();

wattron(stdscr,A_BOLD);
mvwprintw(stdscr,(MY+1),PX,"%s",point);
mvwaddch(stdscr,(MY+1),(PX-14),D_CHAR);
mvwaddch(stdscr,(MY+1),(PX-5),bkc);
/* mvwaddstr(stdscr,MY+1,MX,"O-Copy");
mvwaddstr(stdscr,MY+1,MX+9,"M-Move");
mvwaddstr(stdscr,MY+1,MX+18,"D-Del");
mvwaddstr(stdscr,MY+1,MX+27,"X-Box");*/
switch(MOC)
{
    case 0:
	showmsg("Use NumberPad to draw");
	break;
    case 1:
	showmsg("Press S for Draw Mode");
	break;
    case 2:
	showmsg("Press E for Draw Mode");
	break;
}
	
headline();
wrefresh(stdscr);
wattroff(stdscr,A_BOLD);
slk_refresh();
wmove(winptr,y,x);
wrefresh(winptr);
}

// Program Terminator
quit()
{
    endwin();
    system("clear");
    exit(0);
}
// File Saver
save()
{
    int i,j;
    wattron(stdscr,A_BOLD);
    if(strcmp(filename,"Untitled")==0)
	FIL=0;
    if(!FIL)
    {
    echo();
    sta_clear();
    showmsg("Enter File Name: ");
    mvwscanw(stdscr,MY,18,"%s",filename);
    noecho();
    FIL=1;
    }
    if(!strend(filename,ext))
    {
    strcat(filename,ext);
    }
    noecho();
    LOA=0;
    winfp = fopen(filename,"w+");
  if(!winfp)
  {
   showmsg(strerror(errno));
   wrefresh(stdscr);
   sleep(1);
   sta_clear();
   strcpy(filename,oldfilename);
   status();
   return;
  }
      
    showmsg("Saving....");
	
    wrefresh(stdscr);
    for(i=1;i<Y_MAX;i++)
    {
	for(j=1;j<X_MAX;j++)
	{
	    fputc(win[i][j].pix,winfp);
	}
    fputc('\n',winfp);
    }
    sleep(1);
    fclose(winfp);
    strcpy(oldfilename,filename);
    x=1;y=1;
    status();
}

// File Loader
load()
{
    int i,j,c;
    i=j=c=0;
    wattron(stdscr,A_BOLD);
    FIL=0;
    echo();
    sta_clear();
    if(!LOA)
    {

    showmsg("Enter File Name: ");
    mvwscanw(stdscr,MY,18,"%s",filename);
    noecho();
    LOA=0;
    }
    noecho();

	    
  winfp = fopen(filename,"r+");
      
      
  if(!winfp)
  {
   sta_clear();
   showmsg(strerror(errno));
errpt:
   wrefresh(stdscr);
   sleep(1);
   sta_clear();
   strcpy(filename,oldfilename);
   status();
   return;
  }
    if(!strend(filename,ext) || !checkfile())
    {
	sta_clear();
	showmsg("Unrecognized File Format");
	LOA=0;
	fclose(winfp);
	goto errpt;
    }
  
  FIL=1;
  showmsg("Loading.....");
    clear_struc();
    wrefresh(stdscr);
    for(i=1;i<Y_MAX;i++)
    {
	for(j=1;j<X_MAX;j++)
	{ 
 	   c=fgetc(winfp);
	   win[i][j].pix=c;
	   mvwaddch(winptr,i,j,c);
	}
	fseek(winfp,1L,SEEK_CUR);
    }

    wrefresh(winptr);
    fclose(winfp);
    strcpy(oldfilename,filename);
    sleep(1);
    x=1;y=1;
    status();
}
    
	
// Clear Temporary Buffer for file   
clear_struc()
{
    int i,j;
  for(i=1;i<Y_MAX;i++)
      for(j=1;j<X_MAX;j++)
      {
	  win[i][j].pix=bkc;
      }
  
}

// Refresh Statusline
sta_clear()
{
   mvwprintw(stdscr,MY,MX,"                                                     ");
}

// Headline Display
headline()
{
int i;
    for(i=0;i<COLS;i++)
    mvwaddch(stdscr,HY,i,' ');
mvwprintw(stdscr,HY,DX,"Mode: %s ",MODE[MOC]);
mvwprintw(stdscr,HY,FX,"File: %s",filename);
mvwprintw(stdscr,HY,HX,"TermPaint");

}

int draw_back(int  bch)
{
    int i,j;
  for(i=1;i<Y_MAX;i++)
      for(j=1;j<X_MAX;j++)
      {   
	  if(win[i][j].pix == bkc )
	  {
	  win[i][j].pix=bch;
	  mvwaddch(winptr,i,j,win[i][j].pix);
	  }
      }
  bkc=bch;
}  


strend(char *str,char *ser)  /* this will return true if ser present at end
				of str string 0 otherwise */
{
     int a,b;
     char *temp = ser;
     a=b=0;
     while(*ser++) a++;
     while(*str++);
     str-=(a+1);
     while(*str != '\0')
     {
	 if(*str++ == *temp++)
	     b++;
	 else
	     return(0);
     }

     if(b==a) return 1 ; else return 0 ;
}
// To Some Extent Check the file for Correctness for loading Here.
checkfile()
{
    int c,nl,max,ch;
    c=nl=max=ch=0;
    rewind(winfp);
  while ((ch = getc (winfp)) != EOF)
    {
      ++c;
      if (ch == '\n')
	{
	  nl++;
	  if (c > max)
	    {
	      max = c;
	      c = 0;
	    }
	  else
	    c = 0;
	}
    }
  max--;
  
    rewind(winfp);
    if(max < X_MAX && nl < Y_MAX)
	
	return 1;
    else
	return 0;
}

showmsg(char *s)
{
    sta_clear();
    mvwprintw(stdscr,MY,MX,"%s",s);
    wrefresh(stdscr);
}


paste(sy,sx,dy,dx,dy1,dx1)
    int sy,sx,dy,dx,dy1,dx1;
{
    char *temp;
    int ret;
   int i,j,k,l;
   int row,col;
   i=j=k=l=0;
   buffer = NULL;
       k=dy;
       l=dx;
       if(!DELET)
       {
	   RO=dy1-dy;
	   CO=dx1-dx;
	   
       }
       buffer=(char*)malloc(sizeof(char) * RO * CO);
       if(buffer== NULL)
       {
	   showmsg(strerror(errno));
           sleep(1);
	   return 0;
       }
	   
      temp = buffer;   
       
       for(i=sy,k=dy;i<=(sy+RO);i++,k++)
       {
	   for(j=sx,l=dx;j<=(sx+CO);j++,l++)
	   {
	       *buffer++ = win[i][j].pix;
	       
	       if(DELET)
	       {
		    mvwaddch(winptr,i,j,bkc);
		    win[i][j].pix= bkc;
		    
	       }
	       else if(COPY)
	       {
		   continue;
	       }
	       else
	       {
			win[k][l].pix = win[i][j].pix ;
			mvwaddch(winptr,i,j,bkc);
			win[i][j].pix= bkc;
	       }
	   }
       }
       buffer = temp;
       load_struc();
      if(DELET)
	  showmsg("Block Deleted"),sleep(1);
      if(COPY)
	  showmsg("Copied to buffer...");
      if(MOVE)
	  showmsg("Image Moved..");
      sleep(1);
       MOVE=0;
      DELET=0; 
   return 1;
}
  
  // Load Current Structure contents to Screen.  
load_struc()
{
	    int i,j;
	    int c=0;
	    i=j=0;
	for(i=1;i<Y_MAX;i++)
	{
	    for(j=1;j<X_MAX;j++)
	    { 
	       c=win[i][j].pix;
	       mvwaddch(winptr,i,j,c);
	    }
	}
	wrefresh(winptr);
}
// Paste Buffer Contents in to screen
paste_buffer()
{
    char *temp;
    
    int i,j;
    i=j=0;
    wattron(stdscr,A_BOLD);
    if(RO == 0 || CO == 0)
    {
	showmsg("Buffer Empty");
	sleep(1);
	status();
	return 0;
    }
	
    if((y+RO) >= Y_MAX || (x+CO) >= X_MAX )
    {
	showmsg("Invalid Destination");
	sleep(1);
	status();
	return 0;
    }
    else
    {
	temp = buffer;
	for(i=y;i<=(y+RO);i++)
	{
	    for(j=x;j<=(x+CO);j++)
	    {
		win[i][j].pix = *buffer++;
	    }
	}
	
	load_struc();
    }
    
    buffer = temp;
    status();
    return 1;
}
 
// Wrapper Function for Copy, Move, Delete
copy_move()
{
	int x1,x2,y1,y2,dy,dx,i;
	x1=y1=x2=y2=dy=dx=i=0;
	
	wattron(stdscr,A_BOLD);
	sta_clear();
	showmsg("Select (x1,y1) Press Enter to Confirm");
	if(select_pos())
	{
		x1=tx;
		y1=ty;
	}
	else
	{
		return 0;
	}
		
	sta_clear();
	showmsg("Select (x2,y2) Press Enter to Confirm");
	if(select_pos())
	{
		x2=tx;
		y2=ty;
	}
	else
	{
		return 0;
	}
	  if(x1 > x2)
	  {
	  i=x1; 
	  x1=x2; 
	  x2=i;
	  }
	  if(y1 > y2)
	  {
	      i=y1; 
	      y1 = y2; 
	      y2=i;
	  }
	  if(BOX)
	  {
		  draw_box(y1,x1,y2,x2);
		  return 1;
	  }
		  
		
	  if(MOVE)
	  {
          showmsg("Select Destination Press Enter to Confirm");
	  
		if(select_pos())
		{
			dx=tx;
			dy=ty;
		}
		else
		{
			return 0;
		}
	  }

	  
	  
	  
	  if(DELET || COPY)
	  {
	      RO=y2-y1;
	      CO=x2-x1;
	  }

	  if(dx+(x2-x1) >= X_MAX || dy+(y2-y1) >= Y_MAX)
	  {
	      showmsg("Invalid Destination Selection");
	      sleep(1);
	      status();
	  	      return 0;
	  }

	  wrefresh(stdscr);
          paste(y1,x1,dy,dx,dy+(y2-y1),dx+(x2-x1));
	  
	  DELET=0; 
	  status();
	  return 1;
}
  
// Interface For selecting Screen Position for Delete, Copy , Move, Box	
select_pos()
{
    int ch;
    ch=0;
    
    wmove(winptr,y,x);
    wrefresh(winptr);
    while(1)
    {
	
	ch=wgetch(stdscr);
	switch(ch)
	{
	    case  '2': 
	    case KEY_DOWN:
	         y =  (y >= (maxy -2 )) ? maxy-1 : y+1;
		 break;
	    case '8': 
	    case KEY_UP:
		 y =  (y <= (begy)) ? begy : y-1;
		break;
	    case '4':
	    case  KEY_LEFT:
		x = (x <= (begx)) ? begy : x-1;
		break;
	    case '6': 
	    case KEY_RIGHT:
	    x = (x >= (maxx - 2)) ? maxx -1 : x+1;
		break;
	    case '7':
	    x = (x <= (begx)) ? begx : x-1;
	    y = (y <= (begy)) ? begy : y-1;
		break;
	    case '1':
		y= (y >= (maxy - 1)) ? maxy-1 : y+1;
		x= (x <= (begx) ) ? begx : x-1;
		break;
	    case '3':
	    x = ( x >= (maxx -1)) ? maxx-1 : x+1;
	    y = ( y >= maxy - 1 ) ? maxy -1 :  y+1;
		break;
	    case '9':
		x = ( x >= (maxx-1)) ? maxx - 1 : x+1;
		y = ( y <= (begy)) ? begy : y-1;
		break;
	    case 'c':
	    case 'C':
		sta_clear(); 
       showmsg("Cancelled!!");
       wrefresh(stdscr);
       ty=0;
       tx=0;
       sleep(1);
       status();
		return 0;
	    case '\r':
		ty=y;
		tx=x;
		return 1;
		break;
	    default :
		continue;
	}
wmove(winptr,y,x);		
sprintf(point,"%2d %2d",y,x);   
mvwprintw(stdscr,(MY+1),PX,"%s",point);
wrefresh(stdscr);
wrefresh(winptr);

    }
}

// Drawing Box in the Screen Along Corners.
draw_box(y1,x1,y2,x2)
	int x1,y1,x2,y2;
{
	int i,j;
	i=j=0;
	
	for(i=y1;i<=y2;i++)
	{
		mvwaddch(winptr,i,x1,D_CHAR);
		win[i][x1].pix = D_CHAR;
		mvwaddch(winptr,i,x2,D_CHAR);
		win[i][x2].pix = D_CHAR;
	}
	
	for(i=x1;i<=x2;i++)
	{
		mvwaddch(winptr,y1,i,D_CHAR);
		win[y1][i].pix = D_CHAR;
		mvwaddch(winptr,y2,i,D_CHAR);
		win[y2][i].pix = D_CHAR;
	}
	load_struc();
	BOX=0;
	status();
	return 1;
}
		
			
