#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "modes.h"

static Window reportwin;
static Display *display;
static int screen;
static GC gc;

void PositionReportWindow(Display *display,Window parent)
{
unsigned int x,y,width,height,border,depth;
Window rootret;
XGetGeometry(display,parent,&rootret,&x,&y,&width,&height,&border,&depth);
XMoveWindow(display,reportwin,0,height-24);
}

void InitReportWindow(Display *displaysrc,int screensrc,Window parent)
{
int depth;
XSetWindowAttributes attr;
XSizeHints hints;
XEvent event;
hints.flags=USPosition;
display=displaysrc;
screen=screensrc;
depth=DisplayPlanes(display,screen);
reportwin=XCreateWindow(display,parent,
0,480,480,24,1,depth,InputOutput,XDefaultVisual(display,screen),
0,&attr);
XSetStandardProperties(display,reportwin,
"Report Window","report",None,0,0,&hints);      
gc=XCreateGC(display,reportwin,0,0);
XSetWindowBackground(display,reportwin,WhitePixel(display,screen));
XSetForeground(display,gc,BlackPixel(display,screen));
XSetBackground(display,gc,WhitePixel(display,screen));
XClearWindow(display,reportwin);
XSelectInput(display,reportwin,ExposureMask);
XMapRaised(display,reportwin);
while (XNextEvent(display,&event),event.type!=Expose);
XClearWindow(display,reportwin);
XFlush(display);
PositionReportWindow(display,parent);
}

void ReportThat(char *str)
{
int f,g;
XSetForeground(display,gc,WhitePixel(display,screen));
XFillRectangle(display,reportwin,gc,0,0,480,24);
XSetForeground(display,gc,BlackPixel(display,screen));
XDrawImageString(display,reportwin,gc,12,12,str,strlen(str));
XFlush(display);
}

void CloseReportWindow()
{
XUnmapWindow(display,reportwin);
}

void OpenReportWindow()
{
XMapRaised(display,reportwin);
}

void ReportMode(int mode)
{
switch(mode)
 {
 case NOMODE:
  ReportThat("No mode is selected");
  break;
 case DRAWMODE:
  ReportThat("draw mode");
  break;
 case PICKCOLORMODE:
  ReportThat("pick foreground mode");
  break;
 case SELECTPIXEL:
  ReportThat("select pixel mode");
  break;
 case SELECTRECTAREA:
  ReportThat("select rectangle mode");
  break;
 case SELECTMAGIC:
  ReportThat("magic select mode");
  break;
 case SELECTOUTLINE:
  ReportThat("line select mode");
  break;
 case GRADIENTCIRC:
  ReportThat("grdient circle mode");
  break;
 case PICKBACKCOLMODE:
  ReportThat("pick background mode");
  break;
 case GRADIENTLINE:
  ReportThat("grdient linear mode");
  break;
 case CROPMODE:
  ReportThat("crop mode");
  break;
 case TEXTMODE:
  ReportThat("text mode");
  break;
 case MOVESELECTIONMODE:
  ReportThat("Selection move mode");
  break;
 case COPYSELECTIONMODE:
  ReportThat("Selection copy mode");
  break;
 case ROTATEMODE:
  ReportThat("rotate mode");
  break;
 case PASTEMODE:
  ReportThat("paste mode");
  break;
 case SCROLLMODE:
  ReportThat("scroll mode");
  break;
 }
}

