#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <malloc.h>
#include "doc.h"
#include "modes.h"
#include "doctypes.h"
#include "border.h"
#include <math.h>

static Display *display;
MemImage readjpg (char* filename);
char *browse(Display *display,Window parent);

int mode=DRAWMODE /*NOMODE*/;
int oldmode=DRAWMODE; /* used to remember mode when going into paste mode */

unsigned long ForeCol=0;
unsigned long BackCol=0xffffff;
unsigned int DotSize=3;


void connecttoserver()
{
display=XOpenDisplay("");
if (!display) {printf ("No X server found\n");exit(1);}
else
printf("connected\n");
}

void disconnect()
{
XCloseDisplay(display);
}

void invcode(char *codestr)
{
int f;
unsigned char c;
int x=strlen(codestr);
for (f=0;f<x;f++)
 {
 c=codestr[f];
 if (c>='a' && c<='z') c='a'+'z'-c;
 if (c>='A' && c<='Z') c='A'+'Z'-c;
 if (c>='0' && c<='9') c='0'+'9'-c;
 codestr[f]=c;
 }
}

main()
{
FILE *f1;
char str[256];
char *filename,*printfilename;
MemImage im;

Bool Exposing;

DocObj doc[16];
DocObj *secondoc,*channeler;
Bool secondex,channelex;

int activedoc=-1;

int temp;

Window menubar,menuwin,selbar,brushwin,colorwin;
Pixmap pixmap;
GC menugc,pixgc;
int screen,Width,Height,depth;
static XSetWindowAttributes attr;
XEvent event,l_event;
Colormap cmap;
int lastx,lasty;
int xdim=320,ydim=200;
float factora,factorb,Threshold;

int res,sres,ssres,f,g,sdoc;
char mainmenu[][20]={"File","Effects","View","Mode","Image","Change","edit"};
char filemenu[][20]={"Load","Save","Close","Quit","New (Create)",
"Print PS","Guess (Load any)","Acquire","save Type"};
char effectmenu[][20]={"Invert","Horrify","Blur more","Blur faster",
"Sharpen more","Sharpen faster","Emboss","r:Histgrm Strtch",
"Lighten","Darken","Brighten","Dullen","textures","Edge Threshold",
"Custom","Gamma Correct","Vertical Flip","Horizontal Flip","test"};
char viewmenu[][20]={"I:Zoom In","O:Zoom Out","Hide Selection",
"Show Selection","resolution","L:Selection Bar","Brush Window",
"P:Report window","Color Window"};
char modemenu[][20]={"Draw","Get Color","Select pixels",
"r:Select Rectangle","N:Select None","Magic Select",
"Line Select","Fill Gradient Circle","Backcolor get",
"I:Fill Gradient Line"};
char imagemenu[][20]={"Select second","Pick channeler","Merge","Add"};
char changemenu[][20]={"resize","Expand mask","D:reduse mask","Invert mask"};
XSizeHints hints;
char editmenu[][20]={"Undo","Fill","Draw Mode","Copy","Paste","Line mode","A:Undo Enabled","d:Undo Disabled"};
char drawmodemenu[][20]={"Normal","Lighter Only","Darker Only","Merge half"};
char colorsmenu[][20]={"Foreground","Background","White","Dark black"};
char texturemenu[][20]={"Clouds","Diagonal Cloud","Fract001","Stareogram","stare-cust","3D Side"};
char linemodemenu[][20]={"VerHor","Hollow","Normal"};
char savetypesmenu[][20]={"Jpeg Saving","Internal Image"};

Bool requestquit;

XColor red,blue;

char k;

void setforceactivedoc(int sd)
 {
 if (activedoc!=-1 && doc[activedoc].active) 
  {
  XSetWindowBackground(display,doc[activedoc].Twindow,blue.pixel);
  XSetBackground(display,doc[activedoc].gc,blue.pixel);
  XSetForeground(display,doc[activedoc].gc,red.pixel);
  ShowImage(&doc[activedoc]);
  }
 activedoc=sd;
 if (activedoc!=-1 && doc[activedoc].active) 
  {
  XSetWindowBackground(display,doc[activedoc].Twindow,red.pixel);
  XSetBackground(display,doc[activedoc].gc,red.pixel);
  XSetForeground(display,doc[activedoc].gc,blue.pixel);
  ShowImage(&doc[activedoc]);
  }
 }

void setactivedoc(int sd)
 {
 printf ("changing from %i to %i\n",activedoc,sd);
 if (activedoc==sd) return;
 if (activedoc!=-1 && doc[activedoc].active) 
  {
  XSetWindowBackground(display,doc[activedoc].Twindow,blue.pixel);
  XSetBackground(display,doc[activedoc].gc,blue.pixel);
  XSetForeground(display,doc[activedoc].gc,red.pixel);
  ShowImage(&doc[activedoc]);
  }
 activedoc=sd;
 if (activedoc!=-1 && doc[activedoc].active) 
  {
  XSetWindowBackground(display,doc[activedoc].Twindow,red.pixel);
  XSetBackground(display,doc[activedoc].gc,red.pixel);
  XSetForeground(display,doc[activedoc].gc,blue.pixel);
  ShowImage(&doc[activedoc]);
  }
 }

void displaynote()
{
int x,y;
char codestring[]="C Kslgl Vwrgli Xlkbirtsg 8001 yb  Zmwivzh Hlfkrzmzh";
char c;
float ang,r;
GC gc=XCreateGC(display,menuwin,0,0);
XSetBackground (display,gc,WhitePixel(display,screen));
XSetForeground (display,gc,BlackPixel(display,screen)); 
invcode (codestring);
for (x=0;x<256;x+=16)
 {
 XDrawLine(display,menuwin,gc,0,THEIGHT+256-x,x,THEIGHT);
 XDrawLine(display,menuwin,gc,512,THEIGHT+256-x,512-x,THEIGHT);
 }
/*
ang=0;
*/
ang=M_PI/4;
r=220;
for (x=0;x<strlen(codestring);x++)
 {
 c=codestring[x];
 XDrawString(display,menuwin,gc,256-r*cos(ang),256+THEIGHT-r*sin(ang),&c,1);
 ang=ang+24/r;
 if (ang>M_PI*3/4) 
  {
  ang=M_PI/4;
  r=r-20;
  }
 }
XFlush(display);
}

printfilename=malloc(40);
for (f=0;f<16;f++) doc[f].active=False;
for (f=0;f<16;f++) doc[f].refresh=False;
connecttoserver();

hints.flags=USPosition | PMinSize;/*USPosition; (for spesific positioning)*/

hints.min_width=400;
Width=720;
Height=540;
hints.min_height=320;
screen=DefaultScreen(display);


depth=DisplayPlanes(display,screen);
initpixelconvert(depth);
InitUndo();
InitClipboard();
menuwin=XCreateWindow(display,RootWindow(display,screen),
10,10,Width,Height,3,depth,InputOutput,
XDefaultVisual(display,screen),
CWColormap,&attr);
XSetStandardProperties(display,menuwin,"XPhotoEditor","main menu",None,0,0,&hints);
menugc=XCreateGC(display,menuwin,0,0);
XSetWindowBackground(display,menuwin,WhitePixel(display,screen));
XSetBackground (display,menugc,WhitePixel(display,screen));
XSetForeground (display,menugc,BlackPixel(display,screen)); 
XClearWindow(display,menuwin);
XSelectInput(display,menuwin,ExposureMask | ButtonPressMask | ButtonReleaseMask | KeyPressMask);
XMapRaised(display,menuwin);



menubar=XCreateWindow(display,menuwin,
0,0,Width,THEIGHT,3,depth,InputOutput,
XDefaultVisual(display,screen),
CWColormap,&attr);
XSetStandardProperties(display,menubar,"","",None,0,0,&hints);
XSetWindowBackground(display,menubar,WhitePixel(display,screen));
XClearWindow(display,menubar);
XSelectInput(display,menubar,ExposureMask | ButtonPressMask | ButtonReleaseMask | KeyPressMask);
XMapRaised(display,menubar);

cmap=DefaultColormap(display,screen);
red.red=65535;red.blue=49152;red.green=49152;
blue.red=0;blue.blue=32768;blue.green=0;
XAllocColor(display,cmap,&red);
XAllocColor(display,cmap,&blue);

pixmap=XCreatePixmap(display,menubar,Width,THEIGHT,depth);
pixgc=XCreateGC(display,pixmap,0,0);
XSetBackground(display,pixgc,WhitePixel(display,screen));
XSetForeground(display,pixgc,blue.pixel);
XFillRectangle(display,pixmap,pixgc,0,0,Width,THEIGHT);

for (f=0;f<7;f++)
 {
 XSetForeground(display,pixgc,BlackPixel(display,screen));
 XDrawString(display,pixmap,pixgc,1+f*60,THEIGHT+1-BORDERW,mainmenu[f],strlen(mainmenu[f]));
 XSetForeground(display,pixgc,WhitePixel(display,screen));
 XDrawString(display,pixmap,pixgc,f*60,THEIGHT-BORDERW,mainmenu[f],strlen(mainmenu[f]));
 XSetForeground(display,pixgc,WhitePixel(display,screen));
 XDrawLine(display,pixmap,pixgc,f*60-3,THEIGHT,f*60-3,0);
 XDrawLine(display,pixmap,pixgc,f*60+100,THEIGHT-1,f*60-3,THEIGHT-1);
 XSetForeground(display,pixgc,BlackPixel(display,screen));
 XDrawLine(display,pixmap,pixgc,f*60-2,THEIGHT,f*60-2,0);
 }
/*
XSetForeground(display,pixgc,blue.pixel);
XFillRectangle(display,pixmap,pixgc,0,13,1280,14);
*/
XSetForeground(display,pixgc,BlackPixel(display,screen));

XSetWindowBackgroundPixmap(display,menubar,pixmap);
XFreePixmap(display,pixmap);
XClearWindow(display,menubar);

InitializePalette(display,screen,depth);

selbar=CreateSelBar(display,screen);
brushwin=CreateBrushWindow(display,screen);
colorwin=CreateColorWindow(display,screen);
UpdateBrushDisplay(display,screen);
InitReportWindow(display,screen,menuwin);

displaynote();

res=-1;
requestquit=False;
while (!requestquit) /*main menu loop */
 {  
 res=-1;
 XNextEvent(display,&event);
 if (event.type==ButtonPress)
  {
  lastx=event.xbutton.x_root;lasty=event.xbutton.y_root;
  }
 if (event.type==MotionNotify && event.xmotion.state==Button1Mask)
  {
  for (f=0;f<16;f++)
   {
   if (doc[f].active && event.xmotion.window==doc[f].Twindow)
    {
    XMapRaised(display,doc[f].window);
    doc[f].x+=event.xmotion.x_root-lastx;
    doc[f].y+=event.xmotion.y_root-lasty;
    lastx=event.xmotion.x_root;
    lasty=event.xmotion.y_root;
    XMoveWindow(display,doc[f].window,doc[f].x,doc[f].y);
    setactivedoc(f);
    }
   } /* end for */
  } /* end check motion */
 if (event.type==ButtonPress && event.xbutton.button==1)
  {
  for (f=0;f<16;f++)
   {
   if (doc[f].active && event.xbutton.window==doc[f].Twindow)
    {
    printf ("select window\n");
    XMapRaised(display,doc[f].window);
    setactivedoc(f);
    }
   } /* end for */
  } /* end check click */       
 if (event.type==Expose)
  {
  for (f=0;f<16;f++)
   {
   if (doc[f].active && event.xexpose.window==doc[f].Iwindow)
    {
    doc[f].refresh=True;
/*
    printf ("refresh %i\n",f);
*/
    }
   }
  }
 if (event.type==ButtonRelease /* && event.xbutton.y<THEIGHT */ && event.xbutton.window==menubar)
  {
  res=event.xbutton.x/60;
  }
 if (event.type==KeyPress)
  {
  k=XLookupKeysym(&(event.xkey),event.xkey.state);
  for (f=0;f<7;f++) /* this must change if there are more menus */
   {
   if (k==*mainmenu[f]) res=f;
   }
  }
 if (event.type==Expose && event.xany.window==menuwin)
  {
  PositionReportWindow(display,menuwin);
  }
 if (res==0) /*file menu */
  {
  sres=menu(display,menuwin,filemenu,0,15,9,0);
  setwaitcurs(display,menuwin,screen,cmap);
  if (sres==0) /* load option */
   {
   sdoc=-1;
   for (f=15;f>=0;f--) if (!doc[f].active) sdoc=f;
   printf ("doc to load:%i",sdoc);
   if (sdoc>=0) /* we have free doc handlers */
    {
    filename=browse(display,menuwin); 
    doc[sdoc].parent=menuwin;
    doc[sdoc].display=display;
    doc[sdoc].screen=screen;
    doc[sdoc].cmap=DefaultColormap(display,screen);
    createanydoc(&doc[sdoc],filename,JPG_DOC);
    if (doc[sdoc].img.X!=0) setactivedoc(sdoc);
    }
   else
    {
    printf ("there are no free document handlers\n");
    } /* end load document */
   } /* end load option */
  if (sres==1 && activedoc!=-1) /* save option */
   {
   filename=doc[activedoc].filename;
   ask("Please enter the filename to save:",filename,display);
   writeselected(filename,doc[activedoc].img); 
   printf ("saved %s\n",filename);
   } /* end save option */
  if (sres==2 && activedoc!=-1) /* close option */
   {
   printf ("destroying\n");
   destroydoc(&doc[activedoc]);
   printf ("looking for other active\n");
   sdoc=15;
   while (!doc[sdoc].active && sdoc>-1) sdoc--;
   printf ("seting active\n");
   setactivedoc(sdoc);
   } /* end close option */
  if (sres==3) /* quit option */
   {
   requestquit=True;
   } /* end quit option */
  if (sres==4) /* create option */
   {
   sdoc=-1;
   for (f=15;f>=0;f--) if (!doc[f].active) sdoc=f;
   printf ("doc to load:%i",sdoc);
   if (sdoc>=0) /* we have free doc handlers */
    {
    doc[sdoc].parent=menuwin;
    doc[sdoc].display=display;
    doc[sdoc].screen=screen;
    doc[sdoc].cmap=DefaultColormap(display,screen);
    getdim(&xdim,&ydim,display);
    createanydocofsize(&doc[sdoc],"untitled",NEW_DOC,xdim,ydim);
    printf ("active is %i lets make %i active\n",activedoc,sdoc);
    if (doc[sdoc].img.X!=0) setactivedoc(sdoc);
    printf ("active ok\n");
    }
   else
    {
    printf ("there are no free document handlers\n");
    } /* end create document */
   } /* end create option */
  if (sres==5 && activedoc!=-1) /* print ps option */
   {
   sprintf (printfilename,"%s.ps",doc[activedoc].filename);
   ask("Please enter the filename to print:",printfilename,display);
   printps(printfilename,doc[activedoc].img); 
   } /* end print ps option */
  if (sres==6) /* load any file option */
   {
   sdoc=-1;
   for (f=15;f>=0;f--) if (!doc[f].active) sdoc=f;
   printf ("doc to load:%i",sdoc);
   if (sdoc>=0) /* we have free doc handlers */
    {
    filename=browse(display,menuwin); 
    doc[sdoc].parent=menuwin;
    doc[sdoc].display=display;
    doc[sdoc].screen=screen;
    doc[sdoc].cmap=DefaultColormap(display,screen);
    createanydoc(&doc[sdoc],filename,GUESS_DOC);
    if (doc[sdoc].img.X!=0) setactivedoc(sdoc);
    }
   else
    {
    printf ("there are no free document handlers\n");
    } /* end load any document */
   } /* end load any option */
  if (sres==7) /* scan option */
   {
   sdoc=-1;
   for (f=15;f>=0;f--) if (!doc[f].active) sdoc=f;
   printf ("doc to scan:%i",sdoc);
   if (sdoc>=0) /* we have free doc handlers */
    {
    filename="/dev/scanner"; 
    doc[sdoc].parent=menuwin;
    doc[sdoc].display=display;
    doc[sdoc].screen=screen;
    doc[sdoc].cmap=DefaultColormap(display,screen);
    createanydoc(&doc[sdoc],filename,SCAN_DOC);
    if (doc[sdoc].img.X!=0) setactivedoc(sdoc);
    }
   else
    {
    printf ("there are no free document handlers\n");
    } /* end scan document */
   } /* end scan option */  
  if (sres==8) /* Save Type option */
   {
   setnormalcurs(display,menuwin);
   ReportSaveType();
   ssres=menu(display,menuwin,savetypesmenu,20,110,2,0);
   if (ssres==0) SetSelectedType(JPG_DOC);  /* save as jpeg  */
   if (ssres==1) SetSelectedType(IIM_DOC);  /* save as internal image  */
   }
  setnormalcurs(display,menuwin);
  printf ("file menu exiting\n");
  } /* end file menu */
 if (res==1) /* effects menu */
  {
  sres=menu(display,menuwin,effectmenu,60,15,18,0);
  setwaitcurs(display,menuwin,screen,cmap);
  if (sres==0 && activedoc!=-1) /* invert option */
   {
   SaveDoc(&doc[activedoc]);
   InvertIm(&doc[activedoc]);
   }
  if (sres==1 && activedoc!=-1) /* horrify option */
   {
   SaveDoc(&doc[activedoc]);
   HorrifyIm(&doc[activedoc]);
   }
  if (sres==2 && activedoc!=-1) /* blur more option */
   {
   SaveDoc(&doc[activedoc]);
   BlurIm(&doc[activedoc]);
   }
  if (sres==3 && activedoc!=-1) /* blur fast option */
   {
   SaveDoc(&doc[activedoc]);
   BlurFastIm(&doc[activedoc]);
   }
  if (sres==4 && activedoc!=-1) /* sharpen more option */
   {
   SaveDoc(&doc[activedoc]);
   SharpenIm(&doc[activedoc]);
   }
  if (sres==5 && activedoc!=-1) /* sharpen fast option */
   {
   SaveDoc(&doc[activedoc]);
   SharpenFastIm(&doc[activedoc]);
   }
  if (sres==6 && activedoc!=-1) /* emboss option */
   {
   SaveDoc(&doc[activedoc]);
   EmbossIm(&doc[activedoc]);
   }
  if (sres==7 && activedoc!=-1) /* stretch histogram option */
   {
   SaveDoc(&doc[activedoc]);
   StretchHistogramIm(&doc[activedoc]);
   }
  if (sres==8 && activedoc!=-1) /* lighter option */
   {
   SaveDoc(&doc[activedoc]);
   factora=10;
   getfactor(&factora,display);
   ShiftBrightIm(&doc[activedoc],(int) factora);
   }
  if (sres==9 && activedoc!=-1) /* darker option */
   {
   SaveDoc(&doc[activedoc]);
   factora=-10;
   getfactor(&factora,display);
   ShiftBrightIm(&doc[activedoc],(int) factora);
   }
  if (sres==10 && activedoc!=-1) /* brighter option */
   {
   SaveDoc(&doc[activedoc]);
   factora=20;
   getfactor(&factora,display);
   MulBrightIm(&doc[activedoc],256+(int)factora);
   }
  if (sres==11 && activedoc!=-1) /* duller option */
   {
   SaveDoc(&doc[activedoc]);
   factora=24;
   getfactor(&factora,display);
   MulBrightIm(&doc[activedoc],256-(int)factora);
   }
  if (sres==12 && activedoc!=-1) /* Texture option */
   {
   setnormalcurs(display,menuwin);
   ssres=menu(display,menuwin,texturemenu,80,155,6,0);
   setwaitcurs(display,menuwin,screen,cmap);
   if (ssres==0)  /* Clouds option  */
    {
    SaveDoc(&doc[activedoc]);
    TextureCloudIm(&doc[activedoc]);
    } /* end clouds */
   if (ssres==1)  /* Diagonal Clouds option  */
    {
    SaveDoc(&doc[activedoc]);
    TextureDiagonalCloudIm(&doc[activedoc]);
    } /* end diag cloud */
   if (ssres==2)  /* Fract 001 option  */
    {
    SaveDoc(&doc[activedoc]);
    TextureFract001Im(&doc[activedoc]);
    } /* end fract 001 */
   if (ssres==3)  /* Stareogram option  */
    {
    SaveDoc(&doc[activedoc]);
    TextureStareogramIm(&doc[activedoc]);
    } /* end Stareogram */
   if (ssres==4)  /* Stareogram no random option  */
    {
    SaveDoc(&doc[activedoc]);
    TextureStareogramNoRandIm(&doc[activedoc]);
    } /* end Stareogram no rand */
   if (ssres==5)  /* 3D Side  */
    {
    SaveDoc(&doc[activedoc]);
    Texture3DSideIm(&doc[activedoc]);
    } /* end 3D Side */
   } /* end Texture option */
  if (sres==13 && activedoc!=-1) /* edge threshold */
   {
   SaveDoc(&doc[activedoc]);
   Threshold=10;
   getfactor(&Threshold,display);
   ThresEdge1Im(&doc[activedoc],(int) Threshold);
   } /* end edge threshold */
  if (sres==14 && activedoc!=-1) /* custom filter */
   {
   SaveDoc(&doc[activedoc]);
   CustomEffectIm(&doc[activedoc]);
   } /* end custom filter */
  if (sres==15 && activedoc!=-1) /* gamma correction */
   {
   SaveDoc(&doc[activedoc]);
   GammaDocIm(&doc[activedoc]);
   } /* end gamma */
  if (sres==16 && activedoc!=-1) /* vertical flip */
   {
   SaveDoc(&doc[activedoc]);
   FlipVerIm(&doc[activedoc]);
   } /* end ver flip */
  if (sres==17 && activedoc!=-1) /* horizontal flip */
   {
   SaveDoc(&doc[activedoc]);
   FlipHorIm(&doc[activedoc]);
   } /* end horizontal flip */
  if (sres==18 && activedoc!=-1) /* Test option */
   {
   SaveDoc(&doc[activedoc]);
   printf ("startx is %i\n",doc[activedoc].startx);
   DrawTextOnSelMask(&doc[activedoc],0,0,"the text");
/*
   DrawLineOnSelMask(&doc[activedoc]);
*/
   ShowImage(&doc[activedoc]);
   CloseReportWindow();
   }
  setnormalcurs(display,menuwin);
  } /* end effect menu */
 if (res==2) /* view menu */
  {
  sres=menu(display,menuwin,viewmenu,120,15,9,0);
  setwaitcurs(display,menuwin,screen,cmap);
  if (sres==0 && activedoc!=-1) /* Zoom in option */
   {
   ZoomInImage(&doc[activedoc]);
   }
  if (sres==1 && activedoc!=-1) /* Zoom out option */
   {
   ZoomOutImage(&doc[activedoc]);
   }
  if (sres==2 && activedoc!=-1) /* Hide selection */
   {
   ReloadImage(&doc[activedoc]);
   ShowImage(&doc[activedoc]);
   }
  if (sres==3 && activedoc!=-1) /* Show selection */
   {
   UpdateWholeDocView(&doc[activedoc]);
   }
  if (sres==4 && activedoc!=-1) /* Display Information */
   {
   ShowDocInfo(&doc[activedoc]);
   }
  if (sres==5) /* show selection bar */
   {
   ShowSelBar(display,screen);
   /*  uncomment this to make it on-off function */
   /*  XUnmapWindow(display,selbar); */
   } /* end show selection bar */
  if (sres==6) /* show brush window */
   {
   ShowBrushWindow(display,screen);
   } /* end show brush window */
  if (sres==7) /* show report window */
   {
   OpenReportWindow(display,screen);
   } /* end show brush window */
  if (sres==8) /* show color window */
   {
   ShowColorWindow(display,screen);
   } /* end show color window */
  setnormalcurs(display,menuwin);
  } /* end view menu */
 if (res==3) /* mode menu */
  {
  sres=menu(display,menuwin,modemenu,180,15,10,0);
  if (sres==0 && activedoc!=-1) /* Draw mode */
   {
   mode=DRAWMODE; 
   ReportMode(mode);
   printf("reported Draw mode\n");
   setnormalcurs(display,menuwin);
   }
  if (sres==1 && activedoc!=-1) /* Pick color mode */
   {
   mode=PICKCOLORMODE;
   ReportMode(mode);
     /* rem out - its annoying
   setpickcurs(display,menuwin,screen,cmap);
     */
   }
  if (sres==2 && activedoc!=-1) /* Select pixel */
   {
   mode=SELECTPIXEL;
   ReportMode(mode);
   }
  if (sres==3 && activedoc!=-1) /* Select area */
   {
   mode=SELECTRECTAREA;
   ReportMode(mode);
   }
  if (sres==4 && activedoc!=-1) /* Clear selection and set draw mode*/
   {
   SaveDoc(&doc[activedoc]);
   mode=DRAWMODE; 
   ReportMode(mode);
   ClearMask(&doc[activedoc]);
   UpdateWholeDocView(&doc[activedoc]);
   }
  if (sres==5 && activedoc!=-1) /* Select magic */
   {
   mode=SELECTMAGIC;
   ReportMode(mode);
   }
  if (sres==6 && activedoc!=-1) /* Select lines */
   {
   mode=SELECTOUTLINE;
   ReportMode(mode);
   }
  if (sres==7 && activedoc!=-1) /* Gradient circle */
   {
   mode=GRADIENTCIRC;
   ReportMode(mode);
   } /* end gradient circle */
  if (sres==8 && activedoc!=-1) /* Pick color mode */
   {
   mode=PICKBACKCOLMODE;
   ReportMode(mode);
   printf ("picking background color\n");
   } /* end pick background */
  if (sres==9 && activedoc!=-1) /* Gradient line */
   {
   mode=GRADIENTLINE;
   ReportMode(mode);
   } /* end gradient line */
  ShowModeButton(display,screen);
  } /* end mode menu*/
 if (res==4) /* image menu */
  {
  sres=menu(display,menuwin,imagemenu,240,15,4,0);
  if (sres==0 && activedoc!=-1) /* Select second */
   {
   secondoc=&doc[activedoc];
   ShowDocInfoAnd(secondoc,"Second image selected:");
   }
  if (sres==1 && activedoc!=-1) /* Pick channeler */
   {
   channeler=&doc[activedoc];
   ShowDocInfoAnd(channeler,"Channel Selected:");
   }
  if (sres==2 && activedoc!=-1)  /* Merge - Must add check for existanse */
   {
   secondex=channelex=False; 
   for (f=0;f<16;f++)
    {
    printf ("%i %i %i\n",secondoc,channeler,&doc[f]);
    if ((secondoc==&doc[f]) && doc[f].active) secondex=True;
    if ((channeler==&doc[f]) && doc[f].active) channelex=True;
    }
   if (secondex && channelex)
    {
    setwaitcurs(display,menuwin,screen,cmap);
    SaveDoc(&doc[activedoc]);
    MergeDocsWrapIm(&doc[activedoc],secondoc,channeler);
    setnormalcurs(display,menuwin);
    }
   } /* end Merge */
  if (sres==3 && activedoc!=-1)  /* Add - Must add check for existanse */
   {
   secondex=False; 
   for (f=0;f<16;f++)
    {
    if ((secondoc==&doc[f]) && doc[f].active) secondex=True;
    }
   if (secondex)
    {
    setwaitcurs(display,menuwin,screen,cmap);
    SaveDoc(&doc[activedoc]);
    AddDocsWrapIm(&doc[activedoc],secondoc);
    setnormalcurs(display,menuwin);
    }
   } /* end add */
  } /* end image menu */
 if (res==5) /* change menu */
  {
  sres=menu(display,menuwin,changemenu,300,15,4,0);
  if (sres==0 && activedoc!=-1) /* Resize */
   {
   sdoc=-1;
   for (f=15;f>=0;f--) if (!doc[f].active) sdoc=f;
   printf ("doc to resize to:%i\n",sdoc);
   if (sdoc>=0) /* we have free doc handlers */
    {
    SaveDoc(&doc[activedoc]);
    xdim=doc[activedoc].img.X;
    ydim=doc[activedoc].img.Y;
    getdim(&xdim,&ydim,display);
    ResizeDoc(&doc[activedoc],&doc[sdoc],xdim,ydim);
    if (doc[sdoc].img.X!=0) setactivedoc(sdoc);
    }
   else
    {
    printf ("there are no free document handlers\n");
    } /* end resize doc */
   } /* end resize option */
  if (sres==1 && activedoc !=-1) /* expand */
   {
   ExpandSelMask(&doc[activedoc]);
   } /* end expand */
  if (sres==2 && activedoc !=-1) /* reduce */
   {
   ReduceSelMask(&doc[activedoc]);
   } /* end reduce */
  if (sres==3 && activedoc !=-1) /* invert */
   {
   InvertSelMask(&doc[activedoc]);
   } /* end reduce */
  } /* end of change menu */
 if (res==6) /* edit menu */
  {
  sres=menu(display,menuwin,editmenu,360,15,8,0);
  if (sres==0 && activedoc!=-1) /* load to undo */
   {
   LoadDoc(&doc[activedoc]);
   UpdateWholeDocView(&doc[activedoc]);
   } /* end undo */ 
  if (sres==1 && activedoc!=-1) /* fill area */
   {
   ssres=menu(display,menuwin,colorsmenu,380,35,4,0);
   if (ssres==0 || ssres==1 || ssres==2 || ssres==3) SaveDoc(&doc[activedoc]);
   if (ssres==0) DocFill(&doc[activedoc],ForeCol);  /* fore  */
   if (ssres==1) DocFill(&doc[activedoc],BackCol);  /* back  */
   if (ssres==2) DocFill(&doc[activedoc],0xffffff); /* white */
   if (ssres==3) DocFill(&doc[activedoc],0);        /* black */
   } /* end fill */
  if (sres==2) /* draw mode menu */
   {
   ssres=menu(display,menuwin,drawmodemenu,380,45,4,0);
    {
    if (ssres==0) SetDocPixelModeNormal();
    if (ssres==1) SetDocPixelModeIfLighter();
    if (ssres==2) SetDocPixelModeIfDarker();
    if (ssres==3) SetDocPixelModeMergeHalf();
    }
   } /* end draw mode */
  if (sres==3 && activedoc!=-1) /* copy */
   {
   CopyDoc(&doc[activedoc]);
   } /* end copy */
  if (sres==4 && activedoc!=-1) /* paste selection */
   {
   oldmode=mode;
   mode=PASTEMODE;
   PasteSelMaskFromClipbrd(&doc[activedoc],0,0,False);
   ReportMode(mode);
   } /* end paste selection */
  if (sres==5) /* line mode menu */
   {
   ssres=menu(display,menuwin,linemodemenu,380,45,3,0);
    {
    if (ssres==0) SetLineDrawingHorVer();
    if (ssres==1) SetLineDrawingHollow();
    if (ssres==2) SetLineDrawingNormal();
    }
   } /* end line mode */
  if (sres==6) EnableUndo();
  if (sres==7) DisableUndo();
  } /* end of edit menu */


/* should restore pick cursor after wait prosess but its annoying so remark out*/
/*
 if (mode==PICKCOLORMODE) setpickcurs(display,menuwin,screen,cmap);
*/

 /* the scroll and resize handler */
 for (f=0;f<16;f++)
  {
  if (doc[f].active)
   {
   HorScroll(&doc[f],&event);
   VerScroll(&doc[f],&event);
   HandleResize(&doc[f],&event); 
   }
  }

 /* the controlbox handler */
 for (f=0;f<16;f++)
  {
  if (doc[f].active)
   {
   sres=HandleControlBox(&doc[f],&event);
   if (sres==1) /* close option */
    {
    printf ("destroying\n");
    destroydoc(&doc[f]);
    printf ("looking for other active\n");
    sdoc=15;
    while (!doc[sdoc].active && sdoc >-1) sdoc--;
    printf ("seting active\n");
    setactivedoc(sdoc);
    } /* end close option */
   if (sres==2) /* save option */
    {
    filename=doc[f].filename;
    ask("Please enter the filename to save:",filename,display);
    writeselected(filename,doc[f].img); 
    printf ("saved %s\n",filename);
    } /* end save option */
   if (sres==3) /* create same canvas option */
    {
    sdoc=-1;
    for (g=15;g>=0;g--) if (!doc[g].active) sdoc=g;
    printf ("doc to load:%i",sdoc);
    if (sdoc>=0) /* we have free doc handlers */
     {
     doc[sdoc].parent=menuwin;
     doc[sdoc].display=display;
     doc[sdoc].screen=screen;
     doc[sdoc].cmap=DefaultColormap(display,screen);
     createanydocofsize(&doc[sdoc],"untitled",NEW_DOC,doc[f].img.X,doc[f].img.Y);
     if (doc[sdoc].img.X!=0) setactivedoc(sdoc);
     }
    else
     {
     printf ("there are no free document handlers\n");
     } /* end create document */
    } /* end create same canvas */
   if (sres==4) /* refresh option */
    {
    UpdateWholeDocView(&doc[f]);
    }
   }
  }
 
 switch (HandleSelBar(display,screen,&event))
  {
  case 1: XUnmapWindow(display,selbar); break;
  case 2: /* user selected NOMODE at top of Selection bar */ 
   if (activedoc!=-1)
    {
    SaveDoc(&doc[activedoc]);
    ReportMode(mode);
    ClearMask(&doc[activedoc]);
    UpdateWholeDocView(&doc[activedoc]);
    }
   break;
  default:
  }



 if (HandleBrushWindow(display,screen,&event)) XUnmapWindow(display,brushwin);
 if (HandleColorWindow(display,screen,&event)) XUnmapWindow(display,colorwin);

 if (activedoc!=-1)
  {
  switch (mode)
   {
   case DRAWMODE:
    HandleDrawing(&doc[activedoc],&event);
    break;
   case PICKCOLORMODE:
    HandlePickCol(&doc[activedoc],&event);
    break;
   case SELECTPIXEL:
    HandleSelectPixel(&doc[activedoc],&event);
    break;
   case SELECTRECTAREA:
    HandleSelectRectArea(&doc[activedoc],&event);
    break;
   case SELECTMAGIC:
    HandleSelectMagic(&doc[activedoc],&event);
    break;
   case SELECTOUTLINE:
    HandleSelectOutline(&doc[activedoc],&event);
    break;
   case GRADIENTCIRC:
    HandleFillGradCirc(&doc[activedoc],&event);
    break;
   case PICKBACKCOLMODE:
    HandlePickBackCol(&doc[activedoc],&event);
    break;
   case GRADIENTLINE:
    HandleFillGradLine(&doc[activedoc],&event);
    break;
   case CROPMODE:
    if (HandleCropImage(&doc[activedoc],&event)) 
     {
     temp=activedoc;
     setactivedoc(-1);
     setactivedoc(temp);
     }
    break;
   case TEXTMODE:
    HandleSelectText(&doc[activedoc],&event);
    break;
   case MOVESELECTIONMODE:
    HandleMoveSelection(&doc[activedoc],&event);
    break;
   case COPYSELECTIONMODE:
    HandleCopySelection(&doc[activedoc],&event);
    break;
   case ROTATEMODE:
    HandleRotateSelection(&doc[activedoc],&event);
    break;
   case PASTEMODE:
    HandlePasteFromClipbrd(&doc[activedoc],&event);
    break;
   case SCROLLMODE:
    HandleMouseScroll(&doc[activedoc],&event);
    break;
   default:
   }
  }
 
/* the old drawmode handler is now remarked out*/
/*
 for (f=0;f<16;f++)
  {
  if (doc[f].active && mode==DRAWMODE)
   {
   HandleDrawing(&doc[f],&event); 
   }
  }
*/

/* old button 3 handler remarked out */
/*
 if (activedoc!=-1 && event.type==MotionNotify && event.xmotion.window==doc[activedoc].Iwindow && event.xmotion.state==Button3Mask)
  {
  SetDocVirPixel(&doc[activedoc],event.xmotion.x,event.xmotion.y,1+GetDocVirPixel(&doc[activedoc],event.xmotion.x,event.xmotion.y));
  }
*/

 Exposing=False;
 for (f=0;f<16;f++)
  { 
  if (doc[f].active )
   {
    if (XCheckWindowEvent(display,doc[f].Iwindow,ExposureMask,&l_event))
    {
     XPutBackEvent(display,&l_event);
     Exposing=True;
    }
   }
  }
  if (Exposing==False)
   {
   for (f=0;f<16;f++)
    {
    if (doc[f].refresh)
     {
     ShowImage(&doc[f]);
     doc[f].refresh=False;
     }     
    }
   }
 XSelectInput(display,menuwin,ExposureMask | ButtonPressMask | ButtonReleaseMask | KeyPressMask /* | PointerMotionMask*/);
 } /* end main menu loop */
FreeUndo();
FreeClipboard();
disconnect();
}













