#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <math.h>
#include "doc.h"

Display *display;
Window window;
int screen,depth;
GC gc;
XSetWindowAttributes attr;
XSizeHints hints;
XEvent event,l_event;

extern unsigned long(*ConvPixel) (int red,int green,int blue,int depth);

void GammaDocIm(DocObj *doc)
{
int x,y,pl;
static int CurX,CurY;
Bool QuitFlag;
unsigned char ModMap[256];
float gamma=1.0;
MemImage im=doc->img;
unsigned char *data;

void line(int x,int y,int x1,int y1)
{
XDrawLine(display,window,gc,x,y,x1,y1);
CurX=x1;CurY=y1;
}

void lineto(int x,int y)
{
XDrawLine(display,window,gc,x,y,CurX,CurY);
CurX=x;CurY=y;
}

void linestep(int x,int y)
{
XDrawLine(display,window,gc,CurX+x,CurY+y,CurX,CurY);
CurX+=x;CurY+=y;
}

void SetGammaTable()
{
int f;
float v,nv;
for (f=0;f<256;f++)
 {
 v=((float)f)/255;
 nv=pow(v,gamma)*255;
 ModMap[f]=(int)nv;
 /*
 if (!(f%15)) printf ("%f %f %f %i\n",nv,v,gamma,f);
 */
 }
}

Bool CheckClick(XEvent event,int x,int y,int w,int h)
{
int xp,yp;
xp=event.xbutton.x;
yp=event.xbutton.y;
if  (xp>=x && yp>=y && xp<=x+w && yp<=y+h) return True;
return False;
}

void DrawTheWindow()
{
unsigned long color;
unsigned char red,green,blue;
XClearWindow(display,window);
SetGammaTable();
XSetForeground(display,gc,BlackPixel(display,screen));
for (x=0;x<255;x++) XDrawPoint(display,window,gc,x,300-ModMap[x]);
for (y=0;y<32;y++)
for (x=0;x<32;x++)
 {
 color=GetDocPixel(doc,x,y);
 red=color&255;
 green=(color>>8)&255;
 blue=(color>>16)&255;
 red=ModMap[red];
 green=ModMap[green];
 blue=ModMap[blue];
 XSetForeground(display,gc,ConvPixel((int)red,(int)green,(int)blue,depth));
 XDrawPoint(display,window,gc,x,y+40);
 }
XSetForeground(display,gc,BlackPixel(display,screen));
XDrawRectangle (display,window,gc,10,20,256,10);
XDrawRectangle (display,window,gc,270,30,30,30);
XDrawRectangle (display,window,gc,270,70,30,30);
/* draw ok button */
line (275,35,280,55);
lineto(300,32);
/* draw cancel button */
line (275,75,295,95);
line (275,95,295,75);
/* draw gamma slider */
line (10+gamma*100,10,15+gamma*100,5);
linestep(-10,0);
linestep(5,5);

for (y=0;y<255;y++)
for (x=0;x<256;x++)
 {
 if (x==255 && XCheckWindowEvent(display,window, PointerMotionMask | ButtonPressMask,&l_event))
  {
  if (l_event.type==MotionNotify && l_event.xmotion.state==Button1Mask) y=255;
  if (l_event.type==ButtonPress)
   {
   y=255;
   printf ("click\n");
   XPutBackEvent(doc->display,&l_event);
   }
  }
 color=GetDocPixel(doc,x,y);
 red=color&255;
 green=(color>>8)&255;
 blue=(color>>16)&255;
 red=ModMap[red];
 green=ModMap[green];
 blue=ModMap[blue];
 XSetForeground(display,gc,ConvPixel((int)red,(int)green,(int)blue,depth));
 XDrawPoint(display,window,gc,x,y+40);
 }
XSetForeground(display,gc,WhitePixel(display,screen));
for (x=0;x<255;x++) XDrawPoint(display,window,gc,x,299-ModMap[x]);
XSetForeground(display,gc,BlackPixel(display,screen));
for (x=0;x<255;x++) XDrawPoint(display,window,gc,x,300-ModMap[x]);
XFlush(display);
}

display=doc->display;
screen=DefaultScreen(display);
depth=DisplayPlanes(display,screen);
hints.flags=USPosition;
attr.save_under=True;
window=XCreateWindow(display,RootWindow(display,screen),
40,40,320,320,1,depth,InputOutput,XDefaultVisual(display,screen),
CWSaveUnder ,&attr);
XSetStandardProperties(display,window,"Gamma correction","gamma",None,0,0,&hints);
gc=DefaultGC(display,screen);
XSetWindowBackground(display,window,WhitePixel(display,screen));
XSetForeground(display,gc,BlackPixel(display,screen));
XClearWindow(display,window);
XMapRaised(display,window);
XSelectInput(display,window,ExposureMask | PointerMotionMask | ButtonPressMask);
while(XNextEvent(display,&event),event.type!=Expose || event.xbutton.window!=window);
DrawTheWindow();
QuitFlag=False;
while (!QuitFlag) /* loop */
 {
 XNextEvent(display,&event);
 if (event.type==MotionNotify && event.xmotion.window==window && event.xmotion.state==Button1Mask) /* pointer drag */
  {
  x=event.xmotion.x;
  y=event.xmotion.y;
  if (y<20 && x>10 && x<266) /* gamma drag */
   {
   gamma=((float)x-10)/100;
   if (XCheckWindowEvent(display,window,PointerMotionMask,&l_event))
    {
    XPutBackEvent(doc->display,&l_event);
    }
   else
    {
    DrawTheWindow();
    }
   } /* end gamma drag */
  } /* end pointer drag */
 if (event.type==ButtonPress)
  {
  if (CheckClick(event,270,30,30,30)) /* click on ok */
   {
   QuitFlag=True;
   } /* end click on ok */
  if (CheckClick(event,270,70,30,30)) /* cancel */
   {
   XDestroyWindow(display,window);
   return;
   } /* end cancel */
  } /* end button press */
 } /* end loop */
XDestroyWindow(display,window);
ReportThat("gamma correction please wait");
for (pl=0;pl<im.Planes;pl++)
for (x=0;x<im.X;x++)
for (y=0;y<im.Y;y++)
if (UseMaskPixel(doc,x,y))
 {
 data=im.data+(x+y*im.X)*im.Planes+pl;
 *data=ModMap[(int)(*data)];
 }
ReportThat("gamma correction done");
UpdateWholeDocView(doc);
}

