#include <string.h>
#include <X11/Xlib.h>
#include "doc.h"
#include "border.h"
#include "doctypes.h"

MemImage readscan(char *filename,Display *display);
MemImage readjpg(char *filename);
MemImage readiimg(char *filename);
MemImage readpcx(char *filename);
MemImage blankimage(int x,int y);
void ShowImage(DocObj *doc);
void ShowMessage(char *Title,char *text,Display *display);

void destroydoc(DocObj *doc)
{
printf("set false\n");
doc->active=False;
printf ("destroy gc\n");
XFreeGC(doc->display,doc->gc);
printf ("destroy win \n");
XDestroyWindow(doc->display,doc->Iwindow);
printf ("destroy win \n");
XDestroyWindow(doc->display,doc->Twindow);
printf ("destroy win \n");
XDestroyWindow(doc->display,doc->window);
printf ("destroy colormap \n");
XFreeColormap(doc->display,doc->cmap);
printf ("destroy image data \n");
/*
free(doc->image->data);
*/
printf ("destroy image \n");
XDestroyImage(doc->image);
printf ("free image \n");
free(doc->img.data);
free(doc->selmask);
}

void createanydocofsize(DocObj *doc,char *filename,int type,int xsize,int ysize)
{
XEvent event;
GC gc;
Pixmap pixmap;
doc->depth=DisplayPlanes(doc->display,doc->screen);
doc->active=True;
if (type==GUESS_DOC) type=guessformat(filename);
switch(type)
 {
 case SCAN_DOC:
  doc->img=readscan(filename,doc->display);
  filename="scanned";
  break;
 case JPG_DOC:
  doc->img=readjpg(filename);
  break;
 case IIM_DOC:
  doc->img=readiimg(filename);
  break;
 case PCX_DOC:
  doc->img=readpcx(filename);
  break;
 case GUESS_DOC: /* we dont know so lets try jpg anyway */
  ReportThat("Could not guess format. Trying jpeg anyway....");
  doc->img=readjpg(filename);  
  break;
 default:
  doc->img=blankimage(xsize,ysize);
 }
if (doc->img.X==0)
 {
 doc->active=False;
 ShowMessage("ERROR",doc->img.data,doc->display);
 free (doc->img.data);
 return;
 }
doc->Width=doc->img.X;doc->Height=doc->img.Y;
doc->x=40;doc->y=THEIGHT*2;
doc->startx=doc->starty=0;
doc->zoomin=1;doc->zoomout=1;
doc->win_w=doc->Width;
doc->win_h=doc->Height;
while (doc->win_w>640 || doc->win_h>480)
 {
 doc->zoomout++;
 doc->win_w=doc->Width/doc->zoomout;
 doc->win_h=doc->Height/doc->zoomout;
 }
CreateEmptyMask(doc);
doc->window=XCreateWindow(doc->display,doc->parent,
doc->x,doc->y,doc->win_w+BORDERW*2,doc->win_h+THEIGHT+BORDERW*4,BORDERW,
doc->depth,InputOutput,
XDefaultVisual(doc->display,doc->screen),
0,&(doc->attr));
XSetStandardProperties(doc->display,doc->window,filename,filename,None,0,0,0);
doc->gc=XCreateGC(doc->display,doc->window,0,0);
XSelectInput(doc->display,doc->window,ExposureMask | ButtonPressMask | PointerMotionMask | ButtonReleaseMask);
XMapRaised(doc->display,doc->window);
while (XNextEvent(doc->display,&event),event.type!=Expose);
printf ("create controlbox\n");
doc->controlbox=XCreateWindow(doc->display,doc->window,
BORDERW,BORDERW,THEIGHT,THEIGHT,0,doc->depth,InputOutput,
XDefaultVisual(doc->display,doc->screen),0,&(doc->attr));
XSetStandardProperties(doc->display,doc->controlbox,"","",None,0,0,0);
XSelectInput(doc->display,doc->controlbox,ExposureMask | ButtonPressMask |  ButtonReleaseMask | KeyPressMask);
XMapRaised(doc->display,doc->controlbox);
while (XNextEvent(doc->display,&event),event.type!=Expose);
pixmap=XCreatePixmap(doc->display,doc->window,THEIGHT,THEIGHT,doc->depth);
gc=XCreateGC(doc->display,pixmap,0,0);
XSetForeground(doc->display,gc,WhitePixel(doc->display,doc->screen));
XFillRectangle(doc->display,pixmap,gc,0,0,THEIGHT,THEIGHT);
XSetForeground(doc->display,gc,BlackPixel(doc->display,doc->screen));
XSetBackground(doc->display,gc,WhitePixel(doc->display,doc->screen));
/*
XDrawLine(doc->display,pixmap,gc,BORDERW,THEIGHT/2,THEIGHT-BORDERW*2,THEIGHT/2);
*/
XDrawImageString(doc->display,pixmap,gc,BORDERW,THEIGHT-BORDERW,"M",1);
XSetWindowBackgroundPixmap(doc->display,doc->controlbox,pixmap);
XFreePixmap(doc->display,pixmap);
XFreeGC(doc->display,gc);
printf ("controlbox created\n");
doc->Twindow=XCreateWindow(doc->display,doc->window,
THEIGHT,0,doc->win_w,THEIGHT,BORDERW,doc->depth,InputOutput,
XDefaultVisual(doc->display,doc->screen),
0,&(doc->attr));
XSetStandardProperties(doc->display,doc->Twindow,filename,filename,None,0,0,0);
doc->Iwindow=XCreateWindow(doc->display,doc->window,
0,THEIGHT+BORDERW*2,doc->win_w,doc->win_h,BORDERW,doc->depth,InputOutput,
XDefaultVisual(doc->display,doc->screen),
0,&(doc->attr));
XSetStandardProperties(doc->display,doc->Iwindow,filename,filename,None,0,0,0);
XSelectInput(doc->display,doc->Iwindow,ExposureMask | ButtonPressMask | PointerMotionMask | ButtonReleaseMask | KeyPressMask);
XMapRaised(doc->display,doc->Iwindow);
while (XNextEvent(doc->display,&event),event.type!=Expose);
XSelectInput(doc->display,doc->Twindow,ExposureMask);
XMapRaised(doc->display,doc->Twindow);
while (XNextEvent(doc->display,&event),event.type!=Expose);
XSetWindowBackground(doc->display,doc->window,0);
XSetWindowBackground(doc->display,doc->Iwindow,1);
XSetWindowBackground(doc->display,doc->Twindow,2);
XSetBackground(doc->display,doc->gc,0);
XSetForeground(doc->display,doc->gc,1);
XClearWindow(doc->display,doc->window);
XClearWindow(doc->display,doc->Iwindow);
XClearWindow(doc->display,doc->Twindow);
XClearWindow(doc->display,doc->controlbox);
XSelectInput(doc->display,doc->Twindow,PointerMotionMask | ButtonPressMask);
doc->horbar=CreateScrollBar(doc->display,doc->window,doc->screen,doc->depth,
doc->win_w,0,THEIGHT,doc->win_h);
doc->verbar=CreateScrollBar(doc->display,doc->window,doc->screen,doc->depth,
0,doc->win_h,doc->win_w,THEIGHT);
LoadImage(doc);
printf ("makeing title name\n");
strncpy(doc->filename,filename,40);
doc->refresh=False;
printf ("document created\n");
}

void createanydoc(DocObj *doc,char *filename,int type)
{
if (type!=NEW_DOC) createanydocofsize(doc,filename,type,0,0);
}

