#include <X11/Xlib.h>
#include "border.h"
#include "scrbar.h"

ScrollBar CreateScrollBar(Display *display,Window parent,int screen,int depth,
int x,int y,int width,int height)
{
XSetWindowAttributes attr;
Pixmap pixmap;
GC gc;
ScrollBar bar;
bar.value=0;
printf ("now to create scrollbar\n");
bar.bar=XCreateWindow(display,parent,x,y,width,height,0,depth,InputOutput,
XDefaultVisual(display,screen),0,&attr);
bar.min=XCreateWindow(display,bar.bar,0,0,10,10,0,depth,InputOutput,
XDefaultVisual(display,screen),0,&attr);
bar.max=XCreateWindow(display,bar.bar,10,0,10,10,0,depth,InputOutput,
XDefaultVisual(display,screen),0,&attr);
bar.pos=XCreateWindow(display,bar.bar,20,0,10,10,0,depth,InputOutput,
XDefaultVisual(display,screen),0,&attr);
XMapRaised(display,bar.bar);
XMapRaised(display,bar.pos);
XMapRaised(display,bar.min);
XMapRaised(display,bar.max);
XSelectInput (display,bar.min,ButtonPressMask);
XSelectInput (display,bar.max,ButtonPressMask);
XSelectInput (display,bar.pos,PointerMotionMask | ButtonPressMask | ButtonReleaseMask);
XSelectInput (display,bar.bar,ExposureMask);
pixmap=XCreatePixmap(display,parent,THEIGHT,THEIGHT,depth);
gc=XCreateGC(display,pixmap,0,0);
XSetForeground(display,gc,BlackPixel(display,screen));
XFillRectangle(display,pixmap,gc,0,0,THEIGHT,THEIGHT);
XSetForeground(display,gc,WhitePixel(display,screen));
XDrawRectangle(display,pixmap,gc,0,0,THEIGHT-1,THEIGHT-1);
XDrawLine(display,pixmap,gc,0,0,THEIGHT,THEIGHT);
XDrawLine(display,pixmap,gc,0,THEIGHT,THEIGHT,0);
XSetWindowBackground(display,bar.bar,BlackPixel(display,screen));
/*
XSetWindowBackground(display,bar.min,WhitePixel(display,screen));
XSetWindowBackground(display,bar.max,WhitePixel(display,screen));
XSetWindowBackground(display,bar.pos,WhitePixel(display,screen));
*/
XSetWindowBackgroundPixmap(display,bar.min,pixmap);
XClearWindow(display,bar.min);
XSetWindowBackgroundPixmap(display,bar.max,pixmap);
XClearWindow(display,bar.max);
XSetWindowBackgroundPixmap(display,bar.pos,pixmap);
XClearWindow(display,bar.pos);
XFreePixmap(display,pixmap);
XFreeGC(display,gc);
return bar;
}

void SetHorScrollBar(Display *display,ScrollBar *bar,int x,int y,int Width,int Height)
{
/* Width is always bigger than Height */
bar->maxval=Width-Height*3;
printf ("max val is %i\n",bar->maxval);
if (bar->value<0) bar->value=0;
if (bar->maxval<1) bar->maxval=1;
if (bar->value>bar->maxval) bar->value=bar->maxval;
XResizeWindow(display,bar->bar,Width,Height);
XResizeWindow(display,bar->pos,Height,Height);
XResizeWindow(display,bar->min,Height,Height);
XResizeWindow(display,bar->max,Height,Height);
XMoveWindow(display,bar->bar,x,y);
XMoveWindow(display,bar->min,0,0);
XMoveWindow(display,bar->max,Width-Height,0);
XMoveWindow(display,bar->pos,Height+bar->value,0);
}

void SetVerScrollBar(Display *display,ScrollBar *bar,int x,int y,int Width,int Height)
{
/* Height is always bigger than Height */
bar->maxval=Height-Width*3;
if (bar->value<0) bar->value=0;
if (bar->maxval<1) bar->maxval=1;
if (bar->value>bar->maxval) bar->value=bar->maxval;
XResizeWindow(display,bar->bar,Width,Height);
XResizeWindow(display,bar->pos,Width,Width);
XResizeWindow(display,bar->min,Width,Width);
XResizeWindow(display,bar->max,Width,Width);
XMoveWindow(display,bar->bar,x,y);
XMoveWindow(display,bar->min,0,0);
XMoveWindow(display,bar->max,0,Height-Width);
XMoveWindow(display,bar->pos,0,Width+bar->value);
}

void UpdateHorBar(Display *display,ScrollBar bar)
{
XMoveWindow(display,bar.pos,THEIGHT+bar.value,0);
}

void UpdateVerBar(Display *display,ScrollBar bar)
{
XMoveWindow(display,bar.pos,0,THEIGHT+bar.value);
}

int CheckBar(Display *display,ScrollBar *bar,XEvent *event,Bool HorizDir)
{
Bool update=False;
Bool redraw=False;
if (event->type==ButtonPress && event->xbutton.window==bar->min)
 {
 bar->value--;
 update=True;
 redraw=True;
 }
if (event->type==ButtonPress && event->xbutton.window==bar->max)
 {
 bar->value++;
 update=True;
 redraw=True;
 }
if (event->type==ButtonPress && event->xbutton.window==bar->pos)
 {
 if (HorizDir)
  {
  bar->clickpos=event->xbutton.x_root;
  }
 else
  {
  bar->clickpos=event->xbutton.y_root;
  }
 } 
if (event->type==MotionNotify && event->xmotion.state==Button1MotionMask && event->xmotion.window==bar->pos)
 {
 if (HorizDir)
  {
  bar->value+=event->xmotion.x_root-bar->clickpos;
  bar->clickpos=event->xmotion.x_root;
  }
  else
  {
  bar->value+=event->xmotion.y_root-bar->clickpos;
  bar->clickpos=event->xmotion.y_root;
  }
 printf ("move with val:%i and max:%i\n",bar->value,bar->maxval);
 
 update=True;
 }
if (bar->value<0) bar->value=0;
if (bar->value>bar->maxval) bar->value=bar->maxval;

if (HorizDir)
 {
 if (update) XMoveWindow(display,bar->pos,THEIGHT+bar->value,0);
 }
else
 {
 if (update) XMoveWindow(display,bar->pos,0,THEIGHT+bar->value);
 }
if (event->type==ButtonRelease && event->xbutton.window==bar->pos) redraw=True;
if (redraw) return bar->value;
return -1;
}
