#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <malloc.h>

static Display *display;
static Window window;
static XSizeHints hints;
static GC gc;
static int screen,depth;
static XSetWindowAttributes attr;
static XEvent event;
static Colormap cmap;
unsigned long col[256];
static char gray[8];
static XColor color;

void connecttoserver()
{
int f,red,green,blue;
display=XOpenDisplay("");
printf("connected\n");
hints.flags=USPosition;/*USPosition; (for spesific positioning)*/
screen=DefaultScreen(display);
depth=DisplayPlanes(display,screen);
window=XCreateWindow(display,RootWindow(display,screen),
0,0,512,512,0,depth,InputOutput,
XDefaultVisual(display,screen),
CWColormap,&attr);
XSetStandardProperties(display,window,"World","world",None,0,0,&hints);
gc=XCreateGC(display,window,0,0);
XSetWindowBackground(display,window,WhitePixel(display,screen));
XSetBackground (display,gc,WhitePixel(display,screen));
XSetForeground (display,gc,BlackPixel(display,screen)); 
XClearWindow(display,window);
XSelectInput(display,window,ExposureMask | ButtonPressMask | ButtonReleaseMask | PointerMotionMask |KeyPressMask);
XMapRaised(display,window);
cmap=DefaultColormap(display,screen);
f=0;
for (red=0;red<4;red++)
for (green=0;green<4;green++)
for (blue=0;blue<4;blue++)
 {
 color.red=(unsigned short)(red*21000);
 color.green=(unsigned short) (green*21000);
 color.blue=(unsigned short) (blue*21000);
 XAllocColor(display,cmap,&color);
 col[f]=color.pixel;
 f++;
 }
}

void disconnect()
{
XCloseDisplay(display);
}

main()
{
FILE *f1;
unsigned char data[1024][4096];
char plname[64];
int x,y,s,d1,d2,d3,d4,max,min,m,diff,v1,v2,v3,xo,yo,xf,yf,quit,flx,fly,p;
int red,green,blue;
unsigned char activechar='c';
unsigned char viewchar='a';
unsigned char zoomchar='e';
unsigned char localchar;

printf ("now to connect\n");
connecttoserver();
if ((f1=fopen("/dev/scanner","r"))==NULL)
 {
 printf ("failed to open file\n");
 exit(1);
 }
printf ("reading data\n");
for (y=0;y<63;y++)
 {
 XSetForeground(display,gc,col[y]);
 XFillRectangle(display,window,gc,y*8,300,8,8);
 }
for (y=0;y<1000;y++)
 {
 if (!(y%32)) printf ("reading line %i\n",y);
 fread (data[y],1,4096,f1);
 for (x=0,p=0;x<4096;x+=6,p++)
  {
  red=(int) data[y][x];
  green=(int) data[y][x+1]; 
  blue=(int) data[y][x+2]; 
  red>>=6;
  red&=3;
  green>>=6;
  green&=3;
  blue>>=6;
  blue&=3;
  XSetForeground(display,gc,col[red*16+green*4+blue]);
  XDrawPoint(display,window,gc,p,000+y>>1);
  }
 } 
fclose(f1);
xo=yo=0;
XSetForeground(display,gc,WhitePixel(display,screen));
XDrawString(display,window,gc,49,50,"SCAN COMPLETE, CLICK MIDDLE BUTTON TO EXIT",42);
XDrawString(display,window,gc,51,50,"SCAN COMPLETE, CLICK MIDDLE BUTTON TO EXIT",42);
XDrawString(display,window,gc,50,49,"SCAN COMPLETE, CLICK MIDDLE BUTTON TO EXIT",42);
XDrawString(display,window,gc,50,51,"SCAN COMPLETE, CLICK MIDDLE BUTTON TO EXIT",42);
XSetForeground(display,gc,BlackPixel(display,screen));
XDrawString(display,window,gc,50,50,"SCAN COMPLETE, CLICK MIDDLE BUTTON TO EXIT",42);

quit=0;
while (quit==0)
 {
 XNextEvent(display,&event);
 if (event.type==ButtonPress && event.xbutton.button==2)
  {
  quit=1;
  }
 }
printf ("program finished normally\n");
disconnect();
}
