#include <stdio.h>
#include "memimage.h"

void printps(char *filename,MemImage im)
{
int scanline,x,y;
char rl,rh,gl,gh,bl,bh;
unsigned char rv,gv,bv;

FILE *outfile;
if ((outfile=fopen (filename,"wb"))==NULL) 
 {
 fprintf(stderr,"cant create outfile\n");return ;
 }
fprintf(outfile,"/pix %i string def\n",3*im.X);
fprintf(outfile,"%i %i 8\n",im.X,im.Y);
fprintf(outfile,"[1 0 0 -1 -10 780]\n");
fprintf(outfile,"{currentfile pix readhexstring pop}\n");
fprintf(outfile,"false 3 colorimage\n");
scanline=(im.X*im.Bits+7)/8;
scanline*=im.Planes;
for (y=0;y<im.Y;y++)
{
 for (x=0;x<im.X;x++)
  {
  if (im.Planes==3)
   {
   rv=*(im.data+y*scanline+x*3);
   gv=*(im.data+y*scanline+x*3+1);
   bv=*(im.data+y*scanline+x*3+2);  
   }
  else
   {
   rv=gv=bv=*(im.data+y*scanline+x);
   }
  rh=((rv&0xf0)>>4)+'0';
  rl=((rv&0x0f))+'0';
  gh=((gv&0xf0)>>4)+'0';
  gl=((gv&0x0f))+'0';
  bh=((bv&0xf0)>>4)+'0';
  bl=((bv&0x0f))+'0';
  if (rh>'9') rh+='a'-'0'-10;
  if (rl>'9') rl+='a'-'0'-10;
  if (gh>'9') gh+='a'-'0'-10;
  if (gl>'9') gl+='a'-'0'-10;
  if (bh>'9') bh+='a'-'0'-10;
  if (bl>'9') bl+='a'-'0'-10;
  fprintf(outfile,"%c%c%c%c%c%c",rh,rl,gh,gl,bh,bl);
  }
 fprintf(outfile,"\n");
 }
fprintf(outfile,"showpage\n");
fclose(outfile);
}
