#include "doc.h"

static DocObj clipdoc;
static DocObj *savedoc;

MemImage blankimage(int x,int y);


void InitClipboard()
{
clipdoc.img=blankimage(8,8);
clipdoc.x=clipdoc.y=8;
clipdoc.selmask=(char *)malloc(16);
}

void FreeClipboard()
{
free (clipdoc.img.data);
free (clipdoc.selmask);
}

void CopyDoc(DocObj *doc)
{
MemImage im=doc->img;
int f,scanline,selsize,imsize,x,y;
printf ("saving doc\n");
scanline=(doc->img.X+7)/8;
selsize=scanline*doc->img.Y;
imsize=im.X*im.Y*im.Planes;
printf ("imsize is %i\n",imsize);
printf ("realloc...\n");
clipdoc.selmask=(char *)realloc(clipdoc.selmask,selsize);
clipdoc.img.data=(char *)realloc(clipdoc.img.data,imsize);
memcpy (clipdoc.img.data,doc->img.data,imsize);
clipdoc.Width=clipdoc.img.X=doc->img.X;
clipdoc.Height=clipdoc.img.Y=doc->img.Y;
clipdoc.img.Planes=doc->img.Planes;
clipdoc.maskactive=doc->maskactive;
if (doc->maskactive)
 memcpy (clipdoc.selmask,doc->selmask,selsize);
else
 memset (clipdoc.selmask,0,selsize);
printf ("size is %i %i \n",clipdoc.img.X,clipdoc.img.Y);
savedoc=doc;
}

void PasteDoc(DocObj *doc)
{
MemImage im=clipdoc.img;
int f,scanline,selsize,imsize,x,y;
printf ("loading doc\n");
if (doc->active==False)
 {
 printf ("doc inactive\n");
 return;
 }
printf ("doc valid\n");
scanline=(clipdoc.img.X+7)/8;
selsize=scanline*clipdoc.img.Y;
imsize=im.X*im.Y*im.Planes;

if (doc->img.X!=clipdoc.img.X || doc->img.Y!=clipdoc.img.Y)
 {
 printf ("size is %i %i \n",clipdoc.img.X,clipdoc.img.Y);
 doc->selmask=(char *)realloc(doc->selmask,selsize);
 doc->img.data=(char *)realloc(doc->img.data,imsize);
 doc->Width=doc->img.X=clipdoc.img.X;
 doc->Height=doc->img.Y=clipdoc.img.Y;
 }
memcpy (doc->img.data,clipdoc.img.data,imsize);
doc->maskactive=clipdoc.maskactive;
memcpy (doc->selmask,clipdoc.selmask,selsize);
}

void PasteSelMaskFromClipbrd(DocObj *doc,int x,int y,Bool ForReal)
{
PasteSelMask(&clipdoc,doc,x,y,ForReal);
}

void UnPasteSelMaskFromClipbrd(DocObj *doc,int x,int y)
{
UnPasteSelMask(&clipdoc,doc,x,y);
}


