#include <X11/Xlib.h>
#include <math.h>
#include "doc.h"
#include "border.h"
#include "globals.h"

extern int mode;
extern int oldmode;


void SetDocHorDot(DocObj *doc,int x,int y,int red,int green,int blue)
{
int g;
for (g=0;g<=DotSize;g++)
 {
 SetDocPixel(doc,(int)(x+g),(int)(y),red,green,blue);
 SetDocPixel(doc,(int)(x-g),(int)(y),red,green,blue);
 }
}

void SetDocVerDot(DocObj *doc,int x,int y,int red,int green,int blue)
{
int g;
for (g=0;g<=DotSize;g++)
 {
 SetDocPixel(doc,(int)(x),(int)(y+g),red,green,blue);
 SetDocPixel(doc,(int)(x),(int)(y-g),red,green,blue);
 }
}

void SetDocDotOutline(DocObj *doc,int x,int y,int red,int green,int blue)
{
int f,g;
f=g=0;
f=DotSize;
for (g=0;g<=f;g++)
 {
 SetDocPixel(doc,(int)(x+g-f),(int)(y+g),red,green,blue);
 SetDocPixel(doc,(int)(x-g+f),(int)(y+g),red,green,blue);
 SetDocPixel(doc,(int)(x+g-f),(int)(y-g),red,green,blue);
 SetDocPixel(doc,(int)(x-g+f),(int)(y-g),red,green,blue);
 }
}

void SetDocDot(DocObj *doc,int x,int y,int red,int green,int blue)
{
int f,g;
f=g=0;
for (f=1;f<DotSize;f++)
for (g=0;g<=f;g++)
 {
 SetDocPixel(doc,(int)(x+g-f),(int)(y+g),red,green,blue);
 SetDocPixel(doc,(int)(x-g+f),(int)(y+g),red,green,blue);
 SetDocPixel(doc,(int)(x+g-f),(int)(y-g),red,green,blue);
 SetDocPixel(doc,(int)(x-g+f),(int)(y-g),red,green,blue);
 }
}

int FromVirX(DocObj *doc,int x)
{
return(doc->startx+x*doc->zoomout/doc->zoomin);
}

int FromVirY(DocObj *doc,int y)
{
return(doc->starty+y*doc->zoomout/doc->zoomin);
}
int sgn(int a)
{
if (a>0) return 1;
if (a<0) return -1;
return 0;
}

void DocFill(DocObj *doc,unsigned long Color)
{
unsigned int red,green,blue;
int x,y;
red=Color&255;
green=(Color>>8)&255;
blue=(Color>>16)&255;
ReportThat("Filling in progress Please wait");
for (x=0;x<doc->img.X;x++)
for (y=0;y<doc->img.Y;y++)
if (UseMaskPixel(doc,x,y)) SetDocPixel(doc,x,y,red,green,blue);
ReportThat("Filling done");
}

void DocFillGradientLine(DocObj *doc,int x1,int y1,int x2,int y2)
{
unsigned int red1,green1,blue1;
unsigned int red2,green2,blue2;
unsigned int redd,greend,blued;
int x,y;
float xd,yd;
float r,rd,A,B,C,l,s;

ReportThat("Gradient Filling in progress Please wait");

red1=ForeCol&255;
green1=(ForeCol>>8)&255;
blue1=(ForeCol>>16)&255;
red2=BackCol&255;
green2=(BackCol>>8)&255;
blue2=(BackCol>>16)&255;
redd=red2-red1;
greend=green2-green1;
blued=blue2-blue1;

xd=x2-x1;
yd=y2-y1;
if (x1==x2) /* xd==0 */
 {
 A=0;
 B=1;
 C=-y1; 
 rd=abs(yd);
 printf ("special case\n");
 }
else
 {
 rd=sqrt(xd*xd+yd*yd);
 if (rd==0) return;
 l=-yd/xd;
 A=-1;
 B=l;
 C=x1-l*y1;
 }
s=sqrt(A*A+B*B);
if (s==0) return;
for (x=0;x<doc->img.X;x++)
for (y=0;y<doc->img.Y;y++)
if (UseMaskPixel(doc,x,y))
 {
 r=abs(A*x+B*y+C)/s;
 SetDocPixel(doc,x,y,
  (int)(red1+sgn(redd)*(r/rd)*abs(redd)),
  (int)(green1+sgn(greend)*(r/rd)*abs(greend)),
  (int)(blue1+sgn(blued)*(r/rd)*abs(blued))
  );
 }
ReportThat("Gradient Filling done");
}

void DocFillGradientCirc(DocObj *doc,int x1,int y1,int x2,int y2)
{
unsigned int red1,green1,blue1;
unsigned int red2,green2,blue2;
unsigned int redd,greend,blued;
int x,y,xd,yd;
float r,rd;
xd=x2-x1;
yd=y2-y1;

ReportThat("Gradient Filling in progress Please wait");

rd=sqrt(xd*xd+yd*yd);
if (rd==0) return;
red1=ForeCol&255;
green1=(ForeCol>>8)&255;
blue1=(ForeCol>>16)&255;
red2=BackCol&255;
green2=(BackCol>>8)&255;
blue2=(BackCol>>16)&255;
redd=red2-red1;
greend=green2-green1;
blued=blue2-blue1;
for (x=0;x<doc->img.X;x++)
for (y=0;y<doc->img.Y;y++)
if (UseMaskPixel(doc,x,y))
 {
 r=sqrt((x-x1)*(x-x1)+(y-y1)*(y-y1));
 SetDocPixel(doc,x,y,
  (int)(red1+sgn(redd)*(.5+.5*cos((double)(M_PI*r/rd)))*abs(redd)),
  (int)(green1+sgn(greend)*(.5+.5*cos((double)(M_PI*r/rd)))*abs(greend)),
  (int)(blue1+sgn(blued)*(.5+.5*cos((double)(M_PI*r/rd)))*abs(blued))
  );
 }
ReportThat("Gradient Filling done");
}

void DocDrawHorVerLine(DocObj *doc,int ex,int ey,int lastx,int lasty)
{
int x,y,xs,ys;
unsigned int red,green,blue;
red=ForeCol&255;
green=(ForeCol>>8)&255;
blue=(ForeCol>>16)&255;
xs=(ex-lastx);
ys=(ey-lasty);
if (xs && abs(xs)>abs(ys))
 {
 xs=xs/abs(xs);
 for (x=lastx;x!=ex;x+=xs)
  {
  y=lasty+(x-lastx)*(lasty-ey)/(lastx-ex);
  SetDocVerDot(doc,x,y,red,green,blue);
  }
 }
else
{
 if (ys)
  {
  ys=ys/abs(ys);
  for (y=lasty;y!=ey;y+=ys)
   {
   x=lastx+(y-lasty)*(lastx-ex)/(lasty-ey);
   SetDocHorDot(doc,x,y,red,green,blue);
   }
  }
 }
}

void DocDrawHollowLine(DocObj *doc,int ex,int ey,int lastx,int lasty)
{
int x,y,xs,ys;
unsigned int red,green,blue;
red=ForeCol&255;
green=(ForeCol>>8)&255;
blue=(ForeCol>>16)&255;
xs=(ex-lastx);
ys=(ey-lasty);
if (xs && abs(xs)>abs(ys))
 {
 xs=xs/abs(xs);
 for (x=lastx;x!=ex;x+=xs)
  {
  y=lasty+(x-lastx)*(lasty-ey)/(lastx-ex);
  SetDocDotOutline(doc,x,y,red,green,blue);
  }
 }
else
{
 if (ys)
  {
  ys=ys/abs(ys);
  for (y=lasty;y!=ey;y+=ys)
   {
   x=lastx+(y-lasty)*(lastx-ex)/(lasty-ey);
   SetDocDotOutline(doc,x,y,red,green,blue);
   }
  }
 }
}

void DocDrawLine(DocObj *doc,int ex,int ey,int lastx,int lasty)
{
int x,y,xs,ys;
unsigned int red,green,blue;
red=ForeCol&255;
green=(ForeCol>>8)&255;
blue=(ForeCol>>16)&255;
xs=(ex-lastx);
ys=(ey-lasty);
if (xs && abs(xs)>abs(ys))
 {
 xs=xs/abs(xs);
 for (x=lastx;x!=ex;x+=xs)
  {
  y=lasty+(x-lastx)*(lasty-ey)/(lastx-ex);
  SetDocDot(doc,x,y,red,green,blue);
  }
 }
else
{
 if (ys)
  {
  ys=ys/abs(ys);
  for (y=lasty;y!=ey;y+=ys)
   {
   x=lastx+(y-lasty)*(lastx-ex)/(lasty-ey);
   SetDocDot(doc,x,y,red,green,blue);
   }
  }
 }
}

void (*DocDrawGenericLine) (DocObj *doc,int ex,int ey,int lastx,int lasty)=&DocDrawHorVerLine;

void SetLineDrawingHorVer()
{
DocDrawGenericLine=&DocDrawHorVerLine;
}

void SetLineDrawingHollow()
{
DocDrawGenericLine=&DocDrawHollowLine;
}

void SetLineDrawingNormal()
{
DocDrawGenericLine=&DocDrawLine;
}

void HandleDrawing(DocObj *doc,XEvent *event)
{
static int lastx,lasty;
int x,y,xs,ys;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 SetDocVirPixel(doc,event->xbutton.x,event->xbutton.y,ForeCol);
 lastx=event->xbutton.x;lasty=event->xbutton.y;
 }

if (event->type==MotionNotify && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
/* doc draw */
 {
 DocDrawGenericLine(doc,FromVirX(doc,event->xmotion.x),FromVirY(doc,event->xmotion.y),
  FromVirX(doc,lastx),FromVirY(doc,lasty));
 lastx=event->xmotion.x;lasty=event->xmotion.y; 
 }
}

void HandleFillGradLine(DocObj *doc,XEvent *event)
{
static int lastx,lasty,active=0;
int x,y,xs,ys;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 SetDocVirPixel(doc,event->xbutton.x,event->xbutton.y,ForeCol);
 lastx=event->xbutton.x;lasty=event->xbutton.y;
 active=True;
 }

if (active && event->type==ButtonRelease && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
/* doc draw */
 {
 DocFillGradientLine(doc,FromVirX(doc,event->xmotion.x),FromVirY(doc,event->xmotion.y),
  FromVirX(doc,lastx),FromVirY(doc,lasty));
  active=False;
 }
}

void HandleFillGradCirc(DocObj *doc,XEvent *event)
{
static int lastx,lasty,active=0;
int x,y,xs,ys;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 SetDocVirPixel(doc,event->xbutton.x,event->xbutton.y,ForeCol);
 lastx=event->xbutton.x;lasty=event->xbutton.y;
 active=True;
 }

if (active && event->type==ButtonRelease && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
/* doc draw */
 {
 DocFillGradientCirc(doc,FromVirX(doc,event->xmotion.x),FromVirY(doc,event->xmotion.y),
  FromVirX(doc,lastx),FromVirY(doc,lasty));
  active=False;
 }
}

unsigned long HandlePickCol(DocObj *doc,XEvent *event)
{
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 ForeCol=GetDocVirPixel(doc,event->xbutton.x,event->xbutton.y);
 UpdateBrushDisplay(doc->display,doc->screen);
 }
if (event->type==MotionNotify && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
 {
 ForeCol=GetDocVirPixel(doc,event->xmotion.x,event->xmotion.y);
 UpdateBrushDisplay(doc->display,doc->screen);
 }
return ForeCol;
}

unsigned long HandlePickBackCol(DocObj *doc,XEvent *event)
{
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 BackCol=GetDocVirPixel(doc,event->xbutton.x,event->xbutton.y);
 UpdateBrushDisplay(doc->display,doc->screen);
 }
if (event->type==MotionNotify && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
 {
 BackCol=GetDocVirPixel(doc,event->xmotion.x,event->xmotion.y);
 UpdateBrushDisplay(doc->display,doc->screen);
 }
return BackCol;
}

void HandleSelectText(DocObj *doc,XEvent *event)
{
static char text[128];
text[0]=0;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 ask("enter the text",text,doc->display);
 DrawTextOnSelMask(doc,FromVirX(doc,event->xbutton.x),FromVirY(doc,event->xbutton.y),text);
 }
}

void HandleSelectPixel(DocObj *doc,XEvent *event)
{
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 SetMaskPixel(doc,FromVirX(doc,event->xbutton.x),FromVirY(doc,event->xbutton.y),
 !GetMaskPixel(doc,FromVirX(doc,event->xbutton.x),FromVirY(doc,event->xbutton.y))
 );
 }

if (event->type==MotionNotify && event->xmotion.state==Button1Mask && event->xmotion.window==doc->Iwindow)
 {
 SetMaskPixel(doc,FromVirX(doc,event->xmotion.x),FromVirY(doc,event->xmotion.y),1);
 }

if (event->type==ButtonPress && event->xbutton.button==3 && event->xbutton.window==doc->Iwindow)
 {
 printf ("button 3i %i\n",GetMaskPixel(doc,FromVirX(doc,event->xbutton.x),FromVirY(doc,event->xbutton.y)));
 }
}

void HandleSelectMagic(DocObj *doc,XEvent *event)
{
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 setwaitcurs(doc->display,doc->window,doc->screen,doc->cmap);
 SelectMagicImage(doc,FromVirX(doc,event->xbutton.x),FromVirY(doc,event->xbutton.y));
 setnormalcurs(doc->display,doc->window);  
 }
}

void HandleSelectRectArea(DocObj *doc,XEvent *event)
{
static int lastx,lasty,x,y,drawx,drawy,dragx,dragy;
int startx,starty,width,height;
static Bool active=False;
static GC gc;
int swap;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 lastx=FromVirX(doc,event->xbutton.x);
 lasty=FromVirY(doc,event->xbutton.y);
 drawx=dragx=event->xbutton.x;
 drawy=dragy=event->xbutton.y;
 if (active==False) gc=XCreateGC(doc->display,doc->Iwindow,0,0);
 active=True;
 }

if (active && event->type==MotionNotify && event->xmotion.state==Button1Mask && event->xmotion.window==doc->Iwindow)
 {
 XSetFunction(doc->display,gc,GXinvert);
 startx=drawx;starty=drawy;
 if (drawx>dragx) startx=dragx;
 if (drawy>dragy) starty=dragy;
 width=abs(drawx-dragx);
 height=abs(drawy-dragy);
 XDrawRectangle(doc->display,doc->Iwindow,gc,startx,starty,width,height);
 dragx=event->xmotion.x;
 dragy=event->xmotion.y;
 startx=drawx;starty=drawy;
 if (drawx>dragx) startx=dragx;
 if (drawy>dragy) starty=dragy;
 width=abs(drawx-dragx);
 height=abs(drawy-dragy);
 XDrawRectangle(doc->display,doc->Iwindow,gc,startx,starty,width,height);
 }

if (active && event->type==ButtonRelease  && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 printf ("released\n");
 x=FromVirX(doc,event->xbutton.x);
 y=FromVirY(doc,event->xbutton.y);
 if (lastx>x) 
  {
  swap=lastx;
  lastx=x;
  x=swap;
  }
 if (lasty>y) 
  {
  swap=lasty;
  lasty=y;
  y=swap;
  }
 printf ("button 3i %i\n",GetMaskPixel(doc,FromVirX(doc,event->xbutton.x),FromVirY(doc,event->xbutton.y)));
 SelectRectangle(doc,lastx,lasty,x-lastx,y-lasty);
 if (active==True) XFreeGC(doc->display,gc);
 active=False;
 }
}

int HandleControlBox(DocObj *doc,XEvent *event)
{
char controlmenu[][20]={"Close","Save","Create Same Canvas","refresh"};
int res=0;
if (event->type==ButtonRelease && event->xbutton.window==doc->controlbox)
 {
 printf("handle control\n");
 res=1+menu(doc->display,doc->window,controlmenu,0,THEIGHT,4,0);
 }
return res;
}

void HandleMouseScroll(DocObj *doc,XEvent *event)
{
static int lastx,lasty,active=0;
static int x,y,xs,ys;
XEvent l_event;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 lastx=event->xbutton.x;lasty=event->xbutton.y;
 active=True;
 printf ("scrolling\n");
 }

if (active && event->type==ButtonRelease && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
 {
 doc->startx-=FromVirX(doc,x)-FromVirX(doc,lastx);
 doc->starty-=FromVirY(doc,y)-FromVirY(doc,lasty);
 active=False;
 ClipWinToMax(doc);
 BringDocBarsInlimits(doc);
 UpdateDocOrMask(doc);
 UpdateDocScrollBars(doc);
 }

if (active && event->type==MotionNotify && event->xmotion.state==Button1Mask && event->xmotion.window==doc->Iwindow)
 {
 x=event->xbutton.x;y=event->xbutton.y;
 if (XCheckWindowEvent(doc->display,doc->Iwindow,PointerMotionMask,&l_event))
  {
  XPutBackEvent(doc->display,&l_event);
  }
 else
  {
  XPutImage(doc->display,doc->Iwindow,doc->gc,doc->image,0,0,x-lastx,y-lasty,doc->win_w,doc->win_h);
  }
 printf ("put image at %i %i \n",x-lastx,y-lasty);
 }
}

void HandleResize(DocObj *doc,XEvent *event)
{
static Bool active=False;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->window)
 {
 if (event->xbutton.x>doc->win_w-THEIGHT && event->xbutton.y>doc->win_h-THEIGHT)
  {
  printf ("activating resize\n");
  active=True;
  }
 }
if (active && event->type==ButtonRelease && event->xbutton.button==1 && event->xbutton.window==doc->window)
 {
 printf ("deactivating resize \n");
 active=False;
 ClipWinToMax(doc);
 BringDocBarsInlimits(doc);
 UpdateWholeDocView(doc);
 UpdateDocScrollBars(doc);
 }

if (active && event->type==MotionNotify && event->xmotion.state==Button1Mask && event->xmotion.window==doc->window)
 {
 doc->win_w=event->xmotion.x-2*BORDERW;
 doc->win_h=event->xmotion.y-THEIGHT-4*BORDERW;
 }
}

Bool HandleCropImage(DocObj *doc,XEvent *event)
{
static int lastx,lasty,x,y,drawx,drawy,dragx,dragy;
int startx,starty,width,height;
static Bool active=False;
static GC gc;
int swap;
Bool needfeedback;
needfeedback=False;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 lastx=FromVirX(doc,event->xbutton.x);
 lasty=FromVirY(doc,event->xbutton.y);
 drawx=dragx=event->xbutton.x;
 drawy=dragy=event->xbutton.y;
 if (active==False) gc=XCreateGC(doc->display,doc->Iwindow,0,0);
 active=True;
 }

if (active && event->type==MotionNotify && event->xmotion.state==Button1Mask && event->xmotion.window==doc->Iwindow)
 {
 XSetFunction(doc->display,gc,GXinvert);
 startx=drawx;starty=drawy;
 if (drawx>dragx) startx=dragx;
 if (drawy>dragy) starty=dragy;
 width=abs(drawx-dragx);
 height=abs(drawy-dragy);
 XDrawRectangle(doc->display,doc->Iwindow,gc,startx,starty,width,height);
 dragx=event->xmotion.x;
 dragy=event->xmotion.y;
 startx=drawx;starty=drawy;
 if (drawx>dragx) startx=dragx;
 if (drawy>dragy) starty=dragy;
 width=abs(drawx-dragx);
 height=abs(drawy-dragy);
 XDrawRectangle(doc->display,doc->Iwindow,gc,startx,starty,width,height);
 }

if (active && event->type==ButtonRelease  && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 printf ("released\n");
 x=FromVirX(doc,event->xbutton.x);
 y=FromVirY(doc,event->xbutton.y);
 if (lastx>x) 
  {
  swap=lastx;
  lastx=x;
  x=swap;
  }
 if (lasty>y) 
  {
  swap=lasty;
  lasty=y;
  y=swap;
  }
 printf ("button 3i %i\n",GetMaskPixel(doc,FromVirX(doc,event->xbutton.x),FromVirY(doc,event->xbutton.y)));

 CropRectangle(doc,lastx,lasty,x-lastx,y-lasty);
 needfeedback=True;
  if (active==True) XFreeGC(doc->display,gc);
 active=False;
 }
return needfeedback;
}


void HandleSelectOutline(DocObj *doc,XEvent *event)
{
static int *Xp,*Yp;
static Bool active=False;
static int VeCount=0;
static int CurVect=0;
static GC gc;
static Time oldtime,time;

void drawlastvect()
{
if (CurVect>0)
 {
 XSetFunction(doc->display,gc,GXinvert);
 XDrawLine(doc->display,doc->Iwindow,gc,Xp[CurVect-1],Yp[CurVect-1],
 Xp[CurVect],Yp[CurVect]);
 }
printf ("curvect:%i vecount:%i\n",CurVect,VeCount);
}

if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 printf ("start lines\n");
 if (VeCount==0) 
  {
  VeCount=10;
  Xp=(int *)malloc(VeCount*sizeof(int));
  Yp=(int *)malloc(VeCount*sizeof(int));
  }
 Xp[CurVect]=event->xbutton.x;
 Yp[CurVect]=event->xbutton.y;
 CurVect++;
 Xp[CurVect]=event->xbutton.x;
 Yp[CurVect]=event->xbutton.y;
 if (VeCount<CurVect+3)
  {
  VeCount+=10;
  Xp=(int *)realloc(Xp,VeCount*sizeof(int));
  Yp=(int *)realloc(Yp,VeCount*sizeof(int));
  printf ("VeCount increae\n");
  } 
 if (active==False) gc=XCreateGC(doc->display,doc->Iwindow,0,0);
 active=True;
 time=event->xbutton.time;
 if (abs(time-oldtime)<300) /* double click */
  {
  /* select the area */
  printf ("calling %i Poly\n",CurVect);
  DrawPolyOnSelMask(doc,CurVect,Xp,Yp);
  XFreeGC(doc->display,gc);
  free (Xp);
  free (Yp);
  VeCount=CurVect=0;
  active=False;
  return;
  } 
 oldtime=time;
 }

if (active && event->type==MotionNotify && event->xmotion.state==Button1Mask && event->xmotion.window==doc->Iwindow)
 {
 if (VeCount==0) 
  {
  VeCount=10;
  Xp=(int *)malloc(VeCount*sizeof(int));
  Yp=(int *)malloc(VeCount*sizeof(int));
  }
 Xp[CurVect]=event->xmotion.x;
 Yp[CurVect]=event->xmotion.y;
 drawlastvect();
 CurVect++;
 Xp[CurVect]=event->xmotion.x;
 Yp[CurVect]=event->xmotion.y;
 if (VeCount<CurVect+3)
  {
  VeCount+=10;
  Xp=(int *)realloc(Xp,VeCount*sizeof(int));
  Yp=(int *)realloc(Yp,VeCount*sizeof(int));
  }  
 }

if (active && event->type==MotionNotify && event->xmotion.state==0 && event->xmotion.window==doc->Iwindow)
 {
 drawlastvect();
 Xp[CurVect]=event->xmotion.x;
 Yp[CurVect]=event->xmotion.y;
 drawlastvect();
 }

}

void HandleMoveSelection(DocObj *doc,XEvent *event)
{
static int lastx,lasty,active=0;
char report[128];
int x,y,xs,ys;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
/*
 SetDocVirPixel(doc,event->xbutton.x,event->xbutton.y,ForeCol);
*/
 DrawTemp(doc,event->xbutton.x,event->xbutton.y,128,128,128);
 lastx=event->xbutton.x;lasty=event->xbutton.y;
 active=True;
 ReportThat("Moving selection. Release button to place");
 }

if (active && event->type==MotionNotify && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
 {
 sprintf(report,"x:%i,y:%i",FromVirX(doc,event->xmotion.x)-FromVirX(doc,lastx),FromVirY(doc,event->xmotion.y)-FromVirY(doc,lasty));
 ReportThat(report);
 }

if (active && event->type==ButtonRelease && event->xbutton.window==doc->Iwindow && event->xbutton.state==Button1Mask)
 {
 ReportThat("Transferring selection");
 MoveSelMask(doc,FromVirX(doc,event->xmotion.x)-FromVirX(doc,lastx),FromVirY(doc,event->xmotion.y)-FromVirY(doc,lasty));
 active=False;
 ReportThat("Transferring complete");
 }
}

void HandleCopySelection(DocObj *doc,XEvent *event)
{
static int lastx,lasty,active=0;
char report[128];
int x,y,xs,ys;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 DrawTemp(doc,event->xbutton.x,event->xbutton.y,128,128,128);
 lastx=event->xbutton.x;lasty=event->xbutton.y;
 active=True;
 ReportThat("Moving selection. Release button to place");
 }

if (active && event->type==MotionNotify && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
 {
 sprintf(report,"x:%i,y:%i",FromVirX(doc,event->xmotion.x)-FromVirX(doc,lastx),FromVirY(doc,event->xmotion.y)-FromVirY(doc,lasty));
 ReportThat(report);
 }

if (active && event->type==ButtonRelease && event->xbutton.window==doc->Iwindow && event->xbutton.state==Button1Mask)
 {
 ReportThat("Transferring selection");
 CopySelMask(doc,FromVirX(doc,event->xmotion.x)-FromVirX(doc,lastx),FromVirY(doc,event->xmotion.y)-FromVirY(doc,lasty));
 active=False;
 ReportThat("Transferring complete");
 }
}

void HandleRotateSelection(DocObj *doc,XEvent *event)
{
static int lastx,lasty;
static int x1,y1,x2,y2,step=0;
static GC gc;
static int r;
static double angle;
char report[128];
int x,y,xs,ys;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 gc=XCreateGC(doc->display,doc->Iwindow,0,0);
 if (step==0)
  {
  DrawTemp(doc,event->xbutton.x,event->xbutton.y,128,128,128);
  lastx=event->xbutton.x;lasty=event->xbutton.y;
/*
  x1=FromVirX(doc,event.xbutton.x);y1=FromVirY(doc,event.xbutton.y);
*/
  x1=event->xbutton.x;y1=event->xbutton.y;x2=x1;y2=y1;
  ReportThat("now click on the position to define length of rotation");
  }
 if (step==1)
  {
  RotateIm(doc,FromVirX(doc,x1),FromVirY(doc,y1),angle);
  }
 step++;
 step%=2;
 XSetFunction(doc->display,gc,GXcopy);
 XFreeGC(doc->display,gc);
 }

if (event->type==MotionNotify && event->xmotion.window==doc->Iwindow)
 {
 gc=XCreateGC(doc->display,doc->Iwindow,0,0);
 if (step==1)
  {
  XSetFunction(doc->display,gc,GXinvert);
  r=sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
  XDrawLine(doc->display,doc->Iwindow,gc,x1,y1,x2,y2);
  XDrawArc(doc->display,doc->Iwindow,gc,x1-r,y1-r,r*2,r*2,0,64*angle*180/M_PI);
  x2=event->xmotion.x;y2=event->xmotion.y;
  r=sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
  angle=asin((float)(y1-y2)/(float)r);
  XDrawLine(doc->display,doc->Iwindow,gc,x1,y1,x2,y2);
  XDrawArc(doc->display,doc->Iwindow,gc,x1-r,y1-r,r*2,r*2,0,64*angle*180/M_PI);
  }
 sprintf(report,"x1:%i,y1:%i,x2:%i,y2:%i,R:%i,angle:%5.2f",FromVirX(doc,x1),FromVirY(doc,y1),FromVirX(doc,x2),FromVirY(doc,y2),r,angle);
 ReportThat(report);
 XSetFunction(doc->display,gc,GXcopy);
 XFreeGC(doc->display,gc);
 }
}

void HandlePasteFromClipbrd(DocObj *doc,XEvent *event)
{
static int lastx,lasty,active=0;
char report[128];
int x,y,xs,ys;
static int xd,yd;
XEvent l_event;
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==doc->Iwindow)
 {
 SaveDoc(doc);
 DrawTemp(doc,event->xbutton.x,event->xbutton.y,128,128,128);
 lastx=event->xbutton.x;lasty=event->xbutton.y;
 active=True;
 xd=yd=0;
 ReportThat("Moving selection. Release button to place");
 }

if (active && event->type==MotionNotify && event->xmotion.window==doc->Iwindow && event->xmotion.state==Button1Mask)
 {
 sprintf(report,"x:%i,y:%i",FromVirX(doc,event->xmotion.x)-FromVirX(doc,lastx),FromVirY(doc,event->xmotion.y)-FromVirY(doc,lasty));
 ReportThat(report);
 if (XCheckWindowEvent(doc->display,doc->Iwindow,PointerMotionMask,&l_event))
  {
  XPutBackEvent(doc->display,&l_event);
  }
 else
  {
  UnPasteSelMaskFromClipbrd(doc,xd,yd);
  xd=FromVirX(doc,event->xmotion.x)-FromVirX(doc,lastx);
  yd=FromVirY(doc,event->xmotion.y)-FromVirY(doc,lasty);
  PasteSelMaskFromClipbrd(doc,xd,yd,False);
  }
 }

if (active && event->type==ButtonRelease && event->xbutton.window==doc->Iwindow && event->xbutton.state==Button1Mask)
 {
 ReportThat("Transferring selection");
 PasteSelMaskFromClipbrd(doc,FromVirX(doc,event->xmotion.x)-FromVirX(doc,lastx),FromVirY(doc,event->xmotion.y)-FromVirY(doc,lasty),True);
 active=False;
 ReportThat("Transferring complete");
 UpdateWholeDocView(doc);
 mode=oldmode;
 ReportMode(mode);
 }
}













