#include <stdio.h>
#include <malloc.h>
#include <jpeglib.h>
#include "memimage.h"

writejpg(char *filename,MemImage im)
{
struct jpeg_compress_struct cinfo;
struct jpeg_error_mgr jerr;
JSAMPROW row_pointer[1];
FILE *outfile;
int row_stride,res,f;
char *image_buffer=im.data;


cinfo.err=jpeg_std_error(&jerr);
jpeg_create_compress(&cinfo);

if ((outfile=fopen (filename,"wb"))==NULL) 
 {
 fprintf(stderr,"cant create outfile\n");exit(1);
 }
jpeg_stdio_dest(&cinfo,outfile);
cinfo.image_width=im.X;
cinfo.image_height=im.Y;
cinfo.input_components=im.Planes;
if (im.Planes==3) cinfo.in_color_space=JCS_RGB; else cinfo.in_color_space=JCS_GRAYSCALE;
jpeg_set_defaults(&cinfo);
jpeg_start_compress(&cinfo,TRUE);
row_stride=cinfo.image_width*cinfo.input_components;
while (cinfo.next_scanline<cinfo.image_height)
 {
 row_pointer[0]=&image_buffer[cinfo.next_scanline*row_stride];
 jpeg_write_scanlines(&cinfo,row_pointer,1);
 }
jpeg_finish_compress(&cinfo);
res=fclose(outfile);
printf ("res is %i\n",res);
}
