#include "doc.h"

static DocObj undodoc;
static DocObj *savedoc;

MemImage blankimage(int x,int y);

static Bool UndoEnabled=True;

void EnableUndo()
{
UndoEnabled=True;
}

void DisableUndo()
{
UndoEnabled=False;
}

void InitUndo()
{
undodoc.img=blankimage(8,8);
undodoc.x=undodoc.y=8;
undodoc.selmask=(char *)malloc(16);
}

void FreeUndo()
{
free (undodoc.img.data);
free (undodoc.selmask);
}

void SaveDoc(DocObj *doc)
{
MemImage im=doc->img;
int f,scanline,selsize,imsize,x,y;
if (!UndoEnabled)
 {
 ReportThat("Undo is disabled");
 return;
 }
printf ("saving doc\n");
scanline=(doc->img.X+7)/8;
selsize=scanline*doc->img.Y;
imsize=im.X*im.Y*im.Planes;
printf ("imsize is %i\n",imsize);
printf ("realloc...\n");
undodoc.selmask=(char *)realloc(undodoc.selmask,selsize);
undodoc.img.data=(char *)realloc(undodoc.img.data,imsize);
memcpy (undodoc.img.data,doc->img.data,imsize);
undodoc.Width=undodoc.img.X=doc->img.X;
undodoc.Height=undodoc.img.Y=doc->img.Y;
undodoc.img.Planes=doc->img.Planes;
undodoc.maskactive=doc->maskactive;
if (doc->maskactive)
 memcpy (undodoc.selmask,doc->selmask,selsize);
else
 memset (undodoc.selmask,0,selsize);
printf ("size is %i %i \n",undodoc.img.X,undodoc.img.Y);
savedoc=doc;
}

void LoadDoc(DocObj *doc)
{
MemImage im=undodoc.img;
int f,scanline,selsize,imsize,x,y;
if (!UndoEnabled)
 {
 ReportThat("Undo is disabled");
 return;
 }
printf ("loading doc\n");
if (doc->active==False)
 {
 printf ("doc inactive\n");
 return;
 }
if (doc!=savedoc)
 {
 printf ("doc not the last document\n");
 return;
 }
printf ("doc valid\n");
scanline=(undodoc.img.X+7)/8;
selsize=scanline*undodoc.img.Y;
imsize=im.X*im.Y*im.Planes;

if (doc->img.X!=undodoc.img.X || doc->img.Y!=undodoc.img.Y)
 {
 printf ("size is %i %i \n",undodoc.img.X,undodoc.img.Y);
 doc->selmask=(char *)realloc(doc->selmask,selsize);
 doc->img.data=(char *)realloc(doc->img.data,imsize);
 doc->Width=doc->img.X=undodoc.img.X;
 doc->Height=doc->img.Y=undodoc.img.Y;
 }
memcpy (doc->img.data,undodoc.img.data,imsize);
doc->maskactive=undodoc.maskactive;
memcpy (doc->selmask,undodoc.selmask,selsize);
}


