#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include <stdlib.h>
#include "doc.h"

int rand_in(int a,int b)
{
int d=abs(b-a);
int v1,v2;
if (a>b) {v1=a;v2=b;} else {v1=b;v2=a;}
if (!d) d=1;
return (v1+(random()%d));
}

int rand_exp(int a,int b,int divider)
{
/* diveders list 16:exact,12:bigger,20:smaller */
int d=((abs(b-a))<<4)/divider;
int v1,v2;
int m=(b+a)>>1;
if (a>b) {v1=a;v2=b;} else {v1=b;v2=a;}
if (!d) d=1;
return (m-(d>>1)+(random()%d));
}

TextureDiagonalCloudIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
int s=32;
int red1,green1,blue1;
int red2,green2,blue2;
int red3,green3,blue3;
int red4,green4,blue4;
int red,green,blue;
unsigned long color1,color2,color3,color4,newcolor;
int olddata,newdata;
for (x=0;x<im.X;x+=s)
for (y=0;y<im.Y;y+=s)
if (UseMaskPixel(doc,x,y))
 {
 SetDocPixelNormal(doc,x,y,random()%256,255,255);
 }
for (;s>1;s=s>>1)
for (x=0;x<im.X;x+=s)
for (y=0;y<im.Y;y+=s)
if (UseMaskPixel(doc,x,y))
 {
 color1=GetDocPixel(doc,x,y);
 color2=GetDocPixel(doc,(x+s)%im.X,y);
 color3=GetDocPixel(doc,x,(y+s)%im.Y);
 color4=GetDocPixel(doc,(x+s)%im.X,(y+s)%im.Y);
 red1=color1&255;green1=(color1>>8)&255;blue1=(color1>>16)&255;
 red2=color2&255;green2=(color2>>8)&255;blue2=(color2>>16)&255;
 red3=color3&255;green3=(color3>>8)&255;blue3=(color3>>16)&255;
 red4=color4&255;green4=(color4>>8)&255;blue4=(color4>>16)&255;
 red=rand_exp(red1,red2,12);
 green=rand_exp(green1,green2,12);
 blue=rand_exp(blue1,blue2,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x+(s>>1),y,red,green,blue);
 red=rand_exp(red1,red3,12);
 green=rand_exp(green1,green3,12);
 blue=rand_exp(blue1,blue3,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x,y+(s>>1),red,green,blue);
 red=rand_exp(red1,red4,12);
 green=rand_exp(green1,green4,12);
 blue=rand_exp(blue1,blue4,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x+(s>>1),y+(s>>1),red,green,blue);
 }
}

TextureCloudIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
int s=32;
int red1,green1,blue1;
int red2,green2,blue2;
int red3,green3,blue3;
int red4,green4,blue4;
int red,green,blue;
unsigned long color1,color2,color3,color4,newcolor;
int olddata,newdata;
for (x=0;x<im.X;x+=s)
for (y=0;y<im.Y;y+=s)
if (UseMaskPixel(doc,x,y))
 {
 SetDocPixelNormal(doc,x,y,random()%256,255,255);
 }
for (;s>1;s=s>>1)
for (x=0;x<im.X;x+=s)
for (y=0;y<im.Y;y+=s)
if (UseMaskPixel(doc,x,y))
 {
 color1=GetDocPixel(doc,x,y);
 color2=GetDocPixel(doc,(x+s)%im.X,y);
 color3=GetDocPixel(doc,x,(y+s)%im.Y);
 color4=GetDocPixel(doc,(x+s)%im.X,(y+s)%im.Y);
 red1=color1&255;green1=(color1>>8)&255;blue1=(color1>>16)&255;
 red2=color2&255;green2=(color2>>8)&255;blue2=(color2>>16)&255;
 red3=color3&255;green3=(color3>>8)&255;blue3=(color3>>16)&255;
 red4=color4&255;green4=(color4>>8)&255;blue4=(color4>>16)&255;
 red=rand_exp(red1,red2,12);
 green=rand_exp(green1,green2,12);
 blue=rand_exp(blue1,blue2,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x+(s>>1),y,red,green,blue);
 red=rand_exp(red1,red3,12);
 green=rand_exp(green1,green3,12);
 blue=rand_exp(blue1,blue3,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x,y+(s>>1),red,green,blue);
 red=rand_exp(red1,red2,16);
 red=rand_exp(red,red3,16);
 red=rand_exp(red,red4,12);
 green=rand_exp(green1,green2,16);
 green=rand_exp(green,green3,16);
 green=rand_exp(green,green4,12);
 blue=rand_exp(blue1,blue2,16);
 blue=rand_exp(blue,blue3,16);
 blue=rand_exp(blue,blue4,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x+(s>>1),y+(s>>1),red,green,blue);
 }
}

TextureFract001Im(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
int s=32;
int red1,green1,blue1;
int red2,green2,blue2;
int red3,green3,blue3;
int red4,green4,blue4;
int red,green,blue;
unsigned long color1,color2,color3,color4,newcolor;
int olddata,newdata;
for (;s>1;s=s>>1)
for (x=0;x<im.X;x+=s)
for (y=0;y<im.Y;y+=s)
if (UseMaskPixel(doc,x,y))
 {
 color1=GetDocPixel(doc,x,y);
 color2=GetDocPixel(doc,(x+s)%im.X,y);
 color3=GetDocPixel(doc,x,(y+s)%im.Y);
 color4=GetDocPixel(doc,(x+s)%im.X,(y+s)%im.Y);
 red1=color1&255;green1=(color1>>8)&255;blue1=(color1>>16)&255;
 red2=color2&255;green2=(color2>>8)&255;blue2=(color2>>16)&255;
 red3=color3&255;green3=(color3>>8)&255;blue3=(color3>>16)&255;
 red4=color4&255;green4=(color4>>8)&255;blue4=(color4>>16)&255;
 red=rand_exp(red1,red2,12);
 green=rand_exp(green1,green2,12);
 blue=rand_exp(blue1,blue2,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x+(s>>1),y,red,green,blue);
 red=rand_exp(red1,red3,12);
 green=rand_exp(green1,green3,12);
 blue=rand_exp(blue1,blue3,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x,y+(s>>1),red,green,blue);
 red=rand_exp(red1,red2,16);
 red=rand_exp(red,red3,16);
 red=rand_exp(red,red4,12);
 green=rand_exp(green1,green2,16);
 green=rand_exp(green,green3,16);
 green=rand_exp(green,green4,12);
 blue=rand_exp(blue1,blue2,16);
 blue=rand_exp(blue,blue3,16);
 blue=rand_exp(blue,blue4,12);
 if (red>255) red=255;if (red<0) red=0;
 if (green>255) green=255;if (green<0) green=0;
 if (blue>255) blue=255;if (blue<0) blue=0;
 SetDocPixelNormal(doc,x+(s>>1),y+(s>>1),red,green,blue);
 }
}

TextureStareogramIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
int s=32;
int red,green,blue;
unsigned long color,newcolor;
int value;

if (im.X<=80)
 {
 ReportThat("Image must be more than 80 pixels wide");
 return;
 } 

for (x=0;x<80;x++)
for (y=0;y<im.Y;y++)
 {
 SetDocPixelNormal(doc,x,y,random()%256,random()%256,random()%256);
 }

for (x=80;x<im.X;x++)
for (y=0;y<im.Y;y++)
if (UseMaskPixel(doc,x,y))
 {
 color=GetDocPixel(doc,x,y);
 red=color&255;green=(color>>8)&255;blue=(color>>16)&255;
 value=(red+green+blue)>>4;
 if (value>80) value=80;
 color=GetDocPixel(doc,x-80+value,y);
 red=color&255;green=(color>>8)&255;blue=(color>>16)&255; 
 SetDocPixelNormal(doc,x,y,red,green,blue);
 }
}

TextureStareogramNoRandIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
int s=32;
int red,green,blue;
unsigned long color,newcolor;
int value;

if (im.X<=80)
 {
 ReportThat("Image must be more than 80 pixels wide");
 return;
 } 

for (x=80;x<im.X;x++)
for (y=0;y<im.Y;y++)
if (UseMaskPixel(doc,x,y))
 {
 color=GetDocPixel(doc,x,y);
 red=color&255;green=(color>>8)&255;blue=(color>>16)&255;
 value=(red+green+blue)>>4;
 if (value>80) value=80;
 color=GetDocPixel(doc,x-80+value,y);
 red=color&255;green=(color>>8)&255;blue=(color>>16)&255; 
 SetDocPixelNormal(doc,x,y,red,green,blue);
 }
}

Texture3DSideIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
int s=32;
int red,green,blue;
unsigned long color,newcolor;
int value;

for (x=0;x<im.X;x++)
for (y=0;y<im.Y;y++)
if (UseMaskPixel(doc,x,y))
 {
 color=GetDocPixel(doc,x,y);
 red=color&255;green=(color>>8)&255;blue=(color>>16)&255;
 value=(red+green+blue)>>4;
 SetDocPixelNormal(doc,x,y-value,red,green,blue);
 }
}
