#include <stdio.h>
#include <malloc.h>
#include "doc.h"
#include "doctypes.h"


void CropRectangle(DocObj *doc,int x,int y,int width,int height)
{
DocObj newdoc[1];
int oldx,oldy;
int f,g,F,G;
unsigned long color;
newdoc->parent=doc->parent;
newdoc->display=doc->display;
newdoc->screen=doc->screen;
newdoc->cmap=doc->cmap;
createanydocofsize(newdoc,"resized",NEW_DOC,width,height);
printf ("draw new doc\n");
ReportThat("copying data");
for (f=0;f<width;f++)
for (g=0;g<height;g++)
 {
 color=GetDocPixel(doc,f+x,g+y);
 SetDocPixelNormal(newdoc,f,g,color&255,(color>>8)&255,(color>>16)&255);
 }
newdoc->active=True;
printf ("old doc going away...\n");
destroydoc(doc);
printf ("old doc is dead...\n");
memcpy (doc,newdoc,sizeof(DocObj));
doc->active=True;
printf ("old doc is alive again...\n");
ReportThat("crop done");
}

void ResizeDoc(DocObj *doc,DocObj *newdoc, int x,int y)
{
int oldx,oldy;
int f,g,F,G;
unsigned long color;
newdoc->parent=doc->parent;
newdoc->display=doc->display;
newdoc->screen=doc->screen;
newdoc->cmap=doc->cmap;
createanydocofsize(newdoc,"resized",NEW_DOC,x,y);
printf ("draw new doc\n");
ReportThat("copying data");
for (f=0;f<x;f++)
for (g=0;g<y;g++)
 {
 F=f*doc->img.X/x;
 G=g*doc->img.Y/y;
 if (UseMaskPixel(doc,F,G))
  {
  color=GetDocPixel(doc,F,G);
  SetDocPixelNormal(newdoc,f,g,color&255,(color>>8)&255,(color>>16)&255);
  }
 }
newdoc->active=True;
ReportThat("resize done");
}


