#include <stdio.h>
#include <malloc.h>
#include <setjmp.h>
#include <jpeglib.h>
#include "memimage.h"

struct custom_error_mgr 
 { 
 struct jpeg_error_mgr pub;
 jmp_buf setjmp_buffer;
 };

typedef struct custom_error_mgr * custom_error_ptr;

METHODDEF void

custom_error_exit(j_common_ptr cinfo)
{
 char buffer[128];
 custom_error_ptr error=(custom_error_ptr) cinfo->err;
 longjmp (error->setjmp_buffer,1);
}

MemImage readjpg(char* filename)
{
MemImage im;
struct jpeg_decompress_struct cinfo;
struct custom_error_mgr jerr;
JSAMPROW row_pointer[1];
FILE *infile;
int row_stride,res,f,Width,Height;
unsigned char *buffer[1];
/*
JSAMPARRAY buffer;
*/
unsigned char k,v;
if ((infile=fopen(filename,"rb"))==NULL)
 {
 fprintf(stderr,"cant read infile\n");exit(1);
 }
cinfo.err=jpeg_std_error(&jerr.pub);
jerr.pub.error_exit=custom_error_exit;
if (setjmp(jerr.setjmp_buffer))
 {
 im.X=0;
 im.data=malloc(100);
 (cinfo.err->format_message) ((j_common_ptr) &cinfo,im.data);
 jpeg_destroy_decompress(&cinfo);
 fclose(infile);
 return im;
 }
jpeg_create_decompress(&cinfo);
jpeg_stdio_src(&cinfo,infile);
jpeg_read_header(&cinfo,TRUE);

jpeg_start_decompress(&cinfo);

printf ("W:%i,H:%i,CC:%i,C:%i\n",cinfo.output_width,cinfo.output_height,
cinfo.out_color_components,cinfo.output_components);

im.X=Width=cinfo.output_width;
im.Y=Height=cinfo.output_height;
im.palette=0;
row_stride=cinfo.output_width*cinfo.output_components;
im.Bits=8;
im.Planes=cinfo.output_components;
im.data=malloc(im.Y*row_stride);
if (im.data==NULL) {printf("couldn't malloc\n");return;}
buffer[0]=malloc(row_stride*cinfo.output_components);
/*
buffer=(*cinfo.mem->alloc_sarray) ((j_common_ptr) &cinfo,JPOOL_IMAGE,row_stride,1);
*/
printf ("malloc ok %i %i \n",buffer,im.data);
while (cinfo.output_scanline < cinfo.output_height)
 {
 jpeg_read_scanlines(&cinfo,buffer,1);
/*
 for (f=0;f<row_stride;f++) 
  {
  *(im.data+cinfo.output_scanline*row_stride+f)=*(buffer[0]+f);
  }
*/
 memcpy (im.data+(cinfo.output_scanline-1)*row_stride,buffer[0],row_stride);
 }
free (buffer[0]);
printf ("read finished\n");
jpeg_finish_decompress(&cinfo);
jpeg_destroy_decompress(&cinfo);
printf ("finished jpeg\n");
fclose(infile);
printf ("returning\n");
return(im);
}
