#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

int menu(Display *display,Window parent,char entry[][20],int x,int y,int No,int direction)
{
int ItemHeight=12;
int selected=0;
unsigned long ret_val;
Bool menuactivated=False;
XFontStruct *FontStr;
static int initstate=0;
Window window;
GC gc,wingc;
int screen,Width,Height,depth;
static XSetWindowAttributes attr;
XEvent event;
int f;
char k;
XWMHints wmhints;
XSizeHints hints;
Pixmap pixmap,tile;
Colormap cmap;
XColor grey,red;

void ShowSelectedMenuItem(void)
{
XClearWindow(display,window);
XSetFunction(display,wingc,GXinvert);
XFillRectangle(display,window,wingc,0,ItemHeight*selected,Width,ItemHeight);
XSetFunction(display,wingc,GXcopy);
}


hints.flags=USPosition;
screen=DefaultScreen(display);
cmap=DefaultColormap(display,screen);
depth=DisplayPlanes(display,screen);
Width=120+120*(No-1)*(direction==1);
FontStr=XQueryFont(display,XGContextFromGC(DefaultGC(display,screen)));
XGetFontProperty(FontStr,XA_POINT_SIZE,&ret_val);
ItemHeight=ret_val/10;
Height=ItemHeight+ItemHeight*(No-1)*(direction==0);
attr.override_redirect=True;
attr.save_under=True;
window=XCreateWindow(display,parent/* RootWindow(display,screen)*/,
x,y,Width,Height,3,depth,InputOutput,
XDefaultVisual(display,screen),
CWSaveUnder | CWColormap | CWOverrideRedirect,&attr);
XSetStandardProperties(display,window,"Main Menu","main menu",None,0,0,&hints);
XSetWindowBackground(display,window,WhitePixel(display,screen));
XSelectInput(display,window,ButtonPressMask | ButtonReleaseMask | ExposureMask | LeaveWindowMask | KeyPressMask);
pixmap=XCreatePixmap(display,window,Width,Height,depth);
gc=XCreateGC(display,pixmap,0,0);
wingc=XCreateGC(display,window,0,0);
XSetForeground(display,gc,WhitePixel(display,screen));
XSetBackground(display,gc,WhitePixel(display,screen));

if (depth>4)
 {
 grey.red=grey.green=grey.blue=32000;
 XAllocColor(display,cmap,&grey); 
 XSetForeground(display,gc,grey.pixel); 
 XFillRectangle(display,pixmap,gc,0,0,Width,Height);
 } /* end big depth */
else
 {
 red.red=65535;red.blue=49152;red.green=49152;
 XAllocColor(display,cmap,&red); 
 tile=XCreatePixmap(display,window,2,2,depth);
 XSetForeground(display,gc,BlackPixel(display,screen));
 XFillRectangle(display,tile,gc,0,0,4,4);
 XSetForeground(display,gc,red.pixel);
 XDrawPoint(display,tile,gc,1,1);
 XSetTile (display,gc,tile);
 XSetFillStyle(display,gc,FillTiled);
 XFillRectangle(display,pixmap,gc,0,0,Width,Height);
 XSetFillStyle(display,gc,FillSolid);
 } /* end small depth */
for (f=0;f<No;f++)
 {
 XSetForeground(display,gc,BlackPixel(display,screen));
 XDrawString(display,pixmap,gc,1+f*120*direction,1+ItemHeight+f*ItemHeight*(1-direction),
 entry[f],strlen(entry[f]));
 XSetForeground(display,gc,WhitePixel(display,screen));
 XDrawString(display,pixmap,gc,f*120*direction,ItemHeight+f*ItemHeight*(1-direction),
 entry[f],strlen(entry[f]));
 }
if (depth>4)
 {
 XSetForeground(display,gc,BlackPixel(display,screen));
 }
else
 {
 XSetForeground(display,gc,WhitePixel(display,screen));
 }

for (f=0;f<No;f++)
 {
 XDrawLine(display,pixmap,gc,
 f*120*direction,ItemHeight+f*ItemHeight*(1-direction),
 f*120*direction+120,ItemHeight+f*ItemHeight*(1-direction));
 }
XSetForeground(display,gc,BlackPixel(display,screen));
XSetWindowBackgroundPixmap(display,window,pixmap);
XFreePixmap(display,pixmap);
XClearWindow(display,window);
XFreeGC(display,gc);
XMapRaised(display,window);
while  (XNextEvent(display,&event),event.type!=Expose);
ShowSelectedMenuItem();
while (1)
 {
 XNextEvent(display,&event);
 if (event.type==Expose) /* paint */
  {
  XClearWindow(display,window);
  } /* end paint */
 if (event.type==ButtonPress)
  {
  menuactivated=True;
  }
 if (event.type==ButtonRelease)
  {
  if (direction) f=event.xbutton.x/120; else f=event.xbutton.y/ItemHeight;
  printf ("menu will return %i\n",f);
  XFreeGC(display,wingc);
  XDestroyWindow(display,window);
  return f;
  }
 if (event.type==KeyPress)
  {
  k=XLookupKeysym(&(event.xkey),event.xkey.state);
  /* this only works with down direction - not side */
  if (k=='T') /* down */
   {
   selected++;selected%=No;
   ShowSelectedMenuItem();
   }
  if (k=='R') /* up */
   {
   if (!selected) selected=No;
   selected--;
   ShowSelectedMenuItem();
   }
  if (k==13) /* select */
   {
   XFreeGC(display,wingc);
   XDestroyWindow(display,window);
   return selected;
   } 
  for (f=0;f<No;f++)
   {
   if (k==*entry[f])
    {
    XFreeGC(display,wingc);
    XDestroyWindow(display,window);
    return f;
    }
   }
  }
 if (event.type==LeaveNotify && menuactivated==False)
  {
  XFreeGC(display,wingc);
  XDestroyWindow(display,window);
  printf ("exiting by leave\n");
  return -1;
  }
 } /* end while */
}



