#include <X11/Xlib.h>
#include "doc.h"
#include "border.h"
#define RBYTE random()%256

unsigned long ColBW[2],ColRGB[2][2][2];
unsigned char colors[5][9][5];
unsigned char grays[32];


void ReloadImage(DocObj *doc);
unsigned long ConvLongPixel(unsigned long ColVal,int depth);

void PutPixelRect(DocObj *doc,int x,int y,int w,int h,unsigned long color)
{
unsigned long pixel;
int zx,zy;
for (zx=0;zx<w;zx++)
for (zy=0;zy<h;zy++)
 {
/*
 printf ("x:%i y:%i w:%i h:%i zx:%i zy:%i",x,y,w,h,zx,zy);
*/
 pixel=ConvLongPixel(color,doc->depth);
 XPutPixel(doc->image,x+zx,y+zy,pixel);
 }
}

void ShowImage(DocObj *doc)
{
Display *display=doc->display;
Window window=doc->Iwindow;
GC gc=doc->gc;
char text[50];
sprintf(text,"%s (%i:%i)",doc->filename,doc->zoomin,doc->zoomout);
XClearWindow(display,doc->Twindow);
XSetForeground(doc->display,doc->gc,BlackPixel(doc->display,doc->screen));
XDrawImageString(doc->display,doc->Twindow,doc->gc,0,THEIGHT-BORDERW,text,strlen(text));
/*
XSetFunction (display,gc,GXcopyInverted);
*/
XPutImage(display,window,gc,doc->image,0,0,0,0,doc->win_w,doc->win_h);
}

unsigned long ConvPixel8 (int red,int green,int blue,int depth)
{
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red/64;gv=green/32;bv=blue/64;
rd=(red%64)<<2;
gd=(green%32)<<3;
bd=(blue%64)<<2;
pixel=colors[rv+(rd>RBYTE)][gv+(gd>RBYTE)][bv+(bd>RBYTE)];
return pixel;
}

unsigned long ConvPixel16 (int red,int green,int blue,int depth)
{
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red/8;gv=green/4;bv=blue/8;  
pixel=bv+32*gv+(32*64*rv);
return pixel;
}

unsigned long ConvPixel24 (int red,int green,int blue,int depth)
{
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;  
pixel=rv+(gv<<8)+(bv<<16);
return pixel;
}


unsigned long ConvPixel1v01 (int red,int green,int blue,int depth)
{
static int rl=0,gl=0,bl=0;
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;
pixel=ColRGB[rv>(rl*64)][gv>(gl*64)][bv>(bl*64)];
rl++;gl++;bl++;
rl%=4;gl%=4;bl%=4;
return pixel;
}

unsigned long ConvPixel1v02 (int red,int green,int blue,int depth)
{
static int rl=0,gl=0,bl=0;
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;
pixel=ColRGB[rv>(rl*128)][gv>(gl*128)][bv>(bl*128)];
rl++;gl++;bl++;
rl%=2;gl%=2;bl%=2;
return pixel;
}

unsigned long ConvPixel1v03 (int red,int green,int blue,int depth)
{
static int rl=0,gl=0,bl=0;
static int rll=0,gll=0,bll=0;
static int Rl=0,Gl=0,Bl=0;
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;
pixel=ColRGB[rv>(rl*192) || rv>(rll*224)][gv>(gl*192) || gv>(gll*224)][bv>(bl*192) || bv>(bll*224)];
rl++;gl++;bl++;
rl%=2;gl%=2;bl%=2;
Rl++;Gl++;Bl++;
Rl%=256;Gl%=256;Bl%=256;
rll=(Rl>128);
gll=(Gl>128);
bll=(Bl>128);
return pixel;
}

unsigned long ConvPixel1v04 (int red,int green,int blue,int depth)
{
static int rl=0,gl=0,bl=0;
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;
pixel=ColRGB[rv>(rl*128+64)][gv>(gl*128+64)][bv>(bl*128+64)];
rl++;gl++;bl++;
rl%=2;gl%=2;bl%=2;
return pixel;
}

unsigned long ConvPixel1v05 (int red,int green,int blue,int depth)
{
static int x,y;
int X,Y,f,g,p;
int rmatrix[8][8];
int gmatrix[8][8];
int bmatrix[8][8];
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;
x++;
if (x>256)
 {
 x=0;y++;y%=256;
 }
p=0;
for (f=0;f<8;f++)
for (g=0;g<8;g++)
 {
 rmatrix[f][g]=(p<rv);
 gmatrix[f][g]=(p<gv);
 bmatrix[f][g]=(p<bv);
 p++;
 }
X=x%8;Y=y%8;
pixel=ColRGB[rmatrix[X][Y]][gmatrix[X][Y]][bmatrix[X][Y]];
return pixel;
}

unsigned long ConvPixel1v06 (int red,int green,int blue,int depth)
{
static int x,y;
int X,Y,f,g,p;
int rmatrix[8][8];
int gmatrix[8][8];
int bmatrix[8][8];
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;
x++;
if (x>256)
 {
 x=0;y++;y%=256;
 }
p=0;
for (f=0;f<8;f++)
for (g=0;g<8;g++)
 {
 rmatrix[f][g]=(p<=rv);
 gmatrix[f][g]=(p<=gv);
 bmatrix[f][g]=(p<=bv);
 p++;
 }
X=x%8;Y=y%8;
pixel=ColRGB[rmatrix[X][Y]][gmatrix[X][Y]][bmatrix[X][Y]];
return pixel;
}


unsigned long ConvPixel1v07 (int red,int green,int blue,int depth)
{
static int x,y;
int X,Y,f,g,p;
int rmatrix[8][8];
int gmatrix[8][8];
int bmatrix[8][8];
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;
x++;
if (x>8)
 {
 x=0;y++;y%=256;
 }
p=0;
for (f=0;f<8;f++)
for (g=0;g<8;g++)
 {
 rmatrix[f][g]=(p<=rv);
 gmatrix[f][g]=(p<=gv);
 bmatrix[f][g]=(p<=bv);
 p++;
 }
X=x%8;Y=y%8;
pixel=ColRGB[rmatrix[X][Y]][gmatrix[X][Y]][bmatrix[X][Y]];
return pixel;
}

unsigned long ConvPixel1 (int red,int green,int blue,int depth)
{
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
rv=red;gv=green;bv=blue;
pixel=ColRGB[rv>RBYTE][gv>RBYTE][bv>RBYTE];
return pixel;
}

unsigned long ConvPixelAll (int red,int green,int blue,int depth) /* not used */
{
unsigned char rv,gv,bv;
unsigned char rd,gd,bd;
unsigned long pixel;
switch (depth) /* we only handle color as it is temporary display only */
 {
 case 8: /* 8 bit server */
  rv=red/64;gv=green/32;bv=blue/64;
  rd=(red%64)<<2;
  gd=(green%32)<<3;
  bd=(blue%64)<<2;
  pixel=colors[rv+(rd>RBYTE)][gv+(gd>RBYTE)][bv+(bd>RBYTE)];
  break;
 case 16:/* 16 bit server */
  rv=red/8;gv=green/4;bv=blue/8;  
  pixel=bv+32*gv+(32*64*rv);
  break;
 default:/* all other servers (usually 1-4 bit) */
  rv=red;gv=green;bv=blue;
  pixel=ColRGB[rv>RBYTE][gv>RBYTE][bv>RBYTE];
 }
return pixel;
}

unsigned long (*ConvPixel) (int red,int green,int blue,int depth)=&ConvPixel1;

void initpixelconvert(int depth)
{
switch (depth)
 {
 case 8:
  ConvPixel=&ConvPixel8;
  break;
 case 16:
  ConvPixel=&ConvPixel16;
  break;
 case 24:
  ConvPixel=&ConvPixel24;
  break;
 case 32:
  ConvPixel=&ConvPixel24;
  break;
 default:
  ConvPixel=&ConvPixel1;
 }
}

unsigned long ConvLongPixel(unsigned long ColVal,int depth)
{
unsigned int red,green,blue;
unsigned long pixel;
red=(ColVal&255);
green=((ColVal>>8)&255);
blue=((ColVal>>16)&255);
pixel=ConvPixel(red,green,blue,depth);
/*
printf ("R:%i,G:%i,B:%i,pixel is %Li\n",red,green,blue,pixel);
*/
return pixel;
}

void DrawTemp(DocObj *doc,int x,int y,int red,int green,int blue)
{
int zx,zy,zi,zo,wx,wy;
unsigned long pixel;
zi=doc->zoomin;
zo=doc->zoomout;
wx=(x-doc->startx)*zi/zo;
wy=(y-doc->starty)*zi/zo;
if (wx<0 || wx>=doc->win_w-zi || wy<0 || wy>=doc->win_h-zi) return;
red&=255;
green&=255;
blue&=255;
pixel=ConvPixel(red,green,blue,doc->depth);
XSetForeground(doc->display,doc->gc,pixel);
XFillRectangle(doc->display,doc->Iwindow,doc->gc,wx,wy,zi,zi);
PutPixelRect(doc,wx,wy,doc->zoomin,doc->zoomin,(unsigned long)(red|(green<<8)|(blue<<16)));
}

int ColDiff(unsigned long c1,unsigned long c2)
{
unsigned int red1,green1,blue1;
unsigned int red2,green2,blue2;
unsigned int redD,greenD,blueD,Diff;
red1=(c1&255);
green1=((c1>>8)&255);
blue1=((c2>>16)&255);
red2=(c2&255);
green2=((c2>>8)&255);
blue2=((c2>>16)&255);
redD=abs(red1-red2);
greenD=abs(green1-green2);
blueD=abs(blue1-blue2);
Diff=redD+greenD+blueD/3;
return Diff;
}

unsigned long GetDocPixel(DocObj *doc,int x, int y)
{
unsigned char rv,gv,bv;
MemImage im=doc->img;
int scanline;

if (x>=im.X || x<0 || y>=im.Y || y<0) return 0;
scanline=(im.X*im.Bits+7)/8;
scanline*=im.Planes;
if (im.Planes==3)
 {
 rv=*(im.data+y*scanline+x*3);
 gv=*(im.data+y*scanline+x*3+1);
 bv=*(im.data+y*scanline+x*3+2);
 }
else
 {
 rv=gv=bv=*(im.data+y*scanline+x);
 } 
return rv+(gv<<8)+(bv<<16);
}

unsigned long GetDocVirPixel(DocObj *doc,int x,int y)
{
int rx,ry;
rx=doc->startx+x*doc->zoomout/doc->zoomin;
ry=doc->starty+y*doc->zoomout/doc->zoomin;
return GetDocPixel(doc,rx,ry);
}


void SetDocPixelNormal(DocObj *doc,int x,int y,int red,int green,int blue)
{
MemImage im=doc->img;
int scanline;

if (x>=im.X || x<0 || y>=im.Y || y<0) return; 
scanline=(im.X*im.Bits+7)/8;
scanline*=im.Planes;
if (im.Planes==3)
 {
 *(im.data+y*scanline+x*3)=(unsigned char) red;
 *(im.data+y*scanline+x*3+1)=(unsigned char) green;
 *(im.data+y*scanline+x*3+2)=(unsigned char) blue;
 }
else
 {
 *(im.data+y*scanline+x)=(unsigned char) green;
 } 
DrawTemp(doc,x,y,red,green,blue);
}

void SetDocPixelIfLighter(DocObj *doc,int x,int y,int red,int green,int blue)
{
MemImage im=doc->img;
int scanline;
int redc,greenc,bluec;
int source,dest;

if (x>=im.X || x<0 || y>=im.Y || y<0) return; 
scanline=(im.X*im.Bits+7)/8;
scanline*=im.Planes;
if (im.Planes==3)
 {
 redc=(int)*(im.data+y*scanline+x*3);
 greenc=(int)*(im.data+y*scanline+x*3+1);
 bluec=(int)*(im.data+y*scanline+x*3+2);
 }
else
 {
 greenc=redc=bluec=(int) *(im.data+y*scanline+x);
 } 
source=green*4+red*2+blue;
dest=greenc*4+redc*2+bluec;
if (source>dest)
 {
 if (im.Planes==3)
  {
  *(im.data+y*scanline+x*3)=(unsigned char) red;
  *(im.data+y*scanline+x*3+1)=(unsigned char) green;
  *(im.data+y*scanline+x*3+2)=(unsigned char) blue;
  }
 else
  {
  *(im.data+y*scanline+x)=(unsigned char) green;
  }
 DrawTemp(doc,x,y,red,green,blue);
 }
}

void SetDocPixelIfDarker(DocObj *doc,int x,int y,int red,int green,int blue)
{
MemImage im=doc->img;
int scanline;
int redc,greenc,bluec;
int source,dest;

if (x>=im.X || x<0 || y>=im.Y || y<0) return; 
scanline=(im.X*im.Bits+7)/8;
scanline*=im.Planes;
if (im.Planes==3)
 {
 redc=(int)*(im.data+y*scanline+x*3);
 greenc=(int)*(im.data+y*scanline+x*3+1);
 bluec=(int)*(im.data+y*scanline+x*3+2);
 }
else
 {
 greenc=redc=bluec=(int) *(im.data+y*scanline+x);
 } 
source=green*4+red*2+blue;
dest=greenc*4+redc*2+bluec;
if (source<dest)
 {
 if (im.Planes==3)
  {
  *(im.data+y*scanline+x*3)=(unsigned char) red;
  *(im.data+y*scanline+x*3+1)=(unsigned char) green;
  *(im.data+y*scanline+x*3+2)=(unsigned char) blue;
  }
 else
  {
  *(im.data+y*scanline+x)=(unsigned char) green;
  }
 DrawTemp(doc,x,y,red,green,blue);
 }
}

void SetDocPixelMergeHalf(DocObj *doc,int x,int y,int red,int green,int blue)
{
MemImage im=doc->img;
int scanline;
int redc,greenc,bluec;
int source,dest;

if (x>=im.X || x<0 || y>=im.Y || y<0) return; 
scanline=(im.X*im.Bits+7)/8;
scanline*=im.Planes;
if (im.Planes==3)
 {
 redc=(int)*(im.data+y*scanline+x*3);
 greenc=(int)*(im.data+y*scanline+x*3+1);
 bluec=(int)*(im.data+y*scanline+x*3+2);
 }
else
 {
 greenc=redc=bluec=(int) *(im.data+y*scanline+x);
 } 
redc=(redc+red)>>1;
greenc=(greenc+green)>>1;
bluec=(bluec+blue)>>1;
if (im.Planes==3)
 {
 *(im.data+y*scanline+x*3)=(unsigned char) redc;
 *(im.data+y*scanline+x*3+1)=(unsigned char) greenc;
 *(im.data+y*scanline+x*3+2)=(unsigned char) bluec;
 }
else
 {
 *(im.data+y*scanline+x)=(unsigned char) greenc;
 }
DrawTemp(doc,x,y,redc,greenc,bluec);
}


void (*SetDocPixelSelected) (DocObj *doc,int x,int y,int red,int green,int blue)=&SetDocPixelNormal;

void SetDocPixel(DocObj *doc,int x,int y,int red,int green,int blue)
{
SetDocPixelSelected(doc,x,y,red,green,blue);
}

void SetDocPixelModeNormal()
{
SetDocPixelSelected=&SetDocPixelNormal;
}

void SetDocPixelModeIfLighter()
{
SetDocPixelSelected=&SetDocPixelIfLighter;
}

void SetDocPixelModeIfDarker()
{
SetDocPixelSelected=&SetDocPixelIfDarker;
}

void SetDocPixelModeMergeHalf()
{
SetDocPixelSelected=&SetDocPixelMergeHalf;
}


void SetDocPixelColor(DocObj *doc,int x,int y,unsigned long colordef)
{
unsigned int red,green,blue;
MemImage im=doc->img;
int scanline;

if (x>=im.X || x<0 || y>=im.Y || y<0) return; 

red=(colordef&255);
green=((colordef>>8)&255);
blue=((colordef>>16)&255);
SetDocPixel(doc,x,y,red,green,blue);
}

void SetDocVirPixel(DocObj *doc,int x,int y,unsigned long colordef)
{
unsigned int red,green,blue;
int rx,ry,zx,zy,zi,zo,wx,wy;
unsigned char rv,gv,bv;
red=(colordef&255);
green=((colordef>>8)&255);
blue=((colordef>>16)&255);
if (doc->img.Planes==1) red=blue=green;
zi=doc->zoomin;
zo=doc->zoomout;
rx=doc->startx+x*zo/zi;
ry=doc->starty+y*zo/zi;
SetDocPixel(doc,rx,ry,red,green,blue);
}

void UpdateWholeDocView(DocObj *doc)
{
ReloadImage(doc);
ShowImage(doc);
if (doc->maskactive) LoadMaskOnShowImage(doc);
}

void UpdateDocOrMask(DocObj *doc)
{
if (doc->maskactive) LoadMaskOnShowDoc(doc); else UpdateWholeDocView(doc);
}

void CropSize(DocObj *doc)
{
if (doc->win_w>640) doc->win_w=640;
if (doc->win_h>480) doc->win_h=480;
}

void UpdateDocScrollBars(DocObj *doc)
{
int dividerX=doc->img.X-doc->win_w*doc->zoomout/doc->zoomin;
int dividerY=doc->img.Y-doc->win_h*doc->zoomout/doc->zoomin;
if (dividerX>0)
 {
 doc->horbar.value=doc->startx*doc->horbar.maxval/dividerX;
 }
if (dividerY>0)
 {
 doc->verbar.value=doc->starty*doc->verbar.maxval/dividerY;
 }
UpdateHorBar(doc->display,doc->horbar);
UpdateVerBar(doc->display,doc->verbar);
}

void BringDocBarsInlimits(DocObj *doc)
{
/* to return image to original position so that loss of scrollbars does not matter */
int MaxstartX=(doc->img.X-doc->win_w*doc->zoomout/doc->zoomin);
int MaxstartY=(doc->img.Y-doc->win_h*doc->zoomout/doc->zoomin);
printf ("MaxX%i,MaxY:%i,sx:%i,sy:%i\n",MaxstartX,MaxstartY,doc->startx,doc->starty);
if (MaxstartX<doc->startx) doc->startx=MaxstartX;
if (MaxstartY<doc->starty) doc->starty=MaxstartY;
if (doc->startx<0) doc->startx=0;
if (doc->starty<0) doc->starty=0;
/**/
}

void ClipWinToMax(DocObj *doc)
{
int maxw,maxh;
maxw=doc->Width*doc->zoomin/doc->zoomout;
maxh=doc->Height*doc->zoomin/doc->zoomout;
if (maxw<doc->win_w) doc->win_w=maxw;
if (maxh<doc->win_h) doc->win_h=maxh;
}

void ZoomOutImage(DocObj *doc)
{
int MaxstartX,MaxstartY;
doc->zoomin--;
if (doc->zoomin<1)
 {
 doc->zoomin=1;
 doc->zoomout++;
 }
ClipWinToMax(doc);
/*
CropSize(doc);
*/
BringDocBarsInlimits(doc);
UpdateDocOrMask(doc);
UpdateDocScrollBars(doc);
}

void ZoomInImage(DocObj *doc)
{
doc->zoomout--;
if (doc->zoomout<1) 
 {
 doc->zoomout=1;
 doc->zoomin++;
 }
ClipWinToMax(doc);
BringDocBarsInlimits(doc);
UpdateDocOrMask(doc);
UpdateDocScrollBars(doc);
}

void HorScroll(DocObj *doc,XEvent *event)
{
int value;
value=CheckBar (doc->display,&doc->horbar,event,True);
if (value!=-1) /* we are ready */
 {
 doc->startx=(doc->img.X-doc->win_w*doc->zoomout/doc->zoomin)*value/doc->horbar.maxval;
 if (doc->startx<0) doc->startx=0;
 setwaitcurs(doc->display,doc->window,doc->screen,doc->cmap);
 UpdateDocOrMask(doc);
 setnormalcurs(doc->display,doc->window);
 }
}

void VerScroll(DocObj *doc,XEvent *event)
{
int value;
value=CheckBar (doc->display,&doc->verbar,event,False);
if (value!=-1) /* we are ready */
 {
 doc->starty=(doc->img.Y-doc->win_h*doc->zoomout/doc->zoomin)*value/doc->verbar.maxval;
 printf ("starty is %i win_h:%i,img.Y:%i\n",doc->starty,doc->win_h,doc->img.Y);
 if (doc->starty<0) (doc->starty=0);
 setwaitcurs(doc->display,doc->window,doc->screen,doc->cmap);
 UpdateDocOrMask(doc);
 setnormalcurs(doc->display,doc->window);
 }
}

void SetWindowSizes(DocObj *doc)
{
XResizeWindow(doc->display,doc->Iwindow,doc->win_w,doc->win_h);
XResizeWindow(doc->display,doc->Twindow,doc->win_w,THEIGHT);
XResizeWindow(doc->display,doc->window,
doc->win_w+1+BORDERW*2+
THEIGHT*(doc->win_h<doc->Height*doc->zoomin/doc->zoomout),
doc->win_h+1+THEIGHT+BORDERW*4+
THEIGHT*(doc->win_w<doc->Width*doc->zoomin/doc->zoomout)
);
SetHorScrollBar(doc->display,&doc->horbar,BORDERW,doc->win_h+THEIGHT+4*BORDERW,doc->win_w,THEIGHT);
SetVerScrollBar(doc->display,&doc->verbar,doc->win_w+2*BORDERW,THEIGHT+3*BORDERW,THEIGHT,doc->win_h);
}

void InitializePalette(Display *display,int screen,int depth)
{
Colormap cmap=DefaultColormap(display,screen);
unsigned short red,green,blue;
unsigned int f;
XColor color;
if (depth==8)
 {
 for (red=0;red<5;red++)
 for (green=0;green<9;green++)
 for (blue=0;blue<5;blue++)
  {
  color.red=red*16383;
  color.green=green*8191;
  color.blue=blue*16383;
  XAllocColor(display,cmap,&color);
  colors[red][green][blue]=color.pixel;
  }
 for (f=0;f<32;f++)
  {
  color.red=color.green=color.blue=f*2048;
  XAllocColor(display,cmap,&color);
  grays[f]=color.pixel;
  } 
 }
if (depth!=8 && depth!=16)
 {
 for (red=0;red<2;red++)
 for (green=0;green<2;green++)
 for (blue=0;blue<2;blue++)
  {
  color.red=red*65535;
  color.green=green*65535;
  color.blue=blue*65535;
  XAllocColor(display,cmap,&color);
  ColRGB[red][green][blue]=color.pixel;
  }
 for (f=0;f<2;f++)
  {
  color.red=color.green=color.blue=f*65535;
  XAllocColor(display,cmap,&color);
  ColBW[f]=color.pixel;
  }
 }
}

void LoadImage(DocObj *doc)
{
Display *display=doc->display;
GC gc=doc->gc;
int depth=doc->depth;
MemImage im=doc->img;
int screen=doc->screen;
int x,y,fvirx,fviry,xwrap,scanline,xl,yl;
unsigned short red,green,blue;
unsigned int f;
XColor color;
Colormap cmap;
unsigned char value,rv,gv,bv;
unsigned long pixel;

char repstr[80];

int zi,zo;
int zx,zy;
char *data;

char k;
XEvent event;

data=(char *)malloc(doc->win_w*doc->win_h*((depth+7)/8));
cmap=DefaultColormap(display,screen);
doc->image=XCreateImage(display,XDefaultVisual(display,screen),
depth,ZPixmap,0,data,doc->win_w,doc->win_h,8,0);
XInitImage(doc->image);

SetWindowSizes(doc);

if (depth==8)
 {
 for (red=0;red<5;red++)
 for (green=0;green<9;green++)
 for (blue=0;blue<5;blue++)
  {
  color.red=red*16383;
  color.green=green*8191;
  color.blue=blue*16383;
  XAllocColor(display,cmap,&color);
  colors[red][green][blue]=color.pixel;
  }
 for (f=0;f<32;f++)
  {
  color.red=color.green=color.blue=f*2048;
  XAllocColor(display,cmap,&color);
  grays[f]=color.pixel;
  } 
 }
if (depth!=8 && depth!=16)
 {
 for (red=0;red<2;red++)
 for (green=0;green<2;green++)
 for (blue=0;blue<2;blue++)
  {
  color.red=red*65535;
  color.green=green*65535;
  color.blue=blue*65535;
  XAllocColor(display,cmap,&color);
  ColRGB[red][green][blue]=color.pixel;
  }
 for (f=0;f<2;f++)
  {
  color.red=color.green=color.blue=f*65535;
  XAllocColor(display,cmap,&color);
  ColBW[f]=color.pixel;
  }
 }

scanline=(im.X*im.Bits+7)/8;
scanline*=im.Planes;

zo=doc->zoomout;
zi=doc->zoomin;
k=0;
for (y=0;y<doc->win_h-zi && k!='q';y+=zi)
 {
 fviry=FromVirY(doc,y);
 if (XCheckMaskEvent(doc->display,KeyPressMask,&event)) k=XLookupKeysym(&(event.xkey),event.xkey.state);
 if (XCheckMaskEvent(doc->display,ButtonPressMask,&event))
  {
  k='q';
  XPutBackEvent(doc->display,&event); 
  }
 fvirx=FromVirX(doc,0);
 xwrap=1;
 for (x=0;x<doc->win_w;x+=zi)
  {
  if (im.Planes==3)
   {
   rv=*(im.data+fviry*scanline+fvirx*3);
   gv=*(im.data+fviry*scanline+fvirx*3+1);
   bv=*(im.data+fviry*scanline+fvirx*3+2);
   }
  else
   {
   rv=gv=bv=*(im.data+fviry*scanline+fvirx);
   }
  if (zo>1)
   {
   fvirx+=zo;
   }
  else
   {
   xwrap+=zi;
   if (xwrap>=zo) 
    {
    fvirx+=zo;
    xwrap-=zo;
    }
   }
  PutPixelRect(doc,x,y,zi,zi,(unsigned long)(((int)rv)|(((int)gv)<<8)|(((int)bv)<<16)));
/*
  pixel=ConvPixel(rv,gv,bv,doc->depth);
  for (xl=0;xl<zi;xl++)
  for (yl=0;yl<zi;yl++)
  XPutPixel(doc->image,x+xl,y+yl,pixel);
*/
  /*
  SetDocVirPixel(doc,x,y,GetDocVirPixel(doc,x,y));
  */ 
  }
 if ((y & 31)==0)
  {
  sprintf(repstr,"Refreshed %i of %i scanlines, press q or click to abort",y,doc->win_h);
  ReportThat(repstr);
  ShowImage(doc);
  }
 }
if (k=='q') ReportThat ("refresh aborted"); else ReportThat("image refreshed");
}

void ReloadImage(DocObj *doc)
{
XDestroyImage(doc->image);
LoadImage(doc);
}

void ShowDocInfo(DocObj *doc)
{
char report[512];
sprintf(report,"Width   %i\nHeight  %i
Zoom    %i:%i\nPlanes  %i\nBits    %i
name    %s\n",
doc->img.X,doc->img.Y,doc->zoomin,doc->zoomout,
doc->img.Planes,doc->img.Bits,doc->filename);
ShowText("Document info:",report,doc->display);
}

void ShowDocInfoAnd(DocObj *doc,char *text)
{
char report[512];
sprintf(report,"%s\nWidth   %i\nHeight  %i
Zoom    %i:%i\nPlanes  %i\nBits    %i
name    %s\n",text,
doc->img.X,doc->img.Y,doc->zoomin,doc->zoomout,
doc->img.Planes,doc->img.Bits,doc->filename);
ShowText("Document info:",report,doc->display);
}




