#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <sys/dir.h>
#include <malloc.h>

extern unsigned long(*ConvPixel) (int red, int green,int blue,int depth);

static Window window;
static GC gc;
static int screen;
static XEvent event;
static XSetWindowAttributes attr;
static Font font;
static XSizeHints hints;
static int depth;
static int ItemHeight=12;
static int ItemWidth=8;
static unsigned long ret_val;
static XFontStruct *FontStr;

SetItemHeight(Display *display)
{
FontStr=XQueryFont(display,XGContextFromGC(DefaultGC(display,DefaultScreen(display))));
XGetFontProperty(FontStr,XA_POINT_SIZE,&ret_val);
ItemHeight=ret_val/10;
if (ItemHeight<5) ItemHeight=3;
if (ItemHeight>50) ItemHeight=50;
ItemWidth=ItemHeight;
}

void createlocalwin(Display *display,char *title,char *icont,int XSize,int YSize)
{
hints.flags=USPosition;
attr.save_under=True;
screen=DefaultScreen(display);
depth=DisplayPlanes(display,screen);
window=XCreateWindow(display,RootWindow(display,screen),
40,40,XSize,YSize,1,depth,InputOutput,XDefaultVisual(display,screen),
CWColormap | CWSaveUnder ,&attr);
XSetStandardProperties(display,window,title,icont,None,0,0,&hints);
gc=XCreateGC(display,window,0,0);
SetItemHeight(display);
XSetWindowBackground(display,window,WhitePixel(display,screen));
XSetForeground(display,gc,BlackPixel(display,screen));
XSetBackground(display,gc,WhitePixel(display,screen));
XClearWindow(display,window);
XMapRaised(display,window);
XSelectInput(display,window,ExposureMask);
while(XNextEvent(display,&event),event.type!=Expose || event.xbutton.window!=window);
XDrawImageString(display,window,gc,12,12,"----",4);
XFlush(display);
}

void EnableClickAndKeys(Display *display)
{
XSelectInput(display,window,ExposureMask|KeyPressMask|ButtonPressMask);
}

void destroylocalwindow(Display *display)
{
/*
XFreeGC(display,gc);
*/
XDestroyWindow(display,window);
XFlush(display);
}

void DrawDataLine(Display *display, int x,int y,int l,unsigned char *data)
{
int f;
/*
int red,green,blue;
unsigned long pixel;
*/
for (f=0;f<l;f++)
 {
/*
 red=*(data+3*f);
 green=*(data+3*f+1);
 blue=*(data+3*f+2);
 pixel=ConvPixel(red,green,blue,depth);
*/
 XSetForeground(display,gc,ConvPixel(*(data+3*f),*(data+3*f+1),*(data+3*f+2),depth));
 XDrawPoint(display,window,gc,x+f,y);
 }
}

char getkey(Display *display,Window window)
{
XEvent event;
char inchar;
if (XCheckWindowEvent(display,window,KeyPressMask,&event))
 {
 inchar=XLookupKeysym(&(event.xkey),event.xkey.state);
 return inchar;
 }
else
 {
 return(0);
 } 
}

void ShowMessage(char *Title,char *text,Display *display)
{
SetItemHeight(display);
createlocalwin(display,Title,Title,360,56);
XSelectInput(display,window,ButtonPressMask | KeyPressMask | ExposureMask );
XClearWindow(display,window);
XDrawImageString (display,window,gc,ItemHeight,ItemHeight,text,strlen(text));
while (XNextEvent(display,&event),event.type!=ButtonPress && event.type!=KeyPress)
 {
 XDrawImageString (display,window,gc,ItemHeight,ItemHeight,text,strlen(text));
/*
 XDrawPoint(display,window,gc,event.xmotion.x,event.xmotion.y);
*/
 }
destroylocalwindow(display);
}


void ask(char *prompt, char *text,Display *display)
{
static char res[40];
unsigned char k;
char atext[40];
int textlen=strlen(text),pos=strlen(text);
int f,cursel;
SetItemHeight(display);
createlocalwin(display,"QUESTION!","question!",30*ItemHeight,4*ItemHeight);
XFlush(display);
XSelectInput(display,window,KeyPressMask);
for (k=1;k!=13;k=getkey(display,window))
 {
 if (k>=32 && k<128) 
  {
/*
  printf ("%c\n",k);
*/
  text[pos++]=k;
  text[++textlen]=0;
  }
 if (k==8 && pos>0)
  {
  text[--pos]=0;
  textlen--;
  }
 if (k)
  {
  XClearWindow(display,window);
  XDrawImageString(display,window,gc,ItemHeight,ItemHeight,prompt,strlen(prompt));
  strncpy(atext,text,37);
  if (textlen>37) textlen=37;
  atext[textlen]='|';atext[textlen+1]=0;
  XDrawImageString(display,window,gc,ItemHeight,ItemHeight*3,atext,textlen+1);
  XFlush(display);
  }
 }
destroylocalwindow(display);
}


void ShowText(char *Title,char *text,Display *display)
{
int f,last,pos,nol=0;
void updtextimg()
 {
 for (f=last=pos=0;text[f]!=0;f++)
  {
  if (text[f]=='\n')
   {
   XDrawImageString (display,window,gc,ItemHeight,ItemHeight*2+ItemHeight*pos,text+last,f-last);
   last=f+1;
   pos++;
   }
  }
 } /* end updtextimg */
for (f=0;text[f]!=0;f++)
 {
 if (text[f]=='\n') nol++;
 }
SetItemHeight(display);
createlocalwin(display,Title,Title,360,3*ItemHeight+nol*ItemHeight);
XSelectInput(display,window,ButtonPressMask | KeyPressMask | ExposureMask );
XClearWindow(display,window);
updtextimg();
while (XNextEvent(display,&event),event.type==Expose)
 {
 updtextimg();
/*
 XDrawImageString (display,window,gc,12,12,text,strlen(text));
*/
 }
destroylocalwindow(display);
}

void dialog(char * in,char *out,char *defstr,int items,Display *display,int *minvals,int *maxvals)
{
int f;
char instr[16][40];
char outstr[16][40];
char mode[16];
int pos[16];
int y,c;
int noquit;
unsigned char inchar;
char *ptr;

void ShowStrings()
 {
 char astring[40];
 int l=strlen(outstr[y]);
 if (l>37) l=37;
 strncpy(astring,outstr[y],l);
 astring[l]=' ';
 astring[l+1]=' ';
 astring[l+2]=0;
 for (f=0;f<items;f++)
  {
  XDrawImageString(display,window,gc,ItemHeight,ItemHeight+ItemHeight*f,instr[f],strlen(instr[f]));
  if (y==f)
   {
   XSetBackground(display,gc,WhitePixel(display,screen));
   XDrawImageString(display,window,gc,15*ItemHeight,ItemHeight+ItemHeight*f,astring,l+2);
   astring[l+1]=0;
   XSetBackground(display,gc,BlackPixel(display,screen));
   XDrawImageString(display,window,gc,15*ItemHeight,ItemHeight+ItemHeight*f,astring,l+1);
   XSetBackground(display,gc,WhitePixel(display,screen));
   }
  XDrawImageString(display,window,gc,15*ItemHeight,ItemHeight+ItemHeight*f,outstr[f],strlen(outstr[f]));
  }
 }

void HideIndicator()
{
XSetForeground(display,gc,WhitePixel(display,screen));
XDrawLine(display,window,gc,0,y*ItemHeight+(ItemHeight>>1),10,y*ItemHeight+(ItemHeight>>1));
}

void ShowIndicator()
{
XSetForeground(display,gc,BlackPixel(display,screen));
XDrawLine(display,window,gc,0,y*ItemHeight+(ItemHeight>>1),10,y*ItemHeight+(ItemHeight>>1));
}

SetItemHeight(display);

if (items>15)
 {
 ShowMessage("error", "too many args",display); 
 return;
 }

createlocalwin(display,"Please fill in the folowing:","dialog",30*ItemHeight,4*ItemHeight+ItemHeight*items);

ptr=in;

for (f=0;f<items;f++)
 {
 mode[f]=*(ptr++);
 c=0;
 while (*ptr!='\n') instr[f][c++]=*(ptr++);
 ptr++;
 instr[f][c]=0;
 }

ptr=defstr;

for (f=0;f<items;f++)
 {
 c=0;
 while (*ptr!='\n') outstr[f][c++]=*(ptr++);
 ptr++;
 outstr[f][c]=0;
 }

y=0;
ShowStrings();
XDrawImageString(display,window,gc,170,items*ItemHeight+2*ItemHeight,"OK",2);
XFlush(display);
noquit=True;
XSelectInput (display,window,KeyPressMask | ExposureMask | ButtonPressMask | PointerMotionMask);
while (noquit)
 {
 if (XCheckWindowEvent(display,window,KeyPressMask,&event))
  {
  inchar=XLookupKeysym(&(event.xkey),event.xkey.state);
  if (inchar>=32 && inchar <=128 && strlen(outstr[y])<38) 
   {
   outstr[y][1+strlen(outstr[y])]=0;
   outstr[y][strlen(outstr[y])]=inchar;
   }
  if (inchar==8 && strlen(outstr[y])>0)
   {
   outstr[y][strlen(outstr[y])-1]=0;
   XSetForeground(display,gc,WhitePixel(display,screen));
   XFillRectangle(display,window,gc,15*ItemHeight,y*ItemHeight,30*ItemHeight,y*ItemHeight+ItemHeight);
   XSetForeground(display,gc,BlackPixel(display,screen));
   }
  if (inchar==9)
   {
   HideIndicator();
   y++;y%=items;
   ShowIndicator();
   }
  if (inchar==13)
   {
   noquit=False;
   }
  ShowStrings();
  }
 if (XCheckWindowEvent(display,window,PointerMotionMask,&event))
  {
  HideIndicator();
  y=event.xmotion.y/ItemHeight;
  if (y<0) y=0;
  if (y>=items) y=items-1;
  ShowIndicator();
  }
 if (XCheckWindowEvent(display,window,ButtonPressMask,&event))
  {
  if (event.xbutton.y>items*ItemHeight)  noquit=False;
  }
 }
printf ("ready to produce outstring\n");
ptr=out;
for (f=0;f<items;f++)
 {
 c=0;
 while (outstr[f][c]) *(ptr++)=outstr[f][c++];
 *(ptr++)='\n';
 }
*(ptr++)=0;
printf ("outstring produced\n");
destroylocalwindow(display);
}

void getdim(int *x,int *y,Display *display)
{
char Xtext[40],Ytext[40];
char instring[256],outstring[256];
char defstring[256];
int maxvals[16],minvals[16];
sprintf(instring,"tWhat is the X dimension?\ntWhat is the Y dimension?\n");
sprintf(defstring,"%i\n%i\n",*x,*y);
dialog(instring,outstring,defstring,2,display,minvals,maxvals);
printf ("%s\n",outstring);
sscanf(outstring,"%i %i",x,y);
printf ("scaned %i %i \n",*x,*y);
if (*x<=0) *x=1;
if (*y<=0) *y=1;
}

void getfactors(float *a,float *b,Display *display)
{
char instring[256],outstring[256];
char defstring[256];
int maxvals[16],minvals[16];
sprintf(instring,"tWhat is the a factor?\ntWhat is the b factor?\n");
sprintf(defstring,"%5.0f\n%5.0f\n",*a,*b);
dialog(instring,outstring,defstring,2,display,minvals,maxvals);
printf ("%s\n",outstring);
sscanf(outstring,"%f %f",a,b);
printf ("scaned %f %f \n",*a,*b);
}

void getfactor(float *a,Display *display)
{
char instring[256],outstring[256];
char defstring[256];
int maxvals[16],minvals[16];
sprintf(instring,"tWhat is the factor?\n");
sprintf(defstring,"%5.0f\n",*a);
dialog(instring,outstring,defstring,1,display,minvals,maxvals);
printf ("%s\n",outstring);
sscanf(outstring,"%f",a);
printf ("scaned %f \n",*a);
}

void getscaninfo(int *x,int *y,int *xst, int *yst, Display *display)
{
char Xtext[40],Ytext[40];
char instring[256],outstring[256];
char defstring[256];
int maxvals[16],minvals[16];
sprintf(instring,"tWhat is the X dimension?\ntWhat is the Y dimension?\ntReduce x hoy many times?\ntReduce y how many times?\n");
sprintf(defstring,"%i\n%i\n%i\n%i\n",*x,*y,*xst,*yst);
dialog(instring,outstring,defstring,4,display,minvals,maxvals);
printf ("%s\n",outstring);
sscanf(outstring,"%i %i %i %i",x,y,xst,yst);
printf ("scaned %i %i %i %i \n",*x,*y,*xst,*yst);
if (*x<=0) *x=1;
if (*y<=0) *y=1;
if (*x>4096) *x=4096;
if (*y>4096) *y=4096;
if (*xst<1) *xst=1;
if (*yst<1) *yst=1;
if (*xst>16) *xst=16;
if (*yst>16) *yst=16;
}

typedef struct Filter5x5
{
int data[5][5];
int divider;
int shift;
} Filter5x5;


char ModifyText(Display *display,char *text,int x,int y,XEvent event)
{
unsigned char k;
int l;
char inchar;
l=strlen(text);
if (event.type==KeyPress)
 {
 inchar=XLookupKeysym(&(event.xkey),event.xkey.state);
 }
else
 {
 inchar=0;
 } 
k=inchar;
/*
printf ("got key %c (%i)\n",k,(int) k);
*/
XSetForeground(display,gc,WhitePixel(display,screen));
XFillRectangle(display,window,gc,x+ItemWidth,y,ItemWidth*l,ItemHeight);
XSetForeground(display,gc,BlackPixel(display,screen));
if (k=='-' || (k>='0' && k<='9'))
 {
 text[l++]=k;
 if (l>4) l=4;
 text[l]=0;
 }
if (k==8 && l>0) text[--l]=0; 
XDrawImageString(display,window,gc,x+ItemWidth,y+ItemHeight,text,strlen(text));
return k;
}

void AskCustomFilter(Filter5x5 *filter,Display *display)
{
unsigned char k;
char vals[5][5][7];
char shift[7];
char divider[7];
char *control;
int x,y,p=0;
int cx,cy;
Bool quitflag=False;
printf ("asking \n");
SetItemHeight(display);
createlocalwin(display,"Custom Filter","custom filter",ItemHeight*30,ItemHeight*10);
XSelectInput (display,window,ButtonPressMask | KeyPressMask);
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 sprintf (vals[x][y],"%i",filter->data[x][y]);
 printf ("%s\n",vals[x][y]);
 XDrawImageString(display,window,gc,(x*5+1)*ItemWidth,(y+1)*ItemHeight,vals[x][y],strlen(vals[x][y]));
 }
sprintf (shift,"%i",filter->shift);
sprintf (divider,"%i",filter->divider);
XDrawImageString(display,window,gc,ItemWidth,(7)*ItemHeight,shift,strlen(shift));
XDrawImageString(display,window,gc,ItemWidth,(8)*ItemHeight,divider,strlen(divider));

control=vals[0][0];
cx=cy=0;
while (quitflag==False)
 {
 XNextEvent(display,&event);
 k=ModifyText(display,control,cx,cy,event);
 if (k==9)
  {
  XSetForeground(display,gc,WhitePixel(display,screen));
  XDrawLine(display,window,gc,cx,cy+ItemHeight/2,cx+ItemWidth,cy+ItemHeight/2);
  XSetForeground(display,gc,BlackPixel(display,screen));
  p++;p%=27;
  if (p<25)
   {
   cx=p%5;
   cy=p/5;
   control=vals[cx][cy];
   cx=cx*ItemWidth*5;
   cy=cy*ItemHeight;
   } 
  else
   {
   if (p==25)  
    {
    cx=0;cy=6*ItemHeight;
    control=shift;
    }
   else
    {
    cx=0;cy=7*ItemHeight;
    control=divider;
    } /* end p 25 or 26 */
   } /* end p */
   XDrawLine(display,window,gc,cx,cy+ItemHeight/2,cx+ItemWidth,cy+ItemHeight/2);
  }
 if (event.type==ButtonPress)
  {
  quitflag=True;
  }
 if (k=='\r') quitflag=True;
 }
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 printf ("X:%i Y:%i,string :%s ",x,y,vals[x][y]);
 if (strlen(vals[x][y])==0) 
  {
  printf ("changing ... ");
  vals[x][y][0]='0';
  vals[x][y][1]=0;
  }
 sscanf(vals[x][y],"%i",&filter->data[x][y]);
 printf (" int is %i\n",filter->data[x][y]);
 }
if (strlen(shift))
 {
 sscanf(shift,"%i",&filter->shift);
 }
else
 {
 filter->shift=0; 
 }
if (strlen(divider))
 {
 sscanf(divider,"%i",&filter->divider);
 }
else
 {
 filter->divider=1; 
 }
if (filter->divider==0) filter->divider=1;
destroylocalwindow(display);
}
