#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include "doc.h"

typedef struct Filter5x5
{
int data[5][5];
int divider;
int shift;
} Filter5x5;

typedef struct Filter3x3
{
int data[5][5];
int divider;
int shift;
} Filter3x3;

/* Only works with images with 8 Bits and any number of planes */
InvertIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h;
char *data;
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=255-(*data);
 }
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

HorrifyIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
int total,count;
char *data;
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 total=0;
 count=0;
 for (x=-2;x<3;x++)
 for (y=-2;y<3;y++)
  {
  if ((f+x)>=0 && (f+x)<im.X && (g+y)>=0 && (g+y)<im.Y)
   {
   data=im.data+((f+x)+(g+y)*im.X)*im.Planes+h;
   total+=*data;
   count++;
   }
  }
 if (count>0)
  {
  data=im.data+(f+g*im.X)*im.Planes+h;
  *data=total/count;
  }
 }
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

BlurIm(DocObj *doc)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count;
unsigned char *data;
newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 total=0;
 count=0;
 for (x=-2;x<3;x++)
 for (y=-2;y<3;y++)
  {
  if ((f+x)>=0 && (f+x)<im.X && (g+y)>=0 && (g+y)<im.Y)
   {
   data=im.data+((f+x)+(g+y)*im.X)*im.Planes+h;
   total+=*data;
   count++;
   }
  }
 if (count>0)
  {
  data=newim.data+(f+g*im.X)*im.Planes+h;
  *data=(unsigned char)(total/count);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

BlurFastIm(DocObj *doc)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count;
unsigned char *data;
newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL) 
 {
 printf ("not enough memory\n");
 return;
 }

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 total=0;
 count=0;
 for (x=-1;x<1;x++)
 for (y=-1;y<1;y++)
  {
  if ((f+x)>=0 && (f+x)<im.X && (g+y)>=0 && (g+y)<im.Y)
   {
   data=im.data+((f+x)+(g+y)*im.X)*im.Planes+h;
   total+=*data;
   count++;
   }
  }
 if (count>0)
  {
  data=newim.data+(f+g*im.X)*im.Planes+h;
  *data=(unsigned char)(total/count);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

SharpenRandomgoodIm(DocObj *doc)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count,value;
unsigned char *data;
newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 total=0;
 count=0;
 for (x=-1;x<2;x++)
  {
  if ((f+x)>=0 && (f+x)<im.X && (g+x)>=0 && (g+x)<im.Y)
   {
   data=im.data+((f+x)+(g+x)*im.X)*im.Planes+h;
   total+=*data;
   count++;
   }
  }
 if (count>0)
  {
  data=newim.data+(f+g*im.X)*im.Planes+h;
  value=*data;
  value+=total;
  *data=(unsigned char)(value);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

SharpenFastIm(DocObj *doc)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count,value;
unsigned char *data;
newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 total=0;
 count=0;
 for (x=-1;x<1;x++)
  {
  if ((f+x)>=0 && (f+x)<im.X && (g+x)>=0 && (g+x)<im.Y)
   {
   data=im.data+((f+x)+(g+x)*im.X)*im.Planes+h;
   if (x) total-=*data; else total+=2*(*data);
   count++;
   }
  }
 if (count>0)
  {
  data=newim.data+(f+g*im.X)*im.Planes+h;
  value=total;
  if (value>255) value=255;
  if (value<0) value=0;
  *data=(unsigned char)(value);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

Filter5x5Im(DocObj *doc,Filter5x5 filter)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count,value;
unsigned char *data;

char repstr[80];

for (x=-2;x<3;x++)
for (y=-2;y<3;y++)
 {
 printf ("V:%i \t",filter.data[x+2][y+2]);
 if (y==2) printf ("\n");
 }

newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
 {
 for (g=0;g<im.Y;g++)
 if (UseMaskPixel(doc,f,g))
  {
  total=0;
  count=0;
  for (x=-2;x<3;x++)
  for (y=-2;y<3;y++)
   {
   if ((f+x)>=0 && (f+x)<im.X && (g+y)>=0 && (g+y)<im.Y)
    {
    data=im.data+((f+x)+(g+y)*im.X)*im.Planes+h;
    value=(int)(*data);
    value*=(filter.data[x+2][y+2]);
    total+=value;
    count++;
    }
   }
  if (filter.divider!=0)
   {
   data=newim.data+(f+g*im.X)*im.Planes+h;
   value=(total/filter.divider);
   value+=filter.shift;
   if (value>255) value=255;
   if (value<0) value=0;
   *data=(unsigned char) value;
   }
  }
 if ((f & 15)==0)
  {
  sprintf(repstr,"plane %i column %i done",h,f);
  ReportThat(repstr);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

Filter3x3Im(DocObj *doc,Filter3x3 filter)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count,value;
unsigned char *data;

char repstr[80];

for (x=-1;x<2;x++)
for (y=-1;y<2;y++)
 {
 printf ("X:%i,Y:%i,V:%i \n",x,y,filter.data[x+1][y+1]);
 }

newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
 {
 for (g=0;g<im.Y;g++)
 if (UseMaskPixel(doc,f,g))
  {
  total=0;
  count=0;
  for (x=-1;x<2;x++)
  for (y=-1;y<2;y++)
   {
   if ((f+x)>=0 && (f+x)<im.X && (g+y)>=0 && (g+y)<im.Y)
    {
    data=im.data+((f+x)+(g+y)*im.X)*im.Planes+h;
    value=(int)(*data);
    value*=(filter.data[x+1][y+1]);
    total+=value;
    count++;
    }
   }
  if (filter.divider!=0)
   {
   data=newim.data+(f+g*im.X)*im.Planes+h;
   value=(total/filter.divider);
   value+=filter.shift;
   if (value>255) value=255;
   if (value<0) value=0;
   *data=(unsigned char) value;
   }
  }
 if ((f & 15)==0)
  {
  sprintf(repstr,"plane %i column %i done",h,f);
  ReportThat(repstr);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}


SharpenSmIm(DocObj *doc)
{
Filter5x5 filter;
int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,-1,-1,-1,0},
 {0,-1,64,-1,0},
 {0,-1,-1,-1,0},
 {0,0,0,0,0}
 };
int x,y;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 }
filter.divider=56;
filter.shift=0;
Filter5x5Im (doc,filter);
}


SharpenMedIm(DocObj *doc)
{
Filter5x5 filter;
int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,-1,-1,-1,0},
 {0,-1,40,-1,0},
 {0,-1,-1,-1,0},
 {0,0,0,0,0}
 };
int x,y,c=0;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=c;
filter.shift=0;
Filter5x5Im (doc,filter);
}

SharpenCon4Im(DocObj *doc)
{
Filter5x5 filter;
int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,0,-2,0,0},
 {0,-2,9,-2,0},
 {0,0,-2,0,0},
 {0,0,0,0,0}
 };
int x,y,c=0;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=c;
filter.shift=0;
Filter5x5Im (doc,filter);
}

SharpenCon8Im(DocObj *doc)
{
Filter5x5 filter;
int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,-2,-2,-2,0},
 {0,-2,17,-2,0},
 {0,-2,-2,-2,0},
 {0,0,0,0,0}
 };
int x,y,c=0;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=c;
filter.shift=0;
Filter5x5Im (doc,filter);
}

SharpenIm(DocObj *doc)
{
SharpenCon8Im(doc);
}


SharpenHugeIm(DocObj *doc)
{
Filter5x5 filter;
int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,-1,-1,-1,0},
 {0,-1,-9,-1,0},
 {0,-1,-1,-1,0},
 {0,0,0,0,0}
 };
int x,y,c=0;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=c;
filter.shift=0;
Filter5x5Im (doc,filter);
}

SharpenDiagIm(DocObj *doc)
{
Filter5x5 filter;
int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,-1,0,0,0},
 {0,0,49,0,0},
 {0,0,0,-1,0},
 {0,0,0,0,0}
 };
int x,y,c=0;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=c;
filter.shift=0;
Filter5x5Im (doc,filter);
}

ThresEdge1Im(DocObj *doc,int threshold)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int value,valued,max,diff;
unsigned char *data;
unsigned char *datad;

char repstr[80];

newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
 {
 for (g=0;g<im.Y;g++)
 if (UseMaskPixel(doc,f,g))
   {
   max=0;
    {
    if ((f+1)>=0 && (f+1)<im.X && (g+1)>=0 && (g+1)<im.Y)
     {
     data=im.data+((f)+(g)*im.X)*im.Planes+h;
     datad=im.data+((f+1)+(g+1)*im.X)*im.Planes+h;
     value=(int)(*data);
     valued=(int)(*datad);
     diff=abs(value-valued);
     if (max<diff) max=diff;
     }
    data=newim.data+(f+g*im.X)*im.Planes+h;   
    if (max>threshold)
     {
     value=threshold-max;
     if (value>128) value=128;
     if (value<0) value=0;
     }
    else
     {
     value=255;
     }
    *data=(unsigned char) value;  
    }
   }
  if ((f & 15)==0)
  {
  sprintf(repstr,"plane %i column %i done",h,f);
  ReportThat(repstr);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

ThresEdge4Im(DocObj *doc,int threshold)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int value,valued,max,diff;
unsigned char *data;
unsigned char *datad;

char repstr[80];

newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
 {
 for (g=0;g<im.Y;g++)
 if (UseMaskPixel(doc,f,g))
   {
   max=0;
    {
    if ((f+1)>=0 && (f+1)<im.X && (g)>=0 && (g)<im.Y)
     {
     data=im.data+((f)+(g)*im.X)*im.Planes+h;
     datad=im.data+((f+1)+(g)*im.X)*im.Planes+h;
     value=(int)(*data);
     valued=(int)(*datad);
     diff=abs(value-valued);
     if (max<diff) max=diff;
     }
    if ((f-1)>=0 && (f-1)<im.X && (g)>=0 && (g)<im.Y)
     {
     data=im.data+((f)+(g)*im.X)*im.Planes+h;
     datad=im.data+((f-1)+(g)*im.X)*im.Planes+h;
     value=(int)(*data);
     valued=(int)(*datad);
     diff=abs(value-valued);
     if (max<diff) max=diff;
     }
    if ((f)>=0 && (f)<im.X && (g+1)>=0 && (g+1)<im.Y)
     {
     data=im.data+((f)+(g)*im.X)*im.Planes+h;
     datad=im.data+((f)+(g+1)*im.X)*im.Planes+h;
     value=(int)(*data);
     valued=(int)(*datad);
     diff=abs(value-valued);
     if (max<diff) max=diff;
     }
    if ((f)>=0 && (f)<im.X && (g-1)>=0 && (g-1)<im.Y)
     {
     data=im.data+((f)+(g)*im.X)*im.Planes+h;
     datad=im.data+((f)+(g-1)*im.X)*im.Planes+h;
     value=(int)(*data);
     valued=(int)(*datad);
     diff=abs(value-valued);
     if (max<diff) max=diff;
     }
    data=newim.data+(f+g*im.X)*im.Planes+h;   
    if (max>threshold)
     {
     value=threshold-max;
     if (value>128) value=128;
     if (value<0) value=0;
     }
    else
     {
     value=255;
     }
    *data=(unsigned char) value;  
    }
   }
  if ((f & 15)==0)
  {
  sprintf(repstr,"plane %i column %i done",h,f);
  ReportThat(repstr);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

HandDrawOrigIm(DocObj *doc)
{
Filter3x3 filter;
int fdata[3][3]=
 {
 {-4,0,0},
 {0,4,0},
 {0,0,0},
 };
int x,y,c=0;
for (x=0;x<3;x++)
for (y=0;y<3;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=1;
filter.shift=255;
Filter3x3Im (doc,filter);
}

HandDrawDiagIm(DocObj *doc)
{
Filter3x3 filter;
int fdata[3][3]=
 {
 {-1,0,1},
 {0,1,0},
 {-1,0,0},
 };
int x,y,c=0;
for (x=0;x<3;x++)
for (y=0;y<3;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=1;
filter.shift=255;
Filter3x3Im (doc,filter);
}

CustomEffectIm(DocObj *doc)
{
Filter5x5 filter;
static int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,0,0,0,0},
 {0,0,1,0,0},
 {0,0,0,0,0},
 {0,0,0,0,0},
 };
int x,y,c=0;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=c;
filter.shift=0;
AskCustomFilter(&filter,doc->display);
Filter5x5Im (doc,filter);
}

EmbossIm(DocObj *doc)
{
Filter5x5 filter;
int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,-1,0,0,0},
 {0,0,1,0,0},
 {0,0,0,0,0},
 {0,0,0,0,0}
 };
int x,y,c=0;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=1;
filter.shift=128;
Filter5x5Im (doc,filter);
}

Sharpen1PixelIm(DocObj *doc)
{
Filter5x5 filter;
int fdata[5][5]=
 {
 {0,0,0,0,0},
 {0,-1,0,0,0},
 {0,0,2,0,0},
 {0,0,0,0,0},
 {0,0,0,0,0}
 };
int x,y,c=0;
for (x=0;x<5;x++)
for (y=0;y<5;y++)
 {
 filter.data[x][y]=fdata[x][y];
 c+=fdata[x][y];
 }
filter.divider=c;
filter.shift=0;
Filter5x5Im (doc,filter);
}

MergeDocsWrapIm(DocObj *doc,DocObj *doc2,DocObj *channel)
{
MemImage im=doc->img;
MemImage im2=doc2->img;
MemImage imc=channel->img;
MemImage newim;
int f,g,h,x,y;
int secxw,secyw,chxw,chyw;
int total,count;
unsigned char *data,*data2,*datach;
newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }
secxw=doc2->img.X;
secyw=doc2->img.Y;
chxw=channel->img.X;
chyw=channel->img.Y;
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 data2=im2.data+((f%secxw)+(g%secyw)*im2.X)*im2.Planes+h*(im.Planes==im2.Planes);
 datach=imc.data+((f%chxw)+(g%chyw)*imc.X)*imc.Planes+h*(im.Planes==imc.Planes);
 total=(*data)*(*datach)/256+(*data2)*(255-(*datach))/256;
 data=newim.data+(f+g*im.X)*im.Planes+h;
 *data=total;
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

AddDocsWrapIm(DocObj *doc,DocObj *doc2)
{
MemImage im=doc->img;
MemImage im2=doc2->img;
MemImage newim;
int f,g,h,x,y;
int secxw,secyw;
int total,count;
unsigned char *data,*data2;
newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }
secxw=doc2->img.X;
secyw=doc2->img.Y;
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 data2=im2.data+((f%secxw)+(g%secyw)*im2.X)*im2.Planes+h*(im.Planes==im2.Planes);
 total=((*data)+(*data2))/2;
 data=newim.data+(f+g*im.X)*im.Planes+h;
 *data=total;
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

void rotate(int *x,int *y,double angle)
{
float nx,ny;
nx=(*x)*cos(angle)-(*y)*sin(angle);
ny=(*x)*sin(angle)+(*y)*cos(angle);
*x=nx;*y=ny;
}

RotateIm(DocObj *doc,int xc,int yc,double angle)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count;
unsigned char *data;
newim.data=malloc(im.X*im.Y*im.Planes);
if (newim.data==NULL)
 {
 printf ("not enough memory\n");
 return;
 }


for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
*(newim.data+(f+g*im.X)*im.Planes+h)=*(im.data+(f+g*im.X)*im.Planes+h);

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 x=f-xc;
 y=g-yc;
 rotate (&x,&y,angle);
 x+=xc;
 y+=yc;
 if (x>0 && y>0 && x<im.X && y<im.Y)
  {
  data=im.data+(x+y*im.X)*im.Planes+h;
  total=*data;
  data=newim.data+(f+g*im.X)*im.Planes+h;
  *data=(unsigned char)(total);
  }
 }
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=*(newim.data+(f+g*im.X)*im.Planes+h);
 }
free(newim.data);
printf ("now to reload\n");
UpdateWholeDocView(doc);
}

StretchHistogramIm(DocObj *doc)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h;
int total,count,value,diff;
unsigned char min,max;
unsigned char *data;
max=0;
min=255;
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 if ((*data)>max) max=(*data);
 if ((*data)<min) min=(*data);
 }
diff=(int)(max-min);
if (diff==0) diff=1;
for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 *data=((*data)-min)*255/diff;
 }
UpdateWholeDocView(doc);
}

ShiftBrightIm(DocObj *doc,int amount)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count,value;
unsigned char *data;

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 total=(*data)+amount;
 if (total>255) total=255;
 if (total<0) total=0;
 *data=total;
 }
UpdateWholeDocView(doc);
}

MulBrightIm(DocObj *doc,int amount)
{
MemImage im=doc->img;
MemImage newim;
int f,g,h,x,y;
int total,count,value;
unsigned char *data;

for (h=0;h<im.Planes;h++)
for (f=0;f<im.X;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 data=im.data+(f+g*im.X)*im.Planes+h;
 total=(*data)*amount/256;
 if (total>255) total=255;
 if (total<0) total=0;
 *data=total;
 }
UpdateWholeDocView(doc);
}

FlipHorIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
unsigned long color;
for (f=0;f<(im.X)>>1;f++)
for (g=0;g<im.Y;g++)
if (UseMaskPixel(doc,f,g))
 {
 color=GetDocPixel(doc,im.X-f-1,g);
 SetDocPixelColor(doc,im.X-f-1,g,GetDocPixel(doc,f,g));
 SetDocPixelColor(doc,f,g,color);
 }
}

FlipVerIm(DocObj *doc)
{
MemImage im=doc->img;
int f,g,h,x,y;
unsigned long color;
for (f=0;f<im.X;f++)
for (g=0;g<(im.Y)>>1;g++)
if (UseMaskPixel(doc,f,g))
 {
 color=GetDocPixel(doc,f,im.Y-g-1);
 SetDocPixelColor(doc,f,im.Y-g-1,GetDocPixel(doc,f,g));
 SetDocPixelColor(doc,f,g,color);
 }
}









