#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <sys/dir.h>
#include <malloc.h>


char *browse(Display *display,Window parent)
{
static char res[40];
static Window window;
static GC gc;
static int screen;
static XEvent event;
static XSetWindowAttributes attr;
static Font font;
XFontStruct *FontStr;
static int ItemHeight=12;
static unsigned long ret_val;
char inchar;

int depth,f;
static int cursel=0;
int listlim;
char *list;
DIR *dir;
struct dirent *dirent;
int files,pos,retcode;

XSizeHints hints;

void SetItemHeight(Display *display)
{
FontStr=XQueryFont(display,XGContextFromGC(DefaultGC(display,DefaultScreen(display))));
XGetFontProperty(FontStr,XA_POINT_SIZE,&ret_val);
ItemHeight=ret_val/10;
if (ItemHeight<5) ItemHeight=3;
if (ItemHeight>50) ItemHeight=50;
}

hints.flags=USPosition | PMinSize | PMaxSize;
hints.min_width=hints.max_width=380;
hints.min_height=hints.max_height=264;

listlim=5;
list=malloc(40*listlim);
if (list==NULL) {printf ("not enough memory\n");return;}
attr.save_under=True;
screen=DefaultScreen(display);
depth=DisplayPlanes(display,screen);
window=XCreateWindow(display,RootWindow(display,screen),
40,40,
hints.max_width,
hints.max_height,
1,depth,InputOutput,XDefaultVisual(display,screen),
CWColormap | CWSaveUnder ,&attr);
XSetStandardProperties(display,window,"Select a file","file browser",None,0,0,&hints);
gc=XCreateGC(display,window,0,0);
XSetWindowBackground(display,window,WhitePixel(display,screen));
XSetForeground(display,gc,BlackPixel(display,screen));
XSetBackground(display,gc,WhitePixel(display,screen));
XClearWindow(display,window);
XSelectInput(display,window,ExposureMask);
XMapRaised(display,window);
while(XNextEvent(display,&event),event.type!=Expose);

SetItemHeight(display);

dir=opendir(".");

files=0;
pos=cursel-5;
if (pos<0) pos=0;
while (1)
 {
 dirent=readdir(dir);
 if (dirent==NULL) break;
 files++;
 if (strlen(dirent->d_name)>39)
  {
  strcpy(list+40*files," < - entry too long - >");
  }
 else
  {
  strcpy(list+40*files,dirent->d_name);
  }
 if (files>=listlim-1)
  {
  listlim+=10;
  list=realloc(list,40*listlim);
  }
 }
closedir(dir);

XSelectInput(display,window,ExposureMask | ButtonPressMask | KeyPressMask | PointerMotionMask);
while(1)
{
 XDrawRectangle(display,window,gc,11-4,11-4,40*8+8,20*12+8);
 XDrawRectangle(display,window,gc,11+40*8+4,11-4,36,20*12+8);
 XClearArea(display,window,11+40*8+4+1,11-4+36+1,36-2,20*12+8-72-2,0);
 XDrawRectangle(display,window,gc,11+40*8+4,11-4+36,36,20*12+8-72);
 XDrawLine(display,window,gc,337,41,337+16,41-16);
 XDrawLine(display,window,gc,337+32,41,337+16,25);
 XDrawLine(display,window,gc,337,221,337+16,221+16);
 XDrawLine(display,window,gc,337+32,221,337+16,221+16);
 XFillRectangle(display,window,gc,12+40*8+6,(pos*128/files)+32+15,31,31);
 XClearArea(display,window,11-3,11-3,40*8+6,20*12+6,0);
 XDrawLine(display,window,gc,12,ItemHeight+(cursel-pos)*ItemHeight,331,ItemHeight+(cursel-pos)*ItemHeight);

 for (f=1;f<20;f++)
  {
  if (f+pos<=files)
   {
   sprintf(res,"%s\n",list+40*(f+pos));
   XDrawImageString(display,window,gc,ItemHeight,ItemHeight+f*ItemHeight,res,strlen(res)-1);
   }
  }
 XNextEvent(display,&event);
 if (event.type==ButtonPress && event.xbutton.x>335 && event.xbutton.y<43) pos--;
 if (event.type==ButtonPress && event.xbutton.x>335 && event.xbutton.y>216) pos++;
 if (event.type==ButtonPress && event.xbutton.x>335 && event.xbutton.y<216 && event.xbutton.y>43) pos=(event.xbutton.y-44)*files/175;
 if (event.type==MotionNotify && event.xbutton.x<300 && event.xbutton.y>12)
  {
  cursel=((event.xbutton.y)/ItemHeight)+pos;
  }
 if (
  (event.type==ButtonPress && event.xbutton.x<300 && event.xbutton.y>12)
  ||
  (event.type==KeyPress && (char) XLookupKeysym(&(event.xkey),event.xkey.state)==13)
   )
  {
  if (event.type==ButtonPress)
   {
   cursel=((event.xbutton.y)/ItemHeight)+pos;
   }
  f=cursel;
  if (f<1) f=1;
  if (f>files) f=files;
  sprintf(res,"%s",list+40*f);
  retcode=chdir(res);
  if (retcode)
   {
   break;
   }
  else
   {
/*
   printf("%s\n",get_current_dir_name());
*/
   dir=opendir(".");
   files=0;
   pos=0;
   while (1)
    {
    dirent=readdir(dir);
    if (dirent==NULL) break;
    files++;
    if (strlen(dirent->d_name)>39)
     {
     strcpy(list+40*files," < - entry too long - >");
     }
     else
     {
     strcpy(list+40*files,dirent->d_name);
     }
    if (files>=listlim-1)
     {
     listlim+=10;
     list=realloc(list,40*listlim);
     }
    }
   closedir(dir); 
   }/* end else */
  }
 if (pos>files-2) pos=files-2;
 if (pos<0) pos=0;
 if (event.type==KeyPress)
  {
  inchar=XLookupKeysym(&(event.xkey),event.xkey.state);
  printf ("pressed %i\n",inchar);
  if (inchar=='l' || inchar==84)
   {
   cursel++;
   } 
  if (inchar=='h' || inchar==82)
   {
   cursel--;
   } 
  if (cursel<1) cursel=1;
  if (cursel>files) cursel=files;
  if (pos<cursel-10) pos=cursel-10;
  if (pos>cursel-2) pos=cursel-2;
  if (pos<0) pos=0;
  }
}
free(list);
XFreeGC(display,gc);
XDestroyWindow(display,window);
XFlush(display);
return (res);
}


