#include <X11/Xlib.h>
#include "doc.h"
#include <stdio.h>

extern unsigned long(*ConvPixel) (int red,int green,int blue,int depth);

void CreateEmptyMask(DocObj *doc)
{
int f,scanline,size;
scanline=(doc->img.X+7)/8;
size=scanline*doc->img.Y;
doc->selmask=(char *) malloc(size);
if (doc->selmask==NULL)
 {
 printf ("unable to allocate memory for empty mask!!! \n");
 scanline=size=0;
 }
for (f=0;f<size;f++) *(doc->selmask+f)=0;
doc->maskactive=False;
}

void ClearMask(DocObj *doc)
{
int f,scanline,size;
scanline=(doc->img.X+7)/8;
size=scanline*doc->img.Y;
for (f=0;f<size;f++) *(doc->selmask+f)=0;
doc->maskactive=False;
}

Bool GetMaskPixel(DocObj *doc,int x,int y)
{
int f,scanline,bit;
char *address;
if (x>=doc->img.X || x<0 || y>=doc->img.Y || y<0) return False;
scanline=(doc->img.X+7)/8;
address=doc->selmask+y*scanline+x/8;
bit=x%8;
if ((*address) & (1<<bit)) return True;
return False;
} 

Bool UseMaskPixel(DocObj *doc,int x,int y)
{
if (!doc->maskactive) return True;
return GetMaskPixel(doc,x,y);
}

void LoadMaskOnShowPoint(DocObj *doc,int x,int y)
{
int zo=doc->zoomout;
unsigned long colordef;
int red,green,blue;
colordef=GetDocPixel(doc,x,y);
red=colordef&255;
green=(colordef>>8)&255;
blue=(colordef>>16)&255;
if (GetMaskPixel(doc,x,y)!=GetMaskPixel(doc,x+zo,y) ||
 GetMaskPixel(doc,x,y)!=GetMaskPixel(doc,x,y+zo)) green+=128;
DrawTemp(doc,x,y,red,green,blue);
}

LoadMaskOnShowPointAccurate(DocObj *doc,int x,int y)
{
int zo=doc->zoomout;
LoadMaskOnShowPoint(doc,x-zo,y);
LoadMaskOnShowPoint(doc,x,y-zo);
LoadMaskOnShowPoint(doc,x,y);
}

void SetMaskPixel(DocObj *doc,int x,int y,Bool state)
{
int f,scanline,bit;
char *address;
unsigned char byte;
if (x>=doc->img.X || x<0 || y>=doc->img.Y || y<0) return;
if (state) doc->maskactive=True;
scanline=(doc->img.X+7)/8;
address=doc->selmask+y*scanline+x/8;
bit=x%8;
byte=*address;
if (state)
 {
 *address=byte | (1<<bit);
 }
else
 {
 *address=byte & (unsigned char)~(1<<bit);
 }
LoadMaskOnShowPointAccurate(doc,x,y);
} 

void SetMaskPixelFast(DocObj *doc,int x,int y,Bool state)
{
int f,scanline,bit;
char *address;
unsigned char byte;
if (x>=doc->img.X || x<0 || y>=doc->img.Y || y<0) return;
if (state) doc->maskactive=True;
scanline=(doc->img.X+7)/8;
address=doc->selmask+y*scanline+x/8;
bit=x%8;
byte=*address;
if (state)
 {
 *address=byte | (1<<bit);
 }
else
 {
 *address=byte & (unsigned char)~(1<<bit);
 }
} 

void LoadMaskOnShowImage(DocObj *doc)
{
XEvent event;
int zi=doc->zoomin;
int zo=doc->zoomout;
int x,y,fvirx,fviry,xwrap,scanline,xl,yl;
char k;
char repstr[80];
MemImage im=doc->img;
unsigned char value,rv,gv,bv;
unsigned long pixel;
k=0;
scanline=(im.X*im.Bits+7)/8;
scanline*=im.Planes;

printf ("Start LoadMaskOnShowImage with scanline %i ",scanline);
printf ("win_h=%i,win_w=%i ",doc->win_h,doc->win_w);
printf ("im.X=%i,im.Y=%i ",im.X,im.Y);
printf ("zi=%i,zo=%i ",zi,zo);
printf ("fviry=%i,fvirx=%i ",FromVirY(doc,0),FromVirX(doc,0));
printf ("\n");


for (y=0;y<doc->win_h-zi && k!='q';y+=zi)
 {
 fviry=FromVirY(doc,y);
 if (XCheckMaskEvent(doc->display,KeyPressMask,&event)) k=XLookupKeysym(&(event.xkey),event.xkey.state);
 if (XCheckMaskEvent(doc->display,ButtonPressMask,&event))
  {
  k='q';
  XPutBackEvent(doc->display,&event); 
  }
 fvirx=FromVirX(doc,0);
 xwrap=1;
 for (x=0;x<doc->win_w;x+=zi)
  {
  if (im.Planes==3)
   {
   rv=*(im.data+fviry*scanline+fvirx*3);
   gv=*(im.data+fviry*scanline+fvirx*3+1);
   bv=*(im.data+fviry*scanline+fvirx*3+2);
   }
  else
   {
   rv=gv=bv=*(im.data+fviry*scanline+fvirx);
   }
  if (GetMaskPixel(doc,fvirx,fviry)!=GetMaskPixel(doc,fvirx+zo,fviry) ||
   GetMaskPixel(doc,fvirx,fviry)!=GetMaskPixel(doc,fvirx,fviry+zo)) gv+=128;
  if (zo>1)
   {
   fvirx+=zo;
   }
  else
   {
   xwrap+=zi;
   if (xwrap>=zo) 
    {
    fvirx+=zo;
    xwrap-=zo;
    }
   }
  PutPixelRect(doc,x,y,zi,zi,rv|(gv<<8)|(bv<<16));
/*
  pixel=ConvPixel(rv,gv,bv,doc->depth);
  for (xl=0;xl<zi;xl++)
  for (yl=0;yl<zi;yl++)
  XPutPixel(doc->image,x+xl,y+yl,pixel); 
*/
 /*
  SetDocVirPixel(doc,x,y,GetDocVirPixel(doc,x,y));
  */ 
  }
 if ((y & 31)==0)
  {
  sprintf(repstr,"Refreshed %i of %i scanlines, press q or click to abort",y,doc->win_h);
  ReportThat(repstr);
  ShowImage(doc);
  }
 }
if (k=='q') ReportThat ("refresh aborted"); else ReportThat("image refreshed");
printf ("leaving LoadMaskOnShowImage\n");
}

void LoadMaskOnShowDoc(DocObj *doc)
{
SetWindowSizes(doc);
LoadMaskOnShowImage(doc);
ShowImage(doc);
}

void UpdateMaskActive(DocObj *doc)
{
int f,scanline,size;
scanline=(doc->img.X+7)/8;
size=scanline*doc->img.Y;
doc->maskactive=False;
for (f=0;f<size;f++) if (*(doc->selmask+f)) doc->maskactive=True;
}

void SelectRectangle(DocObj *doc,int x,int y,int w,int h)
{
int f,g;
ReportThat("selecting rectangle please wait");
for (f=x;f<x+w;f++)
for (g=y;g<y+h;g++)
 {
 SetMaskPixelFast(doc,f,g,True);
 }
ReportThat("selecting done");
LoadMaskOnShowImage(doc);
}

void SelectMagic(DocObj *doc,int x,int y,int maxdiff)
{
SetMaskPixel(doc,x,y,True);
if (!GetMaskPixel(doc,x+1,y) && x<doc->img.X-1 && ColDiff(GetDocPixel(doc,x,y),GetDocPixel(doc,x+1,y))<maxdiff) SelectMagic(doc,x+1,y,maxdiff);
if (!GetMaskPixel(doc,x-1,y) && x>0 && ColDiff(GetDocPixel(doc,x,y),GetDocPixel(doc,x-1,y))<maxdiff) SelectMagic(doc,x-1,y,maxdiff);
if (!GetMaskPixel(doc,x,y+1) && y<doc->img.Y-1 && ColDiff(GetDocPixel(doc,x,y),GetDocPixel(doc,x,y+1))<maxdiff) SelectMagic(doc,x,y+1,maxdiff);
if (!GetMaskPixel(doc,x,y-1) && y>0 && ColDiff(GetDocPixel(doc,x,y),GetDocPixel(doc,x,y-1))<maxdiff) SelectMagic(doc,x,y-1,maxdiff);
}

void SelectMagicImage(DocObj *doc,int x,int y)
{
ReportThat("magic select in progress please wait");
SelectMagic(doc,x,y,10);
ReportThat("magic select done");
/*
LoadMaskOnShowImage(doc);
*/
}

void ClipShowMask(DocObj *doc)
{
/* This function is for test only and should not be used */
int scanline=(doc->img.X+7)/8;
Pixmap pixmap;
pixmap=XCreateBitmapFromData(doc->display,doc->window,doc->selmask,8*scanline,doc->img.Y);
ClearMask(doc);
XSetClipMask(doc->display,doc->gc,pixmap);
XFreePixmap(doc->display,pixmap);
}

void SetWindowBackMask(DocObj *doc)
{
/* This function is for test only and should not be used */
/* it works with 1-bit displays only                     */
int scanline=(doc->img.X+7)/8;
Pixmap pixmap;
pixmap=XCreateBitmapFromData(doc->display,doc->window,doc->selmask,8*scanline,doc->img.Y);
ClearMask(doc);
XSetWindowBackgroundPixmap(doc->display,RootWindow(doc->display,doc->screen),pixmap);
XFreePixmap(doc->display,pixmap);
}

void DrawLineOnSelMask(DocObj *doc)
{
/* This function is for test only and should not be used */
int scanline=(doc->img.X+7)/8;
GC gc;
int x,y;
XImage *image;
Pixmap pixmap;
pixmap=XCreateBitmapFromData(doc->display,doc->window,doc->selmask,8*scanline,doc->img.Y);
gc=XCreateGC(doc->display,pixmap,0,0);
printf ("pixmap created now to draw a line on it\n");
XSetForeground(doc->display,gc,1);
XDrawLine(doc->display,pixmap,gc,0,0,scanline*8,doc->img.Y);
printf ("line drawn\n");
image=XGetImage(doc->display,pixmap,0,0,8*scanline,doc->img.Y,1,ZPixmap);
XFreePixmap(doc->display,pixmap);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
 {
 if (XGetPixel(image,x,y))
  {
  SetMaskPixel(doc,x,y,1);
  }
 }
XDestroyImage(image);
XFreeGC(doc->display,gc);
}

void DrawTextOnSelMask(DocObj *doc,int xp,int yp,char *text)
{
int scanline=(doc->img.X+7)/8;
GC gc;
int x,y;
XImage *image;
Pixmap pixmap;
char xfontname[256];
FILE *pipe;
Font font;
pipe=popen("xfontsel -print","r");
fscanf(pipe,"%s",xfontname);
pclose(pipe);
font=XLoadFont(doc->display,xfontname);
pixmap=XCreateBitmapFromData(doc->display,doc->window,doc->selmask,8*scanline,doc->img.Y);
gc=XCreateGC(doc->display,pixmap,0,0);
printf ("pixmap created now to draw a text on it\n");
XSetForeground(doc->display,gc,1);
XSetFillStyle(doc->display,gc,FillSolid);
XSetBackground(doc->display,gc,0);
XSetFont(doc->display,gc,font);
XDrawString(doc->display,pixmap,gc,xp,10+yp,text,strlen(text));
printf ("text drawn\n");
/*
XDrawLine(doc->display,pixmap,gc,0,0,10,10);
*/
XUnloadFont(doc->display,font);
image=XGetImage(doc->display,pixmap,0,0,8*scanline,doc->img.Y,1,ZPixmap);
XFreePixmap(doc->display,pixmap);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
 {
 if (XGetPixel(image,x,y))
  {
  SetMaskPixel(doc,x,y,1);
  }
 }
XDestroyImage(image);
XFreeGC(doc->display,gc);
}

void DrawPolyOnSelMask(DocObj *doc,int count,int *Xp,int *Yp)
{
int scanline=(doc->img.X+7)/8;
GC gc;
int x,y,f;
XImage *image;
XPoint *points;
Pixmap pixmap;
points=(XPoint*)malloc(count*sizeof(XPoint));
if (points==NULL)
 {
 printf ("not enough memory for points");
 return;
 }
for (f=0;f<count;f++)
 {
 points[f].x=FromVirX(doc,Xp[f]);
 points[f].y=FromVirY(doc,Yp[f]);
 }
pixmap=XCreateBitmapFromData(doc->display,doc->window,doc->selmask,8*scanline,doc->img.Y);
gc=XCreateGC(doc->display,pixmap,0,0);
printf ("pixmap created now to draw a line on it\n");
XSetForeground(doc->display,gc,1);
XFillPolygon(doc->display,pixmap,gc,points,count,Complex,CoordModeOrigin);
printf ("line drawn\n");
image=XGetImage(doc->display,pixmap,0,0,8*scanline,doc->img.Y,1,ZPixmap);
XFreePixmap(doc->display,pixmap);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
 {
 if (XGetPixel(image,x,y))
  {
  SetMaskPixel(doc,x,y,1);
  }
 }
XDestroyImage(image);
XFreeGC(doc->display,gc);
free(points);
}

void ExpandSelMask(DocObj *doc)
{
int scanline=(doc->img.X+7)/8;
GC gc;
int x,y,f;
XImage *image;
Pixmap pixmap;
ReportThat("expanding selection");
pixmap=XCreateBitmapFromData(doc->display,doc->window,doc->selmask,8*scanline,doc->img.Y);
gc=XCreateGC(doc->display,pixmap,0,0);
XSetForeground(doc->display,gc,1);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
if (GetMaskPixel(doc,x,y))
 {
 XDrawPoint(doc->display,pixmap,gc,x,y);
 XDrawPoint(doc->display,pixmap,gc,x+1,y);
 XDrawPoint(doc->display,pixmap,gc,x-1,y);
 XDrawPoint(doc->display,pixmap,gc,x,y-1);
 XDrawPoint(doc->display,pixmap,gc,x,y+1);
 }
image=XGetImage(doc->display,pixmap,0,0,8*scanline,doc->img.Y,1,ZPixmap);
XFreePixmap(doc->display,pixmap);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
 {
 if (XGetPixel(image,x,y))
  {
  SetMaskPixel(doc,x,y,1);
  }
 }
XDestroyImage(image);
XFreeGC(doc->display,gc);
}

void ReduceSelMask(DocObj *doc)
{
int scanline=(doc->img.X+7)/8;
GC gc;
int x,y,f;
XImage *image;
Pixmap pixmap;
ReportThat("reducing selection");
pixmap=XCreateBitmapFromData(doc->display,doc->window,doc->selmask,8*scanline,doc->img.Y);
gc=XCreateGC(doc->display,pixmap,0,0);
XSetForeground(doc->display,gc,0);
XFillRectangle(doc->display,pixmap,gc,0,0,8*scanline,doc->img.Y);
XSetForeground(doc->display,gc,1);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
if (GetMaskPixel(doc,x,y) && GetMaskPixel(doc,x+1,y) && GetMaskPixel(doc,x-1,y) && GetMaskPixel(doc,x,y+1) && GetMaskPixel(doc,x,y-1))
 {
 XDrawPoint(doc->display,pixmap,gc,x,y);
 }
image=XGetImage(doc->display,pixmap,0,0,8*scanline,doc->img.Y,1,ZPixmap);
XFreePixmap(doc->display,pixmap);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
 {
 SetMaskPixel(doc,x,y,XGetPixel(image,x,y));
 }
XDestroyImage(image);
XFreeGC(doc->display,gc);
}

void InvertSelMask(DocObj *doc)
{
int scanline=(doc->img.X+7)/8;
GC gc;
int x,y,f;
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
 {
 SetMaskPixel(doc,x,y,!GetMaskPixel(doc,x,y));
 }
}


void MoveSelMask(DocObj *doc,int xd,int yd)
{
int scanline=(doc->img.X+7)/8;
GC gc;
int x,y,f;
XImage *image;
Pixmap pixmap;
ReportThat("moving selection");
setwaitcurs(doc->display,doc->window,doc->screen,doc->cmap);
pixmap=XCreateBitmapFromData(doc->display,doc->window,doc->selmask,8*scanline,doc->img.Y);
gc=XCreateGC(doc->display,pixmap,0,0);
XSetForeground(doc->display,gc,0);
XFillRectangle(doc->display,pixmap,gc,0,0,8*scanline,doc->img.Y);
XSetForeground(doc->display,gc,1);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
if (GetMaskPixel(doc,x,y))
 {
 XDrawPoint(doc->display,pixmap,gc,x+xd,y+yd);
 }
image=XGetImage(doc->display,pixmap,0,0,8*scanline,doc->img.Y,1,ZPixmap);
XFreePixmap(doc->display,pixmap);
for (y=0;y<doc->img.Y;y++)
for (x=0;x<8*scanline;x++)
 {
 SetMaskPixelFast(doc,x,y,XGetPixel(image,x,y));
 }
XDestroyImage(image);
XFreeGC(doc->display,gc);
ReportThat("selection moved");
setnormalcurs(doc->display,doc->window);
LoadMaskOnShowImage(doc);
}

void CopySelMask(DocObj *doc,int xd,int yd)
{
int scanline=(doc->img.X+7)/8;
int x,y,f;
f=(yd>0 || (yd==0 && xd>0));

ReportThat("copying data");
setwaitcurs(doc->display,doc->window,doc->screen,doc->cmap);
if (!f)
 {
 for (y=0;y<doc->img.Y;y++)
 for (x=0;x<8*scanline;x++)
  {
  if (GetMaskPixel(doc,x,y)) SetDocPixelColor(doc,x+xd,y+yd,GetDocPixel(doc,x,y));
  }
 }
else
 {
 for (y=doc->img.Y;y>0;y--)
 for (x=8*scanline;x>0;x--)
  {
  if (GetMaskPixel(doc,x,y)) SetDocPixelColor(doc,x+xd,y+yd,GetDocPixel(doc,x,y));
  }
 }
setnormalcurs(doc->display,doc->window);
ReportThat("data copied");
MoveSelMask(doc,xd,yd);
}

void PasteSelMask(DocObj *srcdoc,DocObj *dstdoc,int xd,int yd,Bool ForReal)
{
int scanline=srcdoc->img.X;
int x,y,f;
unsigned long Color;

ReportThat("pasting data");
printf("pasting data\n");
setwaitcurs(dstdoc->display,dstdoc->window,dstdoc->screen,dstdoc->cmap);
printf("set cursor\n");
for (y=0;y<srcdoc->img.Y;y++)
for (x=0;x<scanline;x++)
 {
 if (UseMaskPixel(dstdoc,x+xd,y+yd) && UseMaskPixel(srcdoc,x,y))
  {
  if (ForReal)
   {
   SetDocPixelColor(dstdoc,x+xd,y+yd,GetDocPixel(srcdoc,x,y));
   }
  else
   {
   Color=GetDocPixel(srcdoc,x,y);
   DrawTemp(dstdoc,x+xd,y+yd,Color&255,(Color>>8)&255,(Color>>16)&255);
   }
  }
 }
setnormalcurs(dstdoc->display,dstdoc->window);
ReportThat("data pasted");
printf("data pasted\n");
}

void UnPasteSelMask(DocObj *srcdoc,DocObj *dstdoc,int xd,int yd)
{
int scanline=srcdoc->img.X;
int x,y,f;
unsigned long Color;

ReportThat("unpasting data");
printf("unpasting data\n");
setwaitcurs(dstdoc->display,dstdoc->window,dstdoc->screen,dstdoc->cmap);
for (y=0;y<srcdoc->img.Y;y++)
for (x=0;x<scanline;x++)
 {
 if (UseMaskPixel(dstdoc,x+xd,y+yd) && UseMaskPixel(srcdoc,x,y))
  {
  Color=GetDocPixel(dstdoc,x+xd,y+yd);
  DrawTemp(dstdoc,x+xd,y+yd,Color&255,(Color>>8)&255,(Color>>16)&255);
  }
 }
setnormalcurs(dstdoc->display,dstdoc->window);
ReportThat("data unpasted");
printf ("data unpasted\n");
}


