#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "modes.h"

extern int mode;
extern int oldmode;

static Window window;
static int depth;
static Pixmap pixmap;
static GC pixgc;

void ShowModeButton(Display *display,int screen)
{
int f;
for (f=0;f<MAXMODE;f++)
 {
 if (f==mode)
  {
  XSetForeground(display,pixgc,BlackPixel(display,screen));
  XDrawLine(display,pixmap,pixgc,29,f*32+2,29,f*32+29);
  XDrawLine(display,pixmap,pixgc,2,f*32+2,29,f*32+2);
  XDrawLine(display,pixmap,pixgc,2,f*32+29,29,f*32+29);
  XDrawLine(display,pixmap,pixgc,2,f*32+2,2,f*32+29);
  XSetForeground(display,pixgc,WhitePixel(display,screen));
  }
 else
  {
  XSetForeground(display,pixgc,WhitePixel(display,screen));
  XDrawLine(display,pixmap,pixgc,29,f*32+2,29,f*32+29);
  XDrawLine(display,pixmap,pixgc,2,f*32+2,29,f*32+2);
  XDrawLine(display,pixmap,pixgc,2,f*32+29,29,f*32+29);
  XDrawLine(display,pixmap,pixgc,2,f*32+2,2,f*32+29);
  XSetForeground(display,pixgc,BlackPixel(display,screen));
  }
 }
/*
XSetWindowBackgroundPixmap(display,window,pixmap);
*/
XClearWindow(display,window);
}

Window CreateSelBar(Display *display,int screen)
{
Atom kill_atom;
XWMHints wmhints;
XSizeHints hints;
XSetWindowAttributes attr;
int f;
hints.flags=USPosition | PMinSize | PMaxSize;
hints.min_width=hints.max_width=32;
hints.min_height=hints.max_height=32*MAXMODE;
depth=DisplayPlanes(display,screen);
window=XCreateWindow(display,RootWindow(display,screen),
740,32,
hints.max_width,
hints.max_height,
0,depth,InputOutput,XDefaultVisual(display,screen),
0,&attr);
XSetStandardProperties(display,window,"Select","selection bar iconified",None,
0,0,&hints);
kill_atom=XInternAtom(display,"WM_DELETE_WINDOW",False);
XSetWMProtocols(display,window,&kill_atom,1);
wmhints.input=True;
wmhints.initial_state=NormalState;
wmhints.flags=InputHint | StateHint;
XSetWMHints(display,window,&wmhints);
pixmap=XCreatePixmap(display,window,32,32*MAXMODE,depth);
pixgc=XCreateGC(display,pixmap,0,0);
XSetBackground(display,pixgc,WhitePixel(display,screen));
for (f=0;f<MAXMODE;f++)
 {
 XSetForeground(display,pixgc,BlackPixel(display,screen));
 XFillRectangle(display,pixmap,pixgc,0,32*f,32,32);
 XSetForeground(display,pixgc,WhitePixel(display,screen));
 XFillRectangle(display,pixmap,pixgc,1,32*f+1,30,30);
 }
XSetForeground(display,pixgc,BlackPixel(display,screen));

/*******************DRAW TOOLS******************************/

XDrawLine(display,pixmap,pixgc,8,16,24,16);

XDrawString(display,pixmap,pixgc,2,48,"Draw",4);

XDrawString(display,pixmap,pixgc,3,77,"Pick",4);
XDrawString(display,pixmap,pixgc,3,89,"Fore",4);

XDrawRectangle(display,pixmap,pixgc,15,104,2,2);

XDrawRectangle(display,pixmap,pixgc,4,136,24,16);

XDrawLine(display,pixmap,pixgc,7,186,15,176);
XDrawLine(display,pixmap,pixgc,5,183,13,174);
XDrawLine(display,pixmap,pixgc,18,175,24,175);
XDrawLine(display,pixmap,pixgc,14,171,14,165);
XDrawLine(display,pixmap,pixgc,14,178,14,185);
XDrawLine(display,pixmap,pixgc,16,177,20,181);
XDrawLine(display,pixmap,pixgc,16,173,20,169);
XDrawLine(display,pixmap,pixgc,12,173,6,169);

XDrawLine(display,pixmap,pixgc,12,200,6,202);
XDrawLine(display,pixmap,pixgc,6,202,8,209);
XDrawLine(display,pixmap,pixgc,8,209,16,215);
XDrawLine(display,pixmap,pixgc,16,215,24,208);
XDrawLine(display,pixmap,pixgc,24,208,20,201);
XDrawLine(display,pixmap,pixgc,20,201,12,200);

XDrawString(display,pixmap,pixgc,3,238,"Grad",4);
XDrawString(display,pixmap,pixgc,3,250,"Circ",4);

XDrawString(display,pixmap,pixgc,3,270,"Pick",4);
XDrawString(display,pixmap,pixgc,3,282,"Back",4);

XDrawString(display,pixmap,pixgc,3,302,"Grad",4);
XDrawString(display,pixmap,pixgc,3,314,"Line",4);

XDrawString(display,pixmap,pixgc,3,346,"Crop",4);
XDrawRectangle(display,pixmap,pixgc,4,324,20,12);
XDrawRectangle(display,pixmap,pixgc,8,326,13,7);

XDrawString(display,pixmap,pixgc,3,376,"Text",4);

XDrawLine(display,pixmap,pixgc,3,400,28,400);
XDrawLine(display,pixmap,pixgc,3,400,5,402);
XDrawLine(display,pixmap,pixgc,3,400,5,398);
XDrawLine(display,pixmap,pixgc,26,402,28,400);
XDrawLine(display,pixmap,pixgc,26,398,28,400);
XDrawLine(display,pixmap,pixgc,15,390,15,410);
XDrawLine(display,pixmap,pixgc,13,392,15,390);
XDrawLine(display,pixmap,pixgc,17,392,15,390);
XDrawLine(display,pixmap,pixgc,13,408,15,410);
XDrawLine(display,pixmap,pixgc,17,408,15,410);

XDrawLine(display,pixmap,pixgc,3,429,28,429);
XDrawLine(display,pixmap,pixgc,3,431,28,431);
XDrawLine(display,pixmap,pixgc,3,430,5,432);
XDrawLine(display,pixmap,pixgc,3,430,5,428);
XDrawLine(display,pixmap,pixgc,26,432,28,430);
XDrawLine(display,pixmap,pixgc,26,428,28,430);
XDrawLine(display,pixmap,pixgc,16,420,16,440);
XDrawLine(display,pixmap,pixgc,14,420,14,440);
XDrawLine(display,pixmap,pixgc,13,422,15,420);
XDrawLine(display,pixmap,pixgc,17,422,15,420);
XDrawLine(display,pixmap,pixgc,13,438,15,440);
XDrawLine(display,pixmap,pixgc,17,438,15,440);

XDrawLine(display,pixmap,pixgc,3,470,28,470);
XDrawLine(display,pixmap,pixgc,28,465,28,470);
XDrawLine(display,pixmap,pixgc,28,465,30,467);
XDrawLine(display,pixmap,pixgc,28,465,26,467);
XDrawString(display,pixmap,pixgc,3,466,"Rot",3);

XDrawString(display,pixmap,pixgc,3,500,"Paste",5);

XDrawString(display,pixmap,pixgc,5,532,"Scrl",4);

/*****************END DRAW TOOLS****************************/

XSetWindowBackgroundPixmap(display,window,pixmap);
XClearWindow(display,window);

ShowModeButton(display,screen);

XSelectInput(display,window, ExposureMask | ButtonPressMask);
XMapWindow(display,window);
return window;
}  

int HandleSelBar(Display *display,int screen,XEvent *event)
{
int f;
if (event->type==ClientMessage && event->xany.window==window)
 {
 return 1;
 }
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==window)
 {
 oldmode=mode;
 mode=event->xbutton.y/32;
 ReportMode(mode);
 ShowModeButton(display,screen);
 if (mode==0) return 2;
 }
return 0;
}

void ShowSelBar(Display *display,int screen)
{
XMapRaised(display,window);
}

