#define IRQ_NUM 12
#define IO_PORT 0x100
#define MAJOR_NUM 21

#include <linux/version.h>
#include <linux/major.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/tty.h>
#include <linux/signal.h>
#include <linux/errno.h>
#include <linux/mm.h>

#include <asm/io.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <asm/irq.h>

char kernel_version[]= UTS_RELEASE;


static int avdata=0;

static unsigned char scandata[4096];

static struct wait_queue *wait_queue=NULL;



static void inline port_out(char value, unsigned short port)
{
__asm__ volatile ("outb %0,%1"
		::"a" ((char) value),"d" ((unsigned short) port));
}


static unsigned char inline port_in(unsigned short port)
{
	unsigned char _v;
__asm__ volatile ("inb %1,%0"
		:"=a" (_v):"d" ((unsigned short) port));
	return _v;
}

void portinit(int port)
{
int x;
x=1;
/*
x=ioperm (port,1,1);
*/
}

void outportb (int gate,int byte)
{
port_out (byte,gate);
}

int inportb (int gate)
{
return port_in(gate);
}


static int io_port=IO_PORT;
static int scan_irq=IRQ_NUM;

void interhandler (int irq, void *dev_id,struct pt_regs *regs)
{
int f,d;
unsigned char buffer[256];
disable_irq(scan_irq);
d=inportb(io_port+2);
for (f=0;f<4096;f++) scandata[f]=port_in(io_port);
d=inportb(io_port+3);
avdata=4096;
wake_up_interruptible(&wait_queue);
enable_irq(scan_irq);
}

void (*inthandler) (int irq,void *dev_id,struct pt_regs *regs)=&interhandler;

void setinthandle(void)
{
int retv;
retv=request_irq(scan_irq,interhandler,0,"scanner",NULL);
printk ("setting irq returns %i\n",retv);
}

void init_scanner_ports(void)
{
portinit(io_port);
portinit(io_port+1);
portinit(io_port+2);
portinit(io_port+3);
}

void turn_scanner_on(void)
{
outportb(io_port,0);
outportb(io_port+1,0);
outportb(io_port+2,128+32+16+4+2 /* 10110110 */);
}

void turn_scanner_off(void)
{
outportb(io_port+2,0*128+32+0*16+4+2 /* 10110110 */);
}

void start_scanner(void)
{
int f,x;
init_scanner_ports();
turn_scanner_on();
/*
disable_irq(scan_irq);
*/
enable_irq(scan_irq);
}

void stop_scanner(void)
{
turn_scanner_off();
}

static int scan_read(struct inode * inode , struct file *file,char *buffer,int count)
{
int offset;
if (count<=0) return -EINVAL;
if (avdata==0) interruptible_sleep_on(&wait_queue);
for (offset=0;offset<count;offset++)
 {
 put_fs_byte (scandata[offset%4096],buffer+offset);
 }
avdata=0;
return offset;
}

static int scan_open(struct inode *inode,struct file *file)
{
printk("scan open\n");
start_scanner();
return 0;
}

static void scan_release(struct inode *inode,struct file *file)
{
stop_scanner();
printk("scan release\n");
}

static struct file_operations scan_fops=
{ 
 NULL,		/* seek  */
 scan_read,	/* read   */
 NULL,		/* write  */
 NULL,		/* readdir */ 
 NULL,		/* select  */ 
 NULL,		/* ioctl */ 
 NULL,		/* mmap */ 
 scan_open,	/* open */
 scan_release,	/* release */
 };

int init_module(void)
{
if (register_chrdev(MAJOR_NUM,"scan",&scan_fops)) 
 {
 printk("unable to register major %i\n",MAJOR_NUM);
 }
else
 {
 printk("registered major %i\n",MAJOR_NUM);
 }
/*
start_scanner();
*/
setinthandle();
return 0;
}

void cleanup_module(void)
{
unregister_chrdev(MAJOR_NUM,"scan");
printk("removing major %i\n",MAJOR_NUM);
disable_irq(scan_irq);
free_irq(scan_irq,NULL);
stop_scanner();
}

unsigned long scan_init (unsigned long kmem_start)
{
printk("starting driver\n");
return kmem_start;
}
