#include <stdio.h>
#include <X11/Xlib.h>
#include <math.h>
#include <X11/Xutil.h>
#include "globals.h"
#include "modes.h"

extern unsigned long(*ConvPixel) (int red,int green,int blue,int depth);

extern int mode;
static Window window;
static int depth;
static Pixmap pixmap;
static GC pixgc;
static unsigned char hue,br,sat;
static int red,green,blue;

unsigned long ColFromHue(int f)
{
red=256+256*cos((float)f*M_PI/128);
green=256+256*cos((float)(f+85)*M_PI/128);
blue=256+256*cos((float)(f+171)*M_PI/128);
if (red<128) red=128;
if (green<128) green=128;
if (blue<128) blue=128;
red-=128;
green-=128;
blue-=128;
if (red>255) red=255;
if (green>255) green=255;
if (blue>255) blue=255;
return ConvPixel((int)red,(int) green,(int) blue,depth);
}

void UpdateColorWindow(Display *display,int screen)
{
int x,y,f;
int rl,gl,bl;
unsigned long pixel;
XSetForeground(display,pixgc,WhitePixel(display,screen));
XFillRectangle(display,pixmap,pixgc,0,0,148,148);

for (f=0;f<128;f+=4)
 {
 pixel=ColFromHue(f*2);
 XSetForeground(display,pixgc,pixel);
 XFillRectangle(display,pixmap,pixgc,136,f,8,4);
 }
XSetForeground(display,pixgc,BlackPixel(display,screen));
XFillRectangle(display,pixmap,pixgc,128,hue>>1,8,2);
pixel=ColFromHue(hue);
for (x=0;x<127;x+=8)
for (y=0;y<127;y+=8)
 {
 rl=255-(((255-red)*y)>>7);
 rl=(rl*x)>>7;
 gl=255-(((255-green)*y)>>7);
 gl=(gl*x)>>7;
 bl=255-(((255-blue)*y)>>7);
 bl=(bl*x)>>7;
 XSetForeground(display,pixgc,ConvPixel(rl,gl,bl,depth));
 XFillRectangle(display,pixmap,pixgc,x,y,8,8);
 }
XSetForeground(display,pixgc,ConvLongPixel(ForeCol,depth));
XFillRectangle(display,pixmap,pixgc,0,128,20,20);
XSetForeground(display,pixgc,ConvLongPixel(BackCol,depth));
XFillRectangle(display,pixmap,pixgc,64,128,20,20);
XSetForeground(display,pixgc,BlackPixel(display,screen));
XDrawLine (display,pixmap,pixgc,br>>1,(sat>>1)-4,br>>1,(sat>>1)+4);
XDrawLine (display,pixmap,pixgc,(br>>1)-4,sat>>1,(br>>1)+4,sat>>1);
XClearWindow(display,window);
}

unsigned long ColorFromHSB(int hue,int y,int x)
{
unsigned long pixel;
int rl,gl,bl;
pixel=ColFromHue(hue);
rl=255-(((255-red)*y)>>8);
rl=((rl*x)&0xff00)>>8;
gl=255-(((255-green)*y)>>8);
gl=((gl*x)&0xff00);
bl=255-(((255-blue)*y)>>8);
bl=((bl*x)&0xff00)<<8;
/*
XSetForeground(display,pixgc,ConvPixel((int)rl,(int)gl,(int)bl,depth);
XFillRectangle (display,pixmap,pixgc,50,128,40,10);
XClearWindow(display,window);
*/
return (rl|gl|bl);
}

Window CreateColorWindow(Display *display,int screen)
{
XGCValues GCVal;
XFontStruct *FontStr;
Atom kill_atom;
XWMHints wmhints;
XSizeHints hints;
XSetWindowAttributes attr;
int f,x,y;
hints.flags=USPosition | PMinSize | PMaxSize;
hints.min_width=hints.max_width=148;
hints.min_height=hints.max_height=148;
depth=DisplayPlanes(display,screen);
window=XCreateWindow(display,RootWindow(display,screen),
580,350,
hints.max_width,
hints.max_height,
0,depth,InputOutput,XDefaultVisual(display,screen),
0,&attr);
XSetStandardProperties(display,window,"color","color select iconified",None,
0,0,&hints);
kill_atom=XInternAtom(display,"WM_DELETE_WINDOW",False);
XSetWMProtocols(display,window,&kill_atom,1);
wmhints.input=True;
wmhints.initial_state=NormalState;
wmhints.flags=InputHint | StateHint;
XSetWMHints(display,window,&wmhints);
pixmap=XCreatePixmap(display,window,148,148,depth);
pixgc=XCreateGC(display,pixmap,0,0);
XSetBackground(display,pixgc,WhitePixel(display,screen));
XSetForeground(display,pixgc,WhitePixel(display,screen));
XFillRectangle(display,pixmap,pixgc,0,0,128,128);
XSetForeground(display,pixgc,BlackPixel(display,screen));

/*******************DRAW WINDOW******************************/
UpdateBrushDisplay(display,screen);
/*****************END DRAW WINDOW***************************/

XSetWindowBackgroundPixmap(display,window,pixmap);
XClearWindow(display,window);

XSelectInput(display,window, ExposureMask | ButtonPressMask);
XMapWindow(display,window);
return window;
}  

int HandleColorWindow(Display *display,int screen,XEvent *event)
{
int f,x,y,v;
if (event->type==ClientMessage && event->xany.window==window)
 {
 return 1;
 }
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==window)
 {
 printf ("selecting color & brush\n");
 x=event->xbutton.x;
 y=event->xbutton.y;
 if (x<128 && y<128)
  {
  br=x*2;
  sat=y*2;  
  if (mode==PICKBACKCOLMODE)
   {
   BackCol=ColorFromHSB(hue,sat,br);
   }
  else
   {
   ForeCol=ColorFromHSB(hue,sat,br);
   }
  }
 if (x>128 && x<148 && y<128)
  {
  hue=y*2;
  }
 UpdateBrushDisplay(display,screen); 
 }
return 0;
}

void ShowColorWindow(Display *display,int screen)
{
XMapRaised(display,window);
}

