#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "globals.h"

extern int mode;
static Window window;
static int depth;
static Pixmap pixmap;
static GC pixgc;

void UpdateBrushDisplay(Display *display,int screen)
{
XSetForeground(display,pixgc,ConvLongPixel(ForeCol,depth));
XFillRectangle(display,pixmap,pixgc,0,30,20,20);
XSetForeground(display,pixgc,ConvLongPixel(BackCol,depth));
XFillRectangle(display,pixmap,pixgc,0,80,20,20);
/*
XSetForeground(display,pixgc,WhitePixel(display,screen));
*/
XFillRectangle(display,pixmap,pixgc,41,116,63,9);
XSetForeground(display,pixgc,BlackPixel(display,screen));

XSetForeground(display,pixgc,ConvLongPixel(ForeCol,depth));

XFillRectangle(display,pixmap,pixgc,41,116,DotSize,2+DotSize/10);
XClearWindow(display,window);
UpdateColorWindow(display,screen);
}

Window CreateBrushWindow(Display *display,int screen)
{
unsigned long ret_val;
XGCValues GCVal;
XFontStruct *FontStr;
Atom kill_atom;
XWMHints wmhints;
XSizeHints hints;
XSetWindowAttributes attr;
int f;
hints.flags=USPosition | PMinSize | PMaxSize;
hints.min_width=hints.max_width=128;
hints.min_height=hints.max_height=128;
depth=DisplayPlanes(display,screen);
window=XCreateWindow(display,RootWindow(display,screen),
600,140,
hints.max_width,
hints.max_height,
0,depth,InputOutput,XDefaultVisual(display,screen),
0,&attr);
XSetStandardProperties(display,window,"brush","brush window iconified",None,
0,0,&hints);
kill_atom=XInternAtom(display,"WM_DELETE_WINDOW",False);
XSetWMProtocols(display,window,&kill_atom,1);
wmhints.input=True;
wmhints.initial_state=NormalState;
wmhints.flags=InputHint | StateHint;
XSetWMHints(display,window,&wmhints);
pixmap=XCreatePixmap(display,window,128,128,depth);
pixgc=XCreateGC(display,pixmap,0,0);
XSetBackground(display,pixgc,WhitePixel(display,screen));
XSetForeground(display,pixgc,WhitePixel(display,screen));
XFillRectangle(display,pixmap,pixgc,0,0,128,128);
XSetForeground(display,pixgc,BlackPixel(display,screen));
XDrawString (display,pixmap,pixgc,30,12,"Red",3);
XDrawString (display,pixmap,pixgc,56,12,"Green",5);
XDrawString (display,pixmap,pixgc,92,12,"Blue",4);

XDrawRectangle (display,pixmap,pixgc,30,20,90,32);
XDrawRectangle (display,pixmap,pixgc,30,70,90,32);
XDrawRectangle (display,pixmap,pixgc,40,116,64,8);

XDrawString (display,pixmap,pixgc,0,25,"Fore",4);
XDrawString (display,pixmap,pixgc,0,75,"Back",4);
XDrawString (display,pixmap,pixgc,0,125,"Brush",5);

XDrawLine (display,pixmap,pixgc,45,20,45,52);
XDrawLine (display,pixmap,pixgc,75,20,75,52);
XDrawLine (display,pixmap,pixgc,105,20,105,52);
XDrawLine (display,pixmap,pixgc,45,70,45,102);
XDrawLine (display,pixmap,pixgc,75,70,75,102);
XDrawLine (display,pixmap,pixgc,105,70,105,102);

/* bad font searching
*/
printf ("get gc vals\n");
printf ("status %i\n",XGetGCValues(display,pixgc,GCFont,&GCVal));
printf ("print\n");
printf ("font %i\n",GCVal.font);
FontStr=XQueryFont(display,XGContextFromGC(pixgc));
XGetFontProperty(FontStr,XA_POINT_SIZE,&ret_val);
printf ("descent is %i\n",(int)ret_val); 
/*
*/


/*******************DRAW WINDOW******************************/


/*****************END DRAW WINDOW***************************/

XSetWindowBackgroundPixmap(display,window,pixmap);
XClearWindow(display,window);

XSelectInput(display,window, ExposureMask | ButtonPressMask);
XMapWindow(display,window);
return window;
}  

int HandleBrushWindow(Display *display,int screen,XEvent *event)
{
int f,x,y,v;
if (event->type==ClientMessage && event->xany.window==window)
 {
 return 1;
 }
if (event->type==ButtonPress && event->xbutton.button==1 && event->xbutton.window==window)
 {
 printf ("selecting color & brush\n");
 x=event->xbutton.x;
 y=event->xbutton.y;
 if (x>30 && x<60 && y>20 && y<52)
  {
  v=(y-20)<<3;
  XSetForeground(display,pixgc,WhitePixel(display,screen));
  XFillRectangle(display,pixmap,pixgc,40,21,5,31);
  XSetForeground(display,pixgc,BlackPixel(display,screen));
  XDrawLine(display,pixmap,pixgc,40,y,44,y);
  ForeCol=ForeCol&(0xffff00)|v;
  }  
 if (x>60 && x<90 && y>20 && y<52)
  {
  v=(y-20)<<11;
  XSetForeground(display,pixgc,WhitePixel(display,screen));
  XFillRectangle(display,pixmap,pixgc,70,21,5,31);
  XSetForeground(display,pixgc,BlackPixel(display,screen));
  XDrawLine(display,pixmap,pixgc,70,y,74,y);
  ForeCol=ForeCol&(0xff00ff)|v;
  } 
 if (x>90 && x<120 && y>20 && y<52)
  {
  v=(y-20)<<19;
  XSetForeground(display,pixgc,WhitePixel(display,screen));
  XFillRectangle(display,pixmap,pixgc,100,21,5,31);
  XSetForeground(display,pixgc,BlackPixel(display,screen));
  XDrawLine(display,pixmap,pixgc,100,y,104,y);
  ForeCol=ForeCol&(0x00ffff)|v;
  } 
 if (x>30 && x<60 && y>70 && y<102)
  {
  v=(y-70)<<3;
  XSetForeground(display,pixgc,WhitePixel(display,screen));
  XFillRectangle(display,pixmap,pixgc,40,71,5,31);
  XSetForeground(display,pixgc,BlackPixel(display,screen));
  XDrawLine(display,pixmap,pixgc,40,y,44,y);
  BackCol=BackCol&(0xffff00)|v;
  }  
 if (x>60 && x<90 && y>70 && y<102)
  {
  v=(y-70)<<11;
  XSetForeground(display,pixgc,WhitePixel(display,screen));
  XFillRectangle(display,pixmap,pixgc,70,71,5,31);
  XSetForeground(display,pixgc,BlackPixel(display,screen));
  XDrawLine(display,pixmap,pixgc,70,y,74,y);
  BackCol=BackCol&(0xff00ff)|v;
  } 
 if (x>90 && x<120 && y>70 && y<102)
  {
  v=(y-70)<<19;
  XSetForeground(display,pixgc,WhitePixel(display,screen));
  XFillRectangle(display,pixmap,pixgc,100,71,5,31);
  XSetForeground(display,pixgc,BlackPixel(display,screen));
  XDrawLine(display,pixmap,pixgc,100,y,104,y);
  BackCol=BackCol&(0x00ffff)|v;
  } 

 if (x>40 && x<105 && y>115 && y<125) DotSize=x-40;

 UpdateBrushDisplay(display,screen);

}
return 0;
}

void ShowBrushWindow(Display *display,int screen)
{
XMapRaised(display,window);
}

