/*
 * Mystic Draw 1.4 : A nice ANSI Drawing tool
 * Copyright(C) 1996 by Mike Krueger (mkrueger@inf.fu-berlin.de)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include<unistd.h>
#include<ncurses.h>
#include<ctype.h>
#include<string.h>
#ifdef HAS_SVGALIB
#include<vga.h>
#endif
#include<stdlib.h>
#include"include/bio_crt.h"
#include <sys/types.h> 
#define MaxLines 1000
#define UNDOPage 0
#define COPYPage 3
unsigned char *Screen[4][MaxLines+1];
unsigned char tabs[80];
unsigned char CursorPos[80],cpos=1;
int CursorX=0,CursorY=0,FirstLine=0,x,y,LastLine=0;
unsigned char Attribute=7,FontMode=FALSE,Undo=FALSE,FontTyped=FALSE,InsertMode=FALSE,EliteMode=FALSE,SaveSauce=FALSE,ActiveCharset=1,ActivePage=1;
unsigned char FullScreen=FALSE,MouseSupport=TRUE;
unsigned short DrawMode=0;
char * stri[20];
char * CharSet[12]={
     "",
     "ڿĳô",
     "ɻȼͺ̹",
     "ոԾͳƵ",
     "ן雜",
     "",
     "𞀇",
     "",
     "",
     "",
     "",
     ""
};
typedef struct teffekt  {
   int Effekt;
   int Colortable[5][10];
} teffekt;
teffekt effect;
typedef struct {
   char id[6];
   char Version[2];
   char Title[36];
   char Author[21];
   char Group[21];
   char Date[9];
   long FileSize;
   char DataType;
   char FileType;
   short TInfo1,TInfo2,TInfo3,TInfo4;
   char Comments;
   char Flags;
   char Filler[23];
} SauceRecord;

char EliteTable[256];
#ifdef HAS_GPM
#include"include/mouse.h"
#endif
#include"include/key.h"
#include"include/ansis.h"
#include"include/crt.h"
#include"include/miscfunctions.h"
#include"include/fonts.h"
#include"include/help.h"
#include"include/effekt.h"
#include"include/config.h"
#include"include/options.h"
#include"include/tabulator.h"
#include"include/sauce.h"
#include"include/save.h"
#include"include/load.h"

void ShowScreen(int a1,int a2)
{
   unsigned char x,y,c,oldcol;
   move(a1,0);
   if (FullScreen==TRUE) move(0,0);
   for (y=a1-1;y<=a2-a1+(LINES-25);y++) {
      
     for (x=0;x<=79;x++) {
	if (Screen[ActivePage][y+FirstLine][(x<<1)+1]!=oldcol)
	  TextColor(Screen[ActivePage][y+FirstLine][(x<<1)+1]);
	oldcol=Screen[ActivePage][y+FirstLine][(x<<1)+1];
	c=Screen[ActivePage][y+FirstLine][x<<1];
	if (c>033)
	  writechar(c); else writechar(' ');
     }
      if (COLS>80) writechar('\n');
   }
   
}

void Statusline(void) {
   int a;
   unsigned char b;
   if (FullScreen==TRUE) return;
   TextColor(2);
   move(0,0);
   for (a=0;a<80;a++) writechar(32);
   move(0,0);
   write("(%02d,",CursorX);
   write("%04d) ",CursorY+FirstLine+1);
   move(0,18);
   TextColor(8);
   if (EliteMode&1==1) 
     write("e"); else write(" ");
   move(0,20);
   TextColor(14);
   if (InsertMode&1==1)
     write("Ins"); else write("   ");
   move(0,24);
   TextColor(2);
   write("Page:%d",ActivePage);
   TextColor(9);
   move(0,32);
   write("Set: %d",ActiveCharset);
   move(0,39);
   for (a=1;a<=10;a++){
      TextColor(64);
      write(" %d=",a);
      TextColor(64+15);
      b=CharSet[ActiveCharset][a-1];
      writechar(b);
   }
   TextColor(7);
   writechar(' ');
}

void CursorCheck(void) {   
   if (CursorY<0) {
      CursorY=0;
      FirstLine--;
   }
   if (FullScreen==TRUE) {       
      if (CursorY>LINES-1){
	 CursorY=LINES-1;
	 FirstLine++;
      } 
   }else
     if (CursorY>LINES-2){
	CursorY=LINES-2;
	FirstLine++;
     }
   if (FullScreen==TRUE) {
      if (FirstLine+LINES>MaxLines) FirstLine=MaxLines-LINES;
   } else if (FirstLine+LINES-1>MaxLines) FirstLine=MaxLines-LINES+1;
   if (FirstLine<0) FirstLine=0;
   if (CursorX<0) CursorX=0;
   if (CursorX>79) CursorX=79;
}

void CursorHandling(int ch) {
   #ifdef HAS_GPM
   if (MouseSupport==TRUE) {      
      mouse_update();
      CursorX+=mouse_deltax;
      CursorY+=mouse_deltay;
      mouse_deltax=0;
      mouse_deltay=0;
   }
   #endif
   switch(ch) {   
    case KEY_DOWN :
      CursorY++;
      break;
    case KEY_UP   :
      CursorY--;
      break;
    case KEY_LEFT  :
      CursorX--;
      break;
    case KEY_RIGHT:
      CursorX++;
      break;
    case KEY_NPAGE :
      FirstLine+=LINES-1;
      if (FullScreen==TRUE) CursorY=LINES-1; else CursorY=LINES-2;
      break;
    case KEY_PPAGE :
      FirstLine-=LINES-1;
      CursorY=0;
    case 275:             /* SHIFT + F1*/
      ActiveCharset=1;
      break;
    case 276:             /* SHIFT + F2*/
      ActiveCharset=2;
      break;
    case 277:             /* SHIFT + F3*/
      ActiveCharset=3;
      break;
    case 278:             /* SHIFT + F4*/
      ActiveCharset=4;
      break;
    case 279:             /* SHIFT + F5*/
      ActiveCharset=5;
      break;
    case 280:             /* SHIFT + F6*/
      ActiveCharset=6;
      break;
    case 281:             /* SHIFT + F7*/
      ActiveCharset=7;
      break;
    case 282:             /* SHIFT + F8*/
      ActiveCharset=8;
      break;
    case 283:             /* SHIFT + F9*/
      ActiveCharset=9;
      break;
    case 284:             /* SHIFT + F10*/
      ActiveCharset=10;
      break;
    case 262:  /* POS 1  */
      CursorX=0;
      break;
    case KEY_END: /* END */
      CursorX=79;
      break;
   }   
}

void WriteCharacter(unsigned char c) {
   int a;
   if (c<32) return;
   if (InsertMode==TRUE)
      for (a=159;a>=CursorX*2;a--)
      Screen[ActivePage][CursorY+FirstLine][a]=Screen[ActivePage][CursorY+FirstLine][a-2];
   Screen[ActivePage][CursorY+FirstLine][CursorX*2]=c;
   Screen[ActivePage][CursorY+FirstLine][CursorX*2+1]=Attribute;
   CursorX++;
   doupdate();
   if (CursorY+FirstLine+1>=LastLine) LastLine=CursorY+FirstLine+1;
}

void ClearWindow(void) {
   int x,y;
   for (y=5;y<=17;y++) {
      move(y,30);
      for (x=30;x<=60;x++) writechar(32);
   }
};

void ShowCharacter(int num) {
   unsigned char c;
   int a,b;
   Openfont(num);
   c=65;
   do {
      ReadFonts(c++);
   } while ((c<122)&&(MaxX==0));
   TextColor(7);
   ClearWindow();
   if (MaxX>60) MaxX=60;
   if (MaxY>24) MaxY=24;
   for (a=1;a<=MaxY;a++)
     for (b=1;b<=MaxX;b++) {
	switch (TDFont.FontType) {
	 case 0:
	 case 1:
	   move((13-MaxY)/2+a+4,(31-MaxX)/2+b+29);
	   if (Chars[b][a]>=32)
	     writechar(Chars[b][a]); else writechar(32);
	   break;
	 case 2:
	   move((13-MaxY)/2+a+4,(31-MaxX)/2+b+29);
	   TextColor(Chars[b*2-1][a]);
	   if (Chars[b*2][a]>=32)
	     writechar(Chars[b*2][a]); else writechar(32);
	   break;
	}
     }
};

int SelectFont(void) {
   char Fnts[2000][16];
   FILE * fp;
   long b;
   unsigned short a,x,y,z;
   int ch;
   char FontFile[255];
   sprintf(FontFile,"%s%s",getenv("HOME"),"/.mdraw/allfont.fnt");   
   DrawBox(9,5,26,17);
   DrawBox(29,4,61,18);
   fp=fopen(FontFile,"rb");
   fread(&Header.sign,1,10,fp);
   fread(&Header.NumberofFonts,2,1,fp);
   for (b=0;b<=Header.NumberofFonts;b++) {
      Openfont(b);
      memcpy(&Fnts[b+1],&FontRec.FontName,16);
   }
   fclose(fp);
   b=0;
   a=1;
   ShowCharacter(a+b-1);
   do {
      for (y=1;y<=11;y++)
	if (y<=Header.NumberofFonts) {
	   move(5+y,10);
	   if (y==a) TextColor(32+15); else TextColor(2);
	   for (x=1;x<=Fnts[y+b][0];x++)
	     writechar(Fnts[y+b][x]);
	   for (z=Fnts[y+b][0];z<16;z++)
	     writechar(32);
	}
      refresh();
      ch=newgetch();
      switch (ch) {
       case ERR:
	 break;
       case KEY_UP:
	 a--;
	 break;
       case KEY_DOWN:
	 a++;
	 break;
       case KEY_NPAGE :
	 a=11;
	 if (b+11<=Header.NumberofFonts) b+=11; else b=Header.NumberofFonts-11;
	 break;
       case KEY_PPAGE :
	 a=1;
	 if (b-11>=0) b-=11; else b=0;
	 break;
      }
      if (a<1) {
	 a=1;
	 b--;	 
      }
      if (a>Header.NumberofFonts) a=Header.NumberofFonts;
      if (a>11) {
	 a=11;
	 b++;
      }
      if (b<0) b=0;
      if ((b+11>Header.NumberofFonts)&(Header.NumberofFonts>11)) {
	 b=Header.NumberofFonts-11;
      }
      ShowCharacter(a+b-1);
   } while ((ch!=27)&(ch!=13));
   if (ch==13) {
      return (a+b-1);
   } else return 0;
}
void DrawFontCharakter(char c) {
   int a,b;
   ReadFonts(c);
   if ((CursorX+MaxX+TDFont.Spaces>80)|(MaxX==0)|(MaxY+FirstLine+CursorY>MaxLines))  {
      goto end;
   }
   FontTyped=TRUE;
   if (MaxY+CursorY>LINES-1) {
      FirstLine+=MaxY+CursorY-LINES+2;
      CursorY-=MaxY+CursorY-LINES+2;
   }
   for (a=1;a<=MaxX;a++)
     for (b=1;b<=MaxY;b++) {
	switch(TDFont.FontType) {
	 case 0:
	 case 1:
	   Screen[ActivePage][CursorY+FirstLine+b-1][(CursorX+a-1)*2]=Chars[a][b];
	   Screen[ActivePage][CursorY+FirstLine+b-1][(CursorX+a-1)*2+1]=Attribute;
	   break;
	 case 2:
	   Screen[ActivePage][CursorY+FirstLine+b-1][(CursorX+a-1)*2]=Chars[a*2][b];
	   Screen[ActivePage][CursorY+FirstLine+b-1][(CursorX+a-1)*2+1]=Chars[a*2-1][b];
	   break;
	}
     }
   cpos++;
   CursorPos[cpos]=MaxX+TDFont.Spaces;
   CursorX+=MaxX+TDFont.Spaces-1;
   if (MaxY+CursorY+FirstLine>LastLine) LastLine=MaxY+CursorY+FirstLine;
end: if (1==1) {}
}

#ifdef HAS_SVGALIB
 #include"include/viewmode.h"
#endif
#include"include/block.h"
#include"include/draw.h"

void setunderground(int Underg,int b){
   int x,y;
   for (x=1;x<=7;x++)
   for (y=1;y<6;y++) SelectAnsi[(4+x+(b%8)*9)*2+(3+y+(b/8)*6)*160+1]=Underg;
   move (0,0);
   for (x=0;x<2000;x++){
      TextColor(SelectAnsi[(x<<1)+1]);   
      if (SelectAnsi[x<<1]==0) SelectAnsi[x<<1]=32;
      writechar(SelectAnsi[x<<1]);
      if ((COLS>80)&&(((x+1)%80)==0)) writechar('\n');
   }
}

unsigned char asciitable() {
   int y,ch,x=32;
   DrawBox(29,4,46,20);
   do {
      move(5,30);
      TextColor(7);
      write("hex :%02x  dec:%03d",x,x);
      for (y=32;y<=255;y++) {
	 move(6+(y-32)/16,30+y%16);
	 TextColor(3);
	 if (y==x) TextColor(27);
	 if (y!=127) writechar(y); else writechar('.');
      }
      ch=newgetch();
#ifdef HAS_GPM
      if (MouseSupport==TRUE)  {
	 Gpm_DrawPointer(mouse_x+1,mouse_y+1,1);
	 if (mouse_button==MOUSE_RIGHTBUTTON) 
	   return 0;
	 if (mouse_x>29&&mouse_x<46&&
	     mouse_y>5&&mouse_y<20) {
		x=(mouse_x-30)+(mouse_y-4)*16;
		if (mouse_button==MOUSE_LEFTBUTTON) 
		  return x;
	     }
      }
#endif
      switch(ch){
       case KEY_LEFT:
	 if (x>32) x--; else x=255;
	 break;
       case KEY_RIGHT:
	 if (x<255) x++; else x=32;
	 break;
       case KEY_DOWN:	 
	 if (x<=239) x+=16;
	 break;
       case KEY_UP:
	 if (x>=48) x-=16;
	 break;
      }      
   } while (ch!=27&&ch!=13);
   if (ch==13&&x!=127) return x;
   return 0;
}


void SelectOutline() {
   int ch,x,y,b;
   b=Outline;
   do {
      setunderground(18,b);
      ch=newgetch();
      setunderground(2,b);
      if ((ch>='A')&(ch<='S')){
	 Outline=ch-'A';
	 ch=27;
      }	
      if ((ch>='a')&(ch<='s')){
	 Outline=ch-'a';
	 ch=27;
      }	
      switch(ch){
       case KEY_LEFT:
	 if (b>0) b--; else b=18;
	 break;
       case KEY_RIGHT:
	 if (b<18) b++; else b=0;
	 break;
       case KEY_DOWN:
	 if ((b<16)&(b<11)) b+=8;
	 break;
       case KEY_UP:
	 if (b>7) b-=8;
	 break;
       case 13:
	 Outline=b;
	 ch=27;
	 break;
      }      
   } while (ch!=27);
}

#include"include/menue.h"
void main(int argnum,char *args[]) {
   int a,b;
   for (a=0;a<4;a++)
     for (y=0;y<=MaxLines;y++)  
     Screen[a][y]=(unsigned char*)malloc(160);
   
   for (a=0;a<4;a++)
     for (y=0;y<=MaxLines;y++)  {
	for (x=0;x<80;x++) {
	   Screen[a][y][x<<1]=32;
	   Screen[a][y][(x<<1)+1]=7;
	}  
     }
   loadconfig();
   if (argnum>1) {
      printf("Loading file :%s\n",args[1]);
      LoadFile(args[1]);
   }
   init_bio_crt();
   #ifdef HAS_GPM
   if (mouse_init()!=0) 
     MouseSupport=FALSE;
   #endif
   refresh();   
   do {
      Statusline();
      if (FullScreen==TRUE) ShowScreen(1,25); else ShowScreen(1,24);
      Colors(Attribute);
      if (FullScreen==TRUE) move(CursorY+0,CursorX); else  move(CursorY+1,CursorX);
      /* *** */
      a=newgetch();
      CursorHandling(a);
#ifdef HAS_GPM
      if (MouseSupport==TRUE)  {
	 if (mouse_getbutton()==MOUSE_RIGHTBUTTON) a=27;
	 if (mouse_getbutton()==MOUSE_LEFTBUTTON) blockmode();
      }
#endif
      switch (a) {
       case 28: /* PRiNT SCREEN - Toggle fullscreen on/off */
	 FullScreen=!FullScreen;
	 break;
       case ERR:
	 break;
       case 27: /* ESC - Menue Mode  */
	 a=getch();
	 switch(a){
	  case ERR:
	    menuemode();
	    break;
	  case 'z': /* ALT+Z - Blink on\off */
	    Attribute^=128;
	    break;
	  case 'k': /* ALT+P - ASCII Chart */
	    WriteCharacter(asciitable());
	    break;
	  case '1':
	    DelCol();
	    break;
	  case '2':
	    InsCol();
	    break;
#ifdef HAS_SVGALIB
	  case 'v':
	    viewmode();
	    break;
#endif
	  case 'r': /* ALT+R UNDO*/
	    UndoLast();
	    break;
	  case 'g':
	    global();
	    break;
	  case 'u': /* ALT+U PiCKUP COLOR*/
	    Attribute=Screen[ActivePage][CursorY+FirstLine][CursorX*2+1];
	    break;
	  case 'w':
	    SelectOutline();
	    break;
	  case 'i':/* ALT+I InsLine*/
	    InsLine();
	    break;
	  case 'y': /* ALT+Y - DelLine */
	    DelLine();
	    break;
	  case 'e': /* ALT+E - Elite*/
	    EliteMode=!EliteMode;
	    break;
	  case 'x': /* ALT+X - Exit */
	    exitprg();
	    break;
	  case 'a': /* ALT+A - Color */
	    Attribute=SelectColor();
	    break;
	  case 'n': /* ALT+N - Font Mode */
	    FontMode=!FontMode;
	    Undo=0;
	    SaveScreen();
	    break;
	  case 's':
	    save();
	    break;
	  case 'c': /* ALT+C - ClearScreen*/
	    ClearScreen();
	    break;
	  case 'l':
	    load();
	    break;
	  case 'p': /* ALT+P - SetPage */
	    SetPage();
	    break;
	  case 't':
	    tabsetup();
	    break;
	  case 'h': /* alt+h help */
	    help();
	    break;
	  case '-': /* alt+- draw mode */
	    drawmode();
	    break;
	  case 9: /* ALT+TAB */
	    CursorX=tabback(CursorX);
	    break;
	  case 'b':
	    blockmode();
	    break;
	  case 'd': /* ALT+D Draw Line Mode */
	    drawline();
	    break;
	  case 'm':
	    select_effekt();
	    break; 
	  case 'f': /* ALT+F - Select Font */
	    a=SelectFont();
	    if (a>0) {
	       SFont=a;
	       Openfont(SFont);
	    }
	    break;
	 }
	 break;
       case 19:
	 SauceSet();
	 break;
       case 9: /* TAB */
	 CursorX=tabforward(CursorX);
	 break;
       case 13 : /* RETURN */
	 CursorX=0;
	 if ((FontMode==TRUE)&(FontTyped==TRUE))  {
	    CursorY+=MaxY;
	    Undo=FALSE;
	    SaveScreen();
	    FontTyped=FALSE;
	 } else CursorY++;
	 cpos=0;
	 break;
       case 330: /* Entf */
	 for (a=CursorX*2;a<=157;a++)
	   Screen[ActivePage][CursorY+FirstLine][a]=Screen[ActivePage][CursorY+FirstLine][a+2];
	 Screen[ActivePage][CursorY+FirstLine][159]=7;
	 Screen[ActivePage][CursorY+FirstLine][158]=32;
	 break;
       case KEY_IC:  /* Insert */
	 InsertMode=!InsertMode;
	 break;
	 
       case 263:
       case 127: /*KEY_BACKSPACE*/
	   if (CursorX>0){
	      if ((FontMode==TRUE)&(FontTyped==TRUE)&(cpos>0))  {
		 CursorX-=CursorPos[cpos]-1;
		 for (a=0;a<=CursorPos[cpos];a++)
		   for (b=0;b<=MaxY;b++) {
		      Screen[ActivePage][CursorY+FirstLine+b][(CursorX+a)*2]=Screen[UNDOPage][CursorY+FirstLine+b][(CursorX+a)*2];
		      Screen[ActivePage][CursorY+FirstLine+b][(CursorX+a)*2+1]=Screen[UNDOPage][CursorY+FirstLine+b][(CursorX+a)*2+1];			     
		   }
		 cpos--;
	      } else {	
		 cpos=0;
		 CursorX--;
		 if (InsertMode==TRUE) {
		    for (a=CursorX*2;a<=156;a++)
		      Screen[ActivePage][CursorY+FirstLine][a]=Screen[ActivePage][CursorY+FirstLine][a+2];
		    Screen[ActivePage][CursorY+FirstLine][159]=Attribute;
		    Screen[ActivePage][CursorY+FirstLine][158]=32;
		 } else  {
		    Screen[ActivePage][CursorY+FirstLine][CursorX*2]=32;
		    Screen[ActivePage][CursorY+FirstLine][CursorX*2+1]=Attribute;
		 }    
	      }
	   }
	 break;
       default: 
	 if (a<=255) {
	    if ((FontMode==TRUE)&(a>32)&(a<127)) {
	       DrawFontCharakter(a);
	    } else  {
	       if ((FontMode==TRUE)&(FontTyped==TRUE)) {
		  cpos++;
		  CursorPos[cpos]=2;
	       }
	       if (EliteMode==TRUE)
		 WriteCharacter(translate(a)); else
		 WriteCharacter(a);
	    }
	 }
      }
      for (b=1;b<=10;b++) 
	if (a==KEY_F(b))  {
	   WriteCharacter(CharSet[ActiveCharset][b-1]);
	}
      CursorCheck();
   } while (1==1);
}
