/* Augusta general include and system definitions, version VH%I% - %E%
 *
 * Copyright (C)%Q%
 *	Augusta Computer Dienstleistunggesellschaft mbH
 * All rights reserved. No Warranty. Use of own Risk.
 *
 * THIS SOFTWARE IS DEFINITIVELY NOT PUBLIC DOMAIN. COPYLEFT RULES APPLY!
 *
 * Permission to use, copy, modify, distribute and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Valentin Hilbig or Augusta Computer
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission. Valentin Hilbig and
 * Augusta Computer make no representations about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.
 *
 * VALENTIN HILBIG AND AUGUSTA COMPUTER DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL VALENTIN HILBIG OR AUGUSTA COMPUTER BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
 * IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Revisions:
 *	- none -
 */

#ifdef unix
#ident	"%W% - %E%"
#endif /*unix*/

#define	_HPUX_SOURCE		/* rm -rf hpux:/usr/include	*/

#include <stdio.h>		/* Need ANSI-C compatible compiler	*/


/* Some notes to name conventions:
 * This include file is thought as possibility to get rid of all this system
 * dependent compilation flags in source files.
 * It is much better to place all system dependices in _one_ lonely file than
 * to spread them uniformely among all project files with the highest
 * inflation and mutation rate possible. If you must add a patching hook at one
 * system, it is likely that this hook is needed also for other systems too.
 * So why not select the apropriate lonely file in this include file here?
 *
 * All names are full CAPS, name parts are separated by _.
 *
 * Should be used in your sourcecodes as rarely as possible:
 * HAVE_NO_xxx		xxx is known by default if not #define'd
 * HAVE_xxx		xxx is not known by default if not #define'd
 *
 * Feel free to use in your sourcecodes:
 * NEED_xxx		programmer's patch area for source parts
 *
 * Should not be used in your sourcecodes:
 * NUKE_xxx		programmer's patch area for function names
 *
 * All other defines have no naming convention yet.
 *
 * _INC_ include file name convention:
 * Include file definitions with path separator and dots (.) replaced by _.
 * _INC_ defines can be predefined to point elsewhere,
 * however this is not yet possible/implemented for all _INC_ defines.
 */


/* Compile options	----------------------------------------	*/
/*-DHAVE_NO_MOFIF	   if your system has no MOTIF			*/
/*-DHAVE_NO_ATHENA	   if your system has no ATHENA WIDGETS		*/
/*-DNUKE_FREAD		   if your fread() binding is incorrect		*/
/*-DHAVE_SPIPE		   if your systems knows spipe()		*/
/*-DHAVE_NO_SPIPE	   please never use it, has traditional reasons	*/
/*-DHAVE_NO_SOCKET_PROTOTYPES   if your system misses socket prototypes	*/


/* Preset defines	----------------------------------------	*/
/* Note: This list is sorted by emacs' M-x sort-lines	*/

#undef	ELLIPSE		/* define to your system's ellipse ", ..."	*/
#undef	HAVE_DOS_PATH	/* if PATH_-Macros a la DOS			*/
#undef	HAVE_INLINE	/* define if your compiler knows __inline__	*/
#undef	HAVE_INT_SIGFN	/* define if signal()-functions returning int	*/
#undef	HAVE_LONG_LONG	/* define if your Compiler has (long long)	*/
#undef	HAVE_NO_ALLOCA	/* define if your system has no alloca()	*/
#undef	HAVE_NO_STDARG	/* define if no va_list/stdarg.h available	*/
#undef	NEED_BINARY_IO	/* may be redefined for TURBOC needs		*/
#undef	NUKE_GNU_FNS	/* define if volatile/const-fn() break cc	*/
#undef	PURE_ELLIPSE	/* define to your system's ellipse "..."	*/
#undef	lmulldiv	/* define to your system's a*b/c routine	*/


/* Imake&predefined dependices	--------------------------------	*/

#ifdef	SIGNALRETURNSINT	/* ObelixisMiraculixismyopiniononsuchnames */
#define	HAVE_INT_SIGFN
#endif


/* Compiler dependices	----------------------------------------	*/

#ifdef	__GNUC__
#define	NULLARRAY	0
#define	HAVE_INLINE
#endif

#ifdef	__TURBOC__
#define	NULLARRAY	/* Do you know, what Borland is thinking? */
#endif

#if __GNUC__+0>1
#define	HAVE_LONG_LONG
#endif


/* SYSTEM dependices	----------------------------------------	*/

#ifdef	__MSDOS__
#define	NEED_BINARY_IO	_fmode=O_BINARY
#define	HAVE_DOS_PATH
#endif

#ifdef	__ATARIST__
#ifndef	HAVE_ALLOCA
#define	HAVE_NO_ALLOCA
#endif
#define	HAVE_DOS_PATH
#endif

#ifdef	ISC
#ifndef	HAVE_NO_SPIPE
#define	HAVE_SPIPE
#endif
#endif

#ifdef	DELL
#define	NUKE_FREAD	/* some DELL have buggy fread from pipes	*/
#define	HAVE_NO_SOCKET_PROTOTYPES
#endif

#ifdef	_APOLLO_
#define	HAVE_NO_STDARG
#error	"_INC_MALLOC_H auf ein richtiges bzw. unverfaengliches include!"
#define	_INC_MALLOC_H		<>
#endif

#ifdef AIXV3
#define	PURE_ELLIPSE
#define	NUKE_GNU_FNS
#endif


#if 0	/*--------------------------------------------------PATCHING_EXPAMPLE*/
#ifdef __VERY_CRAZY_SYSTEM__
#define	HAVE_NO_RENAME_PROTOTYPE
#define	PATH_SEP_CHAR	' '
#define	PATH_SEP_STRING	" "
#define	_INC_STDIO_H	"crazy stdio.h"		/* Patched version	*/
#define	_INC_RENAME	"crazy rename.c"
#endif
#endif	/*--------------------------------------------------PATCHING_EXPAMPLE*/


/* Customisation file	----------------------------------------	*/

#include "includes/custom.h"	/* Customer patches		*/
#include "includes/site.h"	/* Customer site patches	*/
#include "includes/patch.h"	/* User patches			*/


/* For all systems	----------------------------------------	*/

#ifndef	__BYTE__
#define	__BYTE__	unsigned char
#endif
#ifndef	__WORD__
#define	__WORD__	unsigned short
#endif
#ifndef	__QUAD__
#define	__QUAD__	unsigned long
#endif
#if !defined(__OCTO__) && defined(HAVE_LONG_LONG)
#define	__OCTO__	unsigned long long
#endif

#ifndef	NULLARRAY
#define	NULLARRAY	1	/* for extension arrays in struct's	*/
#endif

#if !defined(lmulldiv) && defined(HAVE_LONG_LONG)
#define	lmulldiv(a,b,c)	((long)(((long long)(a)*(long long)(b)\
				 )/(long long)(c)))	/* this way _only_ */
#endif

/* Use nuke_fread() instead of fread() where the processing depends on
 * the correct return value required by ANSI and POSIX.
 */
#ifdef	NUKE_FREAD
size_t	nuke_fread(void *, size_t, size_t, FILE *);	/* link what? */
#else
#define	nuke_fread(a,b,c,d)	fread(a,b,c,d)
#endif

#ifndef	PATH_SEP_CHAR
#ifdef	HAVE_DOS_PATH
#define	PATH_SEP_CHAR	'\\'
#else
#define	PATH_SEP_CHAR	'/'
#endif
#endif

#ifndef	PATH_SEP_STRING
#ifdef	HAVE_DOS_PATH
#define	PATH_SEP_STRING	"\\"
#else
#define	PATH_SEP_STRING	"/"
#endif
#endif

#ifndef	PATH_LIST_CHAR
#ifdef	HAVE_DOS_PATH
#define	PATH_LIST_CHAR	';'
#else
#define	PATH_LIST_CHAR	':'
#endif
#endif

#ifndef	PATH_LIST_STRING
#ifdef	HAVE_DOS_PATH
#define	PATH_LIST_STRING	";"
#else
#define	PATH_LIST_STRING	":"
#endif
#endif

#ifndef __inline__
#ifndef HAVE_INLINE
#define	__inline__	/* hide away inlines	*/
#endif
#endif

#ifndef	PURE_ELLIPSE
#define	PURE_ELLIPSE	...
#endif

#ifndef	ELLIPSE
#define	ELLIPSE	, ...
#endif

#ifndef	HAVE_SPIPE
#define	HAVE_NO_SPIPE
#endif

#ifndef	NEED_BINARY_IO
#define	NEED_BINARY_IO	/* seem to have binary IO already	*/
#endif

#ifndef	SIGNAL_RETURN
#ifdef	HAVE_INT_SIGFN
#define	SIGNAL_RETURN	int
#else
#define	SIGNAL_RETURN	void
#endif
#endif

#ifdef	NUKE_GNU_FNS
#ifndef	FN_volatile
#define	FN_volatile
#endif
#ifndef	FN_const
#define	FN_const
#endif
#endif

#ifndef	FN_volatile
#define	FN_volatile	volatile	/* instead of type >volatile< fn() */
#endif

#ifndef	FN_const
#define	FN_const	const		/* instead of type >const< fn()	*/
#endif

#ifdef	HAVE_NO_VOID
#define	void	int
#endif

#ifdef	HAVE_NO_VOLATILE
#define	volatile
#endif

#ifdef	HAVE_NO_CONST
#define	const
#endif


#if 0	/*--------------------------------------------------PATCHING_EXPAMPLE*/
#ifdef	HAVE_NO_RENAME_PROTOTYPE
#define	HAVE_NO_RENAME
int rename(const char *old, const char *new);
#endif

/* Following maybee placed in tools.c:
 */
#if defined(HAVE_NO_RENAME) && !defined(HAVE_RENAME)
int rename(const char *old, const char *new)
{
#	include _INC_RENAME
}
#endif
#endif	/*--------------------------------------------------PATCHING_EXPAMPLE*/


/* Include definitions	----------------------------------------	*/
/* <> are global (normal, default), "" are local (patched, additional)	*/

#include "includes/local.h"	/* Local include changes	*/
#include "includes/own.h"	/* Own global includes	*/
#include "includes/augusta.h"	/* Augusta includes	*/
#include "includes/includes.h"	/* Normal includes	*/

#ifndef	_NO_X11_INCLUDES
#include "includes/X11.h"	/* X11 includes		*/
#endif
