/* Binding for simple programs
 *
 * @PublicIncludeHeader(Valentin Hilbig)(augusta/tool)(Augusta Toolbox)@@*/

#ifndef _augusta_tool_h
#define _augusta_tool_h

/* All following functions are supplied in the library -laugusta
 *
 * is_verbose	verbose level, default 0
 * prgname	application instance, argv[0] of main(), default undefined.
 *
 * warning()	Normally print string and do not terminate program
 * verbose()	Verbose output (if is_verbose>1)
 * vverbose()	Very Verbose output (if is_verbose>2)
 * usage()	Usage with normal and verbose text.
 *
 * alloc()	Allocate memory but *never* return NULL
 * ralloc()	Re-allocate memory, *never* fails
 *
 * fatal()	Print string and terminate program (never returns)
 * error()	Print string, normally terminate program
 * malfunction() Special form of fatal(), prompt module name and line number
 * dprintf()	Print string for debugging purpose
 */

extern int		is_verbose;
extern const char	*prgname;

#define	MALFUNCTION(X)	malfunction(__FILE__, __LINE__, X)
#define	FATAL(X)	if (X) MALFUNCTION(#X)
void	FN_volatile malfunction(const char *, int, const char *);
void	FN_volatile usage(const char *usage, const char *vusage);
void	FN_volatile fatal(const char *, ...);
void	FN_volatile error(const char *, ...);
void	warning(const char *, ...);
void	verbose(const char *format, ...);
void	vverbose(const char *format, ...);

void	*alloc(size_t);
void	*ralloc(void *, size_t);

#ifdef	DEBUG
#define	DP(X)	dprintf X
#else
#define	DP(X)
#endif
void	dprintf(const char *, ...);

#define	xDP(X)	/* switched off debugging	*/

#endif	/*_augusta_tool_h*/
