.\" 
.\"     pbmscan.1 --- Scanning utility for Logitech scanners
.\" 
.\"     Copyright (C) 1994  Andreas Matthias
.\" 
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 1, or (at your option)
.\"     any later version.
.\" 
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\" 
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\" 
.\"     Bugs, fixes, comments to: andy@titan.central.de (Andreas Matthias)
.\" 
.\" 
.PU
.TH PBMSCAN 1 local
.SH NAME
pbmscan \- Scanning utility for Logitech scanners
.SH SYNOPSIS
.ll +8
.B pbmscan
.RB "[-i] [-g[2|4|6]] [-d] [-w] <height in cm>"
.SH DESCRIPTION
.I pbmscan
is a scanning utility designed to operate with the Logitech ScanMan
scanners under Linux. 

.I pbmscan
uses the logiscan driver from A.Beck and T.Faehnle.

.I pbmscan
produces a PBM (black and white) or a PGM (grayscale) RAWBITS bitmap as 
output. It always writes the scanned image to its standard output, thus
allowing the use of pipes and filter programs for post-processing.
You will need the
.I netpbm
package or something similar to use this program efficiently. Also it is
recommended that you obtain and use the
.I xli
program to view the scanned bitmaps, because 
.I xv
(which could be used as an alternative) is much slower than 
.I xli.
.PP
.I <height in cm>
is the height of the picture you want to scan in centimeters, expressed
as an integer. There is no limit on the height. One inch is about 2.54
centimeters.

.SH OPTIONS
.I     -i
\-\- invert output bitmap.

.I     -d
\-\- enable doublescan mode. This option duplicates each output line so
that the resulting image gets stretched vertically. This can be used to
produce images that will be faxed in the low-resolution fax mode, which
requires each image line to appear twice. 

.I     -g
\-\- same as -g2. This option exists only for compatibility with scripts
that were written for version 1.0 of
.I pbmscan.
It should not be used any more, since it might be removed in the future.

.I     -g2
\-\- 2x2 grayscale mode. 
.B Use this only when scanner is set to B/W mode. 
When this option is used,
.I pbmscan
will produce a PGM grayscale image with 8 bits per pixel as output. The
image will have 5 distinct gray levels and half the original resolution
in each direction, since a 2x2 matrix is used to calculate the brightness
of each output pixel. 

.I     -g4
\-\- 4x4 grayscale mode. 
.B Use this only when scanner is set to B/W mode. 
When this option is used,
.I pbmscan
will produce a PGM grayscale image with 8 bits per pixel as output. The
image will have 17 distinct gray levels and 1/4 the original resolution
in each direction, since a 4x4 matrix is used to calculate the brightness
of each output pixel. 

.I     -g6
\-\- 6x6 grayscale mode. 
.B Use this only when scanner is set to B/W mode. 
When this option is used,
.I pbmscan
will produce a PGM grayscale image with 8 bits per pixel as output. The
image will have 37 distinct gray levels and 1/6 the original resolution
in each direction, since a 6x6 matrix is used to calculate the brightness
of each output pixel. This is the grayscale conversion that the Logitech
utilities under DOS are using.

If you have a ScanMan 256, you should NOT specify any of the -g options
when scanning in the grayscale modes of this scanner. These options
should be used only when scanning in B/W (black and white) mode.

.I     -w
\-\- enable warning bell. If you specify this option, a warning bell
will sound when you are scanning too fast, but before you lose any
data. The bell is disabled by default.

.SH EXAMPLES
This section assumes you have the
.I netpbm
and 
.I xli
packages installed.

To scan a picture with a height of 5 cm and view the result immediately 
under X do:

	pbmscan 5 | xli stdin

If you want to convert a B/W image to grayscale do:

	pbmscan -g2 5 | xli -zoom 200 stdin

or

	pbmscan -g4 5 | xli -zoom 400 stdin

(the -zoom options to xli resize the image to its original dimensions,
since it becomes smaller after the grayscale conversion).

To scan an image and convert it to a g3 fax you could do:

	pbmscan -d 5 | pbmtog3 > myfax.g3

To print an image directly to your Postscript printer (with warning bell 
enabled):

	pbmscan -w 5 | pbmtolps | lpr

The same with grayscale conversion:

	pbmscan -g6 -w 5 | pnmtops -scale 0.25 | lpr

or:

	pbmscan -g6 5 | pgmtopbm | pbmtolps | lpr

To save a scanned image to a pbm or pgm file do:

	pbmscan 5 > myfile.pbm

or:

	pbmscan -g6 5 > myfile.pgm

If you want to remove dirty pixels from your image you can use
.I pbmclean
:

	pbmscan 5 | pbmclean | xli stdin

And of course you can use all the other PBM tools to rotate, flip, scale 
and convert your images to various formats. Please note that some of
the PBM tools will drastically slow down the scanning process when used 
in a pipeline with
.I pbmscan.

.SH ABOUT SPEED

If your scanner starts blinking all the time, because it thinks you are
scanning too fast, then you should first scan into a PBM file and use
the PBM tools later to process this file instead of using them in a pipe
during the scanning process.

The ScanMan 256 is very slow when scanning with 300 or more dpi in the
64- or 256-grayscale modes. You will have to reduce the resolution to speed
up this process or use the 16 grayscale mode with high resolutions.

When the scanner light blinks, it will almost always be too late and you'll
have to repeat the scan. Use the -w option to get a speed warning before
you lose any scanned data.

.SH COPYRIGHT

.DS
 PBMSCAN Copyright (c) 1994 by Andreas Matthias 
 <andy@titan.central.de>
.DE

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

.SH SEE ALSO
xli(1), pbmtolps(1), pbm(5), pgm(5)

.SH BUGS

The 64-grayscale mode of the ScanMan 256 (model 3) doesn't work correctly.
Use the 16- or 256-grayscale mode instead, until we find out if this is 
a problem of the logiscan driver or of this program.

.SH AUTHOR

Andreas Matthias <andy@titan.central.de>

.SH THANKS

This program was inspired by the gifscan program from A.Beck
<becka@hp.rz.uni-duesseldorf.de> and contains some code from
that program. The copyright message of gifscan.c follows:

gifscan.c - ScanDemo for Logitech scanner-driver
Copyright (c) 1994 Andreas Beck 
(becka@hp.rz.uni-duesseldorf.de)
Parts copyright (c) 1994 Thomas Faehnle 
(Thomas.Faehnle@student.uni-ulm.de)

Thanks to A.Beck for his permission to duplicate parts of his code
in this program.

Many thanks to Karl Eichwalder (ke@pertron.central.de), who gave me
his ScanMan 256 for testing. Without his help, ScanMan 256 support 
would not have been possible.

.SH SUGGESTIONS, BUG REPORTS, ETC.
Mail to: Andreas Matthias <andy@titan.central.de>


