/*
 * mscan - Mustek Flatbet Scanner Driver.
 * Copyright (C) 1996 David Mosberger-Tang.
 * This file is part of the mscan package.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * mscan is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mscan; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef scsi_h
#define scsi_h

#include <sys/types.h>
#include <scsi/sg.h>

#define SCSI_MAX_REQUEST_SIZE	SG_BIG_BUFF

extern int	scsi_open (const char * device_name);
extern ssize_t	scsi_cmd (int fd,
			  const void * src, size_t src_size,
			  void * dst, size_t dst_size);
extern void	scsi_close (int fd);

#endif /* scsi_h */
