/*
 * mscan - Mustek Flatbet Scanner Driver.
 * Copyright (C) 1996 David Mosberger-Tang.
 * This file is part of the mscan package.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * mscan is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mscan; see the file COPYING.  If not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * Mustek Scanner Control Interface.
 */
#ifndef msci_h
#define msci_h

#include <sys/types.h>

typedef struct Pos {
    float x;	/* x position in millimeters */
    float y;	/* y position in millimeters */
} * Pos;

typedef struct Rect {
    struct Pos top_left;
    struct Pos bottom_right;
} * Rect;

/* flag values: */
#define MSCI_FLAG_SINGLE_PASS	(1 << 0)	/* single-pass scanner? */
#define MSCI_FLAG_ADF		(1 << 1)	/* automatic document feeder */
#define MSCI_FLAG_ADF_READY	(1 << 2)	/* paper present */
#define MSCI_FLAG_TA		(1 << 3)	/* transparency adapter */

/* source values: */
#define MSCI_SOURCE_FLATBED	0
#define MSCI_SOURCE_ADF		1
#define MSCI_SOURCE_TA		2

/* mode values: */
#define MSCI_MULTIBIT		(1 << 0)	/* one-bit vs multi-bit */
#define MSCI_COLOR		(1 << 1)	/* greyscale vs color */
#define MSCI_HALFTONE		(1 << 2)	/* use dithering? */

typedef struct Scanner {
    /* all the state needed to define a scan request: */
    struct {
	int		source;
	int		mode;
	int		backtrack;	/* backtrack? */
	int		resolution;	/* in dpi */
	int		grain;		/* use grainxgrain low-pass filter */
	float		speed;		/* 0 (slow), 100% (full speed) */
	struct Rect	area;
	int		num_windows;
	struct Rect	window[4];
	int		halftone_pattern_dimension;	/* one of [0,2-8] */
	u_int8_t	halftone_pattern[8][8];
	int		lamp_setting;	/* for transparency adapter */
	float		paper_length;	/* XXX for document feeder? */

	/* these are per color: */
	float		contrast[3];
	float		brightness[3];
	int		shadow[3];
	int		highlight[3];
	float		gamma[3];
	int		gamma_size[3];
	u_int8_t	gamma_corr[3][256];
    } req;
    /* scanner dependent/low-level state: */
    struct {
	const char *	name;		/* type name (e.g., MFC-06000CZ) */
	struct Pos	max_size;
	int		max_dpi;	/* max. dots/inch */
	unsigned	flags;
	int		fd;		/* open file descriptor */
    } hw;
    /* line-distance correction related state: */
    struct {
	int		max_value;
	int		peak_res;
	struct {
	    int		dist;			/* line distance */
	    int		Qk;
	} c[3];
    } ld;
    /* temporary state: */
    struct {
	int		resolution_code;	/* bit 8 == 10% mode */
    } tmp;
} * Scanner;

extern long	msci_open (Scanner scanner, const char * dev_name);
extern long	msci_add_scan_window (Scanner scanner,
				      struct Pos top_left,
				      struct Pos bottom_right);
extern void *	msci_scan_image (Scanner scanner,
				 size_t * width, size_t * height);
extern void	msci_close (Scanner scanner);

#endif /* msci_h */
