/*
	Program zum laden der Kamara-daten von Olympus/Sanyo
	CAMERA C-400
	von Oliver Graffunder
*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>

int com_fd=-1, com_fd2=-1;
extern int errno;
char *argv0;
int buf_len;
struct termios nport; 	

open_fd(fn,speed)
char fn[];
int  speed;
{
	char buf[500];
	int i;
		
	com_fd2=com_fd=open(fn,O_RDWR);
	if(com_fd < 0) {
		fprintf(stderr,"%s: Datei %s: %s\n",argv0,fn,strerror(errno));
		exit(1);
	}

   ioctl(com_fd, TCGETS, &nport);      /* Get old modes to change them */

   nport.c_cflag &=  ~CBAUD;
   nport.c_cflag |=   speed;   /* B1920 */
   nport.c_cflag &=  ~CSIZE;
   nport.c_cflag |=   CS8;
   nport.c_cflag &=  ~PARENB;
   nport.c_cflag |=   CLOCAL | CREAD;
   nport.c_cflag &=  ~CRTSCTS;

   nport.c_oflag &=  ~(OPOST | ONLCR);
   nport.c_oflag = 0;

    nport.c_iflag =    IXON | IGNPAR | IXOFF;

   nport.c_lflag &= ~(ICANON | ECHO);
	
	for(i=0;i<NCCS;i++) nport.c_cc[i]=0;		/* NCCS = Anzahl c_cc-Felder */
   nport.c_cc[VMIN]  = 1;
   nport.c_cc[VTIME] = 0;

   ioctl(com_fd, TCSETS, &nport);       /* Set  new  modes      */

	return(com_fd);
}

sende1(block,len)
unsigned char *block;
int len;
{
	register int i,crc,crc1,crc2,x;
	unsigned char buf[100];

	crc=0;
	for(i=0;i<len;i++) crc+=block[i];

	crc1 =  (crc & 0x0000ff);
	crc2 = ((crc & 0x00ff00) >> 8);
	for(x=0;x<10;x++) {

		alarm(10);
		buf[0]=0x1b; buf[1]=0x43; 
		buf[2]=(len & 0xff); buf[3]=((len & 0xff00) >> 8);
		write(com_fd,buf,4);
	
		write(com_fd,block,len);

		buf[0]=crc1; buf[1]=crc2;
		write(com_fd,buf,2);
 	
		read(com_fd2,buf,1);
		if(buf[0]==21 ) continue;
		if(buf[0]==255) {
			send_sync();
			continue;
		}
		if( (buf[0] < 4) && (buf[0] > 0) ) {
			read(com_fd2,&buf[1],1);
		}
		return((int)buf[0]);
	}
	return(0);		
}

sende2(block,len)
unsigned char *block;
int len;
{
	register int i,crc,crc1,crc2,x;
	unsigned char buf[100];
	
	crc=0;
	for(i=0;i<len;i++) crc+=block[i];
	crc1 = crc & 0xff;
	crc2 = (crc & 0xff00) >> 8;
	
	for(x=0;x<10;x++) {
		alarm(10);
		buf[0]=0x1b; buf[1]=0x53; 
		buf[2]=(len & 0xff); buf[3]=((len & 0xff00) >> 8);
		write(com_fd,buf,4);
	
		write(com_fd,block,len);
		buf[0]=crc1; buf[1]=crc2;
		write(com_fd,buf,2);
	
		read(com_fd2,buf,1);
		if(buf[0]==21 ) continue;
		if(buf[0]==255) {
			send_sync();
			continue;
		}
		if( (buf[0] < 4) && (buf[0] > 0) ) {
			read(com_fd2,&buf[1],1);
			fprintf(stderr,"noch ein Byte = %d \n",buf[1]);
		}
		return( (int)buf[0] );
	}
	return(0);		
}

send_ok() {
	write(com_fd,"\x06",1);
	return(1);
}

send_nak() {
	write(com_fd,"\x15",1);
	return(1);
}

send_sync() {
	char buf[10];
	int i;
	
	alarm(10);
	fcntl(com_fd2, F_SETFL, O_NONBLOCK);
	i=0;
	while(i==0) {
		write(com_fd,"\xc0",1);   /* 0xc0 */
		sleep(1);
		i=read(com_fd2,buf,1);
	}
	fcntl(com_fd2, F_SETFL, 0);
	
	write(com_fd,"\x00\x00",2);
	i=read(com_fd2,buf,1);

	return(1);
}

get_ack() {
	char buf[10];
	
	read(com_fd2,buf,1);
	read(com_fd2,buf,1);
	return(1);
}

char *lese() {

	unsigned char *rbuf, buf[100];
	register int crc,i,j,x,len;
	
	alarm(10);
	for(i=0; i<2; )
		(i+=read(com_fd2,&buf[i],(size_t)(2-i)));
	
	len=buf[0]+buf[1]*256;
	if( (rbuf = (char *)malloc((size_t)len)) == NULL ) {
		fprintf(stderr,"%s: kein Speicher\n",argv0);
		return(0);
	}
	for(i=0; i<len; ) { j=i;
		(i+=read(com_fd2,&rbuf[i],(size_t)(len-i)));
	}
	for(i=0; i<2; ) {
		(i+=read(com_fd2,&buf[i],(size_t)(2-i)));
	}
	for(i=0,crc=0;i<len;i++) crc+=rbuf[i];
	x=buf[0]+buf[1]*256;
	crc &= 0xffff;
	if(x!=crc) {
	   fprintf(stderr,"%s: CRC-fehler in:%d rech:%d b1=%d b2=%d\n",argv0,x,crc,buf[0],buf[1]);
		free(rbuf);
	   return(0);
	}
	buf_len=len;
	send_ok();
	return(rbuf);
}

extern int optind;
extern char *optarg;

main(argc,argv)
int argc;
char *argv[];
{
	FILE *out;
	unsigned char *rbuf,buf[100];
	int o;
	int i,len,x, bnr;
	int blitz=-1;
	int qualitaet=-1;
	int speed=B19200;
	int leise=0;
	int index_bild=0;
	int sucher=0;
	int ausloeser=0;
	int loeschen=0;
	char fn[]="/dev/cua0";
	
	argv0=argv[0];
	while( (o=getopt(argc,argv,"p:b:nstqh:fl")) != (-1)) {
		switch(o) {
		default :
		case ':' :
		case '?' :
					fprintf(stderr,"\nusage: %s [OPTIONS] Bildnummer [FILE]\n",argv0);
					fprintf(stderr,"         -p FILE   Kamara-Port\n");
					fprintf(stderr,"         -b SPEED  9600 19200 38400 57600 Baud\n");
					fprintf(stderr,"         -n        Index-Bilder\n");
					fprintf(stderr,"         -s        Sucher-Bild erzeugen\n");
					fprintf(stderr,"         -t        Ausloeser\n");
					fprintf(stderr,"         -q        quiet\n");
					fprintf(stderr,"         -h ARG    Qual. 0=nomal, 1=HQ\n");
					fprintf(stderr,"         -f ARG    Blitz: 0=auto, 1=rote Augen, 2=aus, 3=an\n");
					fprintf(stderr,"         -l        Alle Bilder Loeschen\n");
					exit(1);
					break;
		case 'p' :
					strcpy(fn,optarg);
					break;
		case 'b' :
					if(strcmp(optarg,"9600")==0)
						speed=B9600;
					else if(strcmp(optarg,"19200")==0)
                  speed=B19200;
					else if(strcmp(optarg,"38400")==0)
                  speed=B38400;
					else if(strcmp(optarg,"57600")==0)
                  speed=B57600;
					else {
						fprintf(stderr,"         -b SPEED:  9600 19200 38400 57600 Baud\n");
               	exit(1);
               }
   				break;
   	case 's' :
   				sucher=1;
   				break;
   	case 'n' :
   				index_bild=1;
   				break;
	   case 't' :	
   				ausloeser=1;
   				break;
   	case 'q' :
   				leise=1;
   				break;
   	case 'l' :
   				loeschen=1;
   				break;
		case 'h'	:
					qualitaet=atoi(optarg);
					if(qualitaet<0 || qualitaet>1) {
						fprintf(stderr,"         -h ARG    Qual. 0=nomal, 1=HQ\n");
						exit(1);
					}
					break;
		case 'f'	:
					blitz=atoi(optarg);
					if(blitz<0 || blitz>3) {
						fprintf(stderr,"         -f ARG    Blitz: 0=auto, 1=rote Augen, 2=aus, 3=an\n");
						exit(1);
					}
					break;
		}
	}
	
	if( ((argc-optind) >2 || (argc-optind)<1) && !(ausloeser || loeschen || sucher) ) {
		fprintf(stderr,"%s: usages: %s <BildNr> [<FILE>]\n",argv0,argv0);
		exit(1);
	}

	if( !(ausloeser || loeschen || sucher) ) {
		bnr=atoi(argv[optind]);
		if( bnr<1 || bnr>999 ) {
			fprintf(stderr,"%s: usages: %s <BildNr> [<FILE>]\n",argv0,argv0);
			exit(1);
		}
	}
	
	if(ausloeser) optind--;

	if(!sucher && !loeschen) {
		if((argc-optind)==1) { 
			out=stdout;
		} else {
			if((out=fopen(argv[optind+1],"w")) == NULL ) {
				fprintf(stderr,"%s: Datei %s: %s\n",argv0,argv[1],strerror(errno));
				exit(1);
			}
		}
	}
			
	alarm(20);
	open_fd(fn,speed);

	ioctl(com_fd2,FIONREAD,&i);
	for(;i>0;i--) {
		read(com_fd2,buf,1);
	}

	send_sync();
	sende2("\x00\x11\x02\x00\x00\x00",6);
	
	sende1("\x01\x12",2);
	rbuf=lese(); 
	if(rbuf==NULL) {
		fprintf(stderr,"%s: Fehler\n",argv0);
		exit(1);
	}
	free(rbuf);
	
	sende1("\x01\x10",2);
	rbuf=lese(); 
	if(rbuf==NULL) {
		fprintf(stderr,"%s: Fehler\n",argv0);
		exit(1);
	}
	free(rbuf);
	
	if(ausloeser) {
		i=sende1("\x02\x02\x00",3);
		if(i==06) { 
			read(com_fd2,buf,1);
		} else { 
			fprintf(stderr,"%s: Die Kamara ist wohl voll oder so\n",argv0);
			exit(1);
		}
	}

	if(sucher) {
		i=sende1("\x02\x05\x00",3);
		if(i==06) { 
			read(com_fd2,buf,1);
		} else { 
			fprintf(stderr,"%s: Die Kamara will nicht suchen\n",argv0);
			exit(1);
		}
	}

	if(loeschen) {
		i=sende1("\x02\x01\x00",3);
		if(i==06) { 
			read(com_fd2,buf,1);
		} else { 
			fprintf(stderr,"%s: Die Kamara will nicht loeschen?\n",argv0);
			exit(1);
		}
	}

	if(!sucher) {
		sende1("\x01\x0a",2);
		rbuf=lese();
		if(rbuf==NULL) {
			fprintf(stderr,"%s: Fehler\n",argv0);
			exit(1);
		}
		if(ausloeser) bnr=rbuf[0];
		
		if(!leise) fprintf(stderr,"%s: Bilderzahl: %d\n",argv0,(int)rbuf[0]);
	
		if(loeschen) exit(0);
		
		if( bnr>(int)rbuf[0] ) {
			fprintf(stderr,"%s: Bild nicht in der Kamara, BNr=%d\n",argv0,bnr);
			exit(1);
		}
		free(rbuf);
	
		sende1("\x04\x16",2);
		rbuf=lese();
		if(rbuf==NULL) {
			fprintf(stderr,"%s: Fehler\n",argv0);
			exit(1);
		}
		if(!leise) fprintf(stderr,"%s: Kamaraname: %s\n",argv0,rbuf);
		free(rbuf);
	} else {
		bnr=0;
	}
		
	buf[0]=0x00;
	buf[1]=0x04;
	buf[2]=bnr;
	buf[3]=0x00;
	buf[4]=0x00;
	buf[5]=0x00;
	sende1(buf,6);
	
	if(index_bild || sucher) {
		sende1("\x01\x0d",2);
	} else {
		sende1("\x01\x0c",2);
	}
	rbuf=lese();
	if(rbuf==NULL) {
		fprintf(stderr,"%s: Fehler\n",argv0);
		exit(1);
	}
	len=rbuf[0]+rbuf[1]*256;
	if(!leise) fprintf(stderr,"%s: Bildlaenge: %d\n",argv0,len);
	free(rbuf);
	
	if(index_bild || sucher) {
      sende1("\x04\x0f",2);
	} else {
		sende1("\x04\x0e",2);
	}
	for(x=0;x<len;x+=buf_len) {
		if(x>0) get_ack();
		rbuf=lese();
		if(rbuf==NULL) {
			fprintf(stderr,"%s: Fehler\n",argv0);
			exit(1);
		}
		if(!leise) fprintf(stderr,"\r%s: Gelesen: %d %%",argv0,x*100/len);
		fwrite(rbuf,buf_len,1,out);
		free(rbuf);
	}
	if(!leise) fprintf(stderr,"\r%s: Gelesen: 100 %%\n",argv0);
	
	sende1("\x01\x10",2);
	rbuf=lese(); free(rbuf);
	
	exit(0);
}

