
%{
#include <math.h>
#include <fcntl.h>
#include <ctype.h>
#include <unistd.h>
#include <stdio.h>
#include "coolscan.h"

#define YY_INPUT(buf,result,max_size) \
 { int c = getc( yyin ); \
  result = c == EOF ? 0 : 1; \
  buf[0] = (char) c; \
 }
                 
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout );\
      fflush(yyout);

int asctoi(char* );
int i; 
%}

DIGIT    [-0-9]
ID       [a-z][a-z0-9]*
INTEGER  {DIGIT}+
SPC	[ \011]*

%%


{INTEGER}" "*"kuh"  printf("hello world\n");

{DIGIT}+"."{DIGIT}*" ""kuchen"  {
		printf("eine Kuchenzahl %g",atof (yytext));
}
"cn"{SPC} {
	cs_state.film_type = COLOR_NEGATIVE;
	if(cs_state.outputformat == FORMAT_PGM)
		cs_state.outputformat = FORMAT_PPM;
	set_film_type(cs_state.film_type);
}
"cp"{SPC} {
        cs_state.film_type = COLOR_POSITIVE;
 	if(cs_state.outputformat == FORMAT_PGM)
                cs_state.outputformat = FORMAT_PPM;	
	set_film_type(cs_state.film_type);
}
"mn"{SPC} {
        cs_state.film_type = MONO_NEGATIVE;
	if(cs_state.outputformat == FORMAT_PPM)
                cs_state.outputformat = FORMAT_PGM;
	set_film_type(cs_state.film_type);
}
"mp"{SPC} {
        cs_state.film_type = MONO_POSITIVE;
	if(cs_state.outputformat == FORMAT_PPM)
                cs_state.outputformat = FORMAT_PGM;
	set_film_type(cs_state.film_type);
}

"x1"{SPC}|"X1"{SPC}  {
	printf("%d",cs_state.x1);
}
"x2"{SPC}|"X2"{SPC} {
	printf("%d",cs_state.x2);
}
"y1"{SPC}|"Y1"{SPC} {
	printf("%d",cs_state.y1);
}
"y2"{SPC}|"Y2"{SPC} {
	printf("%d",cs_state.y2);
}
"x1"{SPC}{INTEGER}{SPC} {
	i = asctoi(yytext);
	if( (i>=0) && (i<=MAX_X) ){
	 	cs_state.x1 = i;
		cs_state.nx = (cs_state.x2 - cs_state.x1) / cs_state.px;
	}
	else printf("value out of range");
}
"x2"{SPC}{INTEGER}{SPC} {
	i = asctoi(yytext);
        if( (i>0) && (i<=MAX_X) ){
		 cs_state.x2 = i;
		 cs_state.nx = (cs_state.x2 - cs_state.x1) / cs_state.px;
	}
        else printf("value out of range");
}
"y1"{SPC}{INTEGER}{SPC} {
	 i = asctoi(yytext);
        if( (i>=0) && (i<=MAX_Y) ){
                cs_state.y1 = i;
                cs_state.ny = (cs_state.y2 - cs_state.y1) / cs_state.py;
        }
        else printf("value out of range");
}
"y2"{SPC}{INTEGER}{SPC} {
	i = asctoi(yytext);
        if( (i>0) && (i<=MAX_Y) ){
                cs_state.y2 = i;
                cs_state.ny = (cs_state.y2 - cs_state.y1) / cs_state.py;
        }
        else printf("value out of range");
}
"px"{SPC} {
	printf("%d",cs_state.px);
}
"py"{SPC} {
        printf("%d",cs_state.py);
}

"px"{SPC}{INTEGER}{SPC} {
	i = asctoi(yytext);
        if( (i>0) && (i<=25) ){
                cs_state.px = i;
                cs_state.nx = (cs_state.x2 - cs_state.x1) / cs_state.px;
        }
        else printf("value out of range");


}
"py"{SPC}{INTEGER}{SPC} {
        i = asctoi(yytext);
        if( (i>0) && (i<=25) ){
                cs_state.py = i;
                cs_state.ny = (cs_state.y2 - cs_state.y1) / cs_state.py;
        }
        else printf("value out of range");


}

"rtime"{SPC}|"red"{SPC} {
	printf("%d",cs_state.red);
}
"gtime"{SPC}|"green"{SPC} {
	printf("%d",cs_state.green);
}
"btime"{SPC}|"blue"{SPC} {
	printf("%d",cs_state.blue);
}
"time"{SPC}|"ap"{SPC} {
	printf("%d",cs_state.exp_time);
}
"rtime"{SPC}{INTEGER}{SPC}|"red"{SPC}{INTEGER}{SPC} {
	i = asctoi(yytext);
	if( (i >= 25) && (i<=100)){
		cs_state.red = i;
	}
	else printf("value out of range ");
	register_color_balance(1,cs_state.red,cs_state.green,
				cs_state.blue, cs_state.film_type );

}
"gtime"{SPC}{INTEGER}{SPC}|"green"{SPC}{INTEGER}{SPC} {
	i = asctoi(yytext);
        if( (i >= 25) && (i<=100)){
                cs_state.green = i;
        }
        else printf("value out of range ");
	register_color_balance(1,cs_state.red,cs_state.green,
				cs_state.blue,cs_state.film_type);

}
"btime"{SPC}{INTEGER}{SPC}|"blue"{SPC}{INTEGER}{SPC} {
	i = asctoi(yytext);
        if( (i >= 25) && (i<=100)){
                cs_state.blue = i;
        }
        else printf("value out of range ");
	register_color_balance(1,cs_state.red,cs_state.green,
				cs_state.blue,cs_state.film_type);

}
"time"{SPC}{INTEGER}{SPC}|"ap"{SPC}{INTEGER}{SPC} {
	i = asctoi(yytext);
        if( (i >= 25) && (i<=100)){
                cs_state.exp_time = i;
		exp_time(i);
        }
        else printf("value out of range ");
	
}
"brtr"{SPC}|redbright{SPC} {
	printf("%d",cs_state.bright_red);
}
"brtg"{SPC}|greenbright{SPC} {
        printf("%d",cs_state.bright_green);
}
"brtb"{SPC}|bluebright{SPC} {
        printf("%d",cs_state.bright_blue);
}
"brt"{SPC} {
	printf("%d,%d,%d",	
	cs_state.bright_red,cs_state.bright_green,cs_state.bright_blue);
}
"brtr"{SPC}{INTEGER}{SPC} {
	i=asctoi(yytext); 
	if( (i<=5) && (i>=-5) ){
		cs_state.bright_red = i;
		brightness(cs_state.bright_red,cs_state.bright_green,cs_state.bright_blue);
	}
	else printf("value out of range");
}
"brtg"{SPC}{INTEGER}{SPC} {
        i=asctoi(yytext);
        if( (i<=5) && (i>=-5) ){
                cs_state.bright_green = i;
		brightness(cs_state.bright_red,cs_state.bright_green,cs_state.bright_blue);
        }
        else printf("value out of range");
}
"brtb"{SPC}{INTEGER}{SPC} {
        i=asctoi(yytext);
        if( (i<=5) && (i>=-5) ){
                cs_state.bright_blue = i;
		brightness(cs_state.bright_red,cs_state.bright_green,cs_state.bright_blue);
        }
        else printf("value out of range");
}
"brt"{SPC}{INTEGER}{SPC} {
        i=asctoi(yytext);
        if( (i<=5) && (i>=-5) ){
		cs_state.bright_red = i;
		cs_state.bright_green = i;
                cs_state.bright_blue = i;
		brightness(cs_state.bright_red,cs_state.bright_green,cs_state.bright_blue);
        }
        else printf("value out of range");
}

"cntr"{SPC} {
        printf("%d",cs_state.contrast_red);
}
"cntg"{SPC} {
        printf("%d",cs_state.contrast_green);
}
"cntb"{SPC} {
        printf("%d",cs_state.contrast_blue);
}
"cnt"{SPC} {
	printf("%d,%d,%d",
	cs_state.contrast_red,cs_state.contrast_green,cs_state.contrast_blue);
}
"cntr"{SPC}{INTEGER}{SPC} {
        i=asctoi(yytext); 
        if( (i<=5) && (i>=-5) ){
                cs_state.contrast_red = i;
		contrast(cs_state.contrast_red,cs_state.contrast_green,cs_state.contrast_blue);
        }
        else printf("value out of range");
}
"cntg"{SPC}{INTEGER}{SPC} {
        i=asctoi(yytext);
        if( (i<=5) && (i>=-5) ){
                cs_state.contrast_green = i;
		contrast(cs_state.contrast_red,cs_state.contrast_green,cs_state.contrast_blue);
        }
        else printf("value out of range");
}
"cntb"{SPC}{INTEGER}{SPC} {
        i=asctoi(yytext);
        if( (i<=5) && (i>=-5) ){
                cs_state.contrast_blue = i;
		contrast(cs_state.contrast_red,cs_state.contrast_green,cs_state.contrast_blue);
        }
        else printf("value out of range");
}
"cnt"{SPC}{INTEGER}{SPC} {
	i=asctoi(yytext);
	if( (i<=5) && (i>=-5) ){
		cs_state.contrast_red = i;
		cs_state.contrast_green = i;
		cs_state.contrast_blue = i;
		contrast(cs_state.contrast_red,cs_state.contrast_green,cs_state.contrast_blue);
	}
}

"ag"{SPC} {
	printf("%d",cs_state.analog_gamma);
}
"agon"{SPC} {
	cs_state.analog_gamma = 1;
	agon();
}
"agof"{SPC} {
	cs_state.analog_gamma = 0;
	agof();
}
"av"{SPC} {
	printf("%d",cs_state.averaging );
}
"avon"{SPC} {
	cs_state.averaging = 1;
	avon();
}
"avof"{SPC} {
	cs_state.averaging = 0;
	avof();
}
"lut"{SPC}"linear"{SPC} {
	cs_state.gamma = LINEAR_GAMMA;
	linear_gamma();
}
"lut"{SPC}"tv"{SPC} {
	cs_state.gamma = TV_GAMMA;
	tv_gamma();
}
"lut"{SPC}"user"{SPC} {
	cs_state.gamma = USER_GAMMA_1;
}

"q"|"quit"|"bye"|":q"|":Q" {
	printf("bye\n");
	exit(0);
}
"pr"{SPC}|"prescan"{SPC} {
	prescan();
}
"fr"{SPC} {
	cs_state.output_color = 'r';
	mono_output_color('R');
	printf("ready\n");
}
"fg"{SPC} {
	cs_state.output_color = 'g';
	mono_output_color('G');
	printf("ready\n");
}
"fb"{SPC} {
	cs_state.output_color = 'b';
	mono_output_color('B');
	printf("ready\n");
}

"scan"{SPC} {
	struct cs_state_struct *s;
	s = &cs_state;
	newscan(s->outfile,s->outputformat,s->x1,s->y1,s->px,s->py,s->nx,s->ny );
	/*read_empty(); */
}
"line"{SPC}{INTEGER} {
	print_line(asctoi(yytext));
}
"setv"{SPC}|"setvalues" {
	struct cs_state_struct *s;
        s = &cs_state;
        set_state(s);
}

"rer"{SPC} {
	read_error();
}

"rcnd"{SPC}|"r"{SPC} {
	rcnd(&cs_idata);
	print_idata(&cs_idata);
}
"dump"{SPC}|"d"{SPC} {
	rcnd(&cs_idata);
	dump_idata(&cs_idata);
}
"ej"{SPC}|"eject"{SPC} {
	eject();
}
"reset"{SPC}|"int"{SPC} {
	reset();
	pixel_interleave_output();
}
"inm"{SPC} {
	init_mem();
}
"apin"{SPC} {
	apin();
}
"stage"{SPC}{INTEGER}{SPC}|"mv"{SPC}{INTEGER}{SPC} {
	stage_move_to(asctoi(yytext));
}
"abort"{SPC}|abt{SPC} {
	abort_scan();
}
"o"[ \011]+.*|out[ \011]+.* {
	sscanf(yytext,"%80s %80s", &(cs_state.outfile[0]),&(cs_state.outfile[0]));
}
.*            printf( "wrong command: %s", yytext ); 
%%


int asctoi(char *str){
 	while(isalpha(*str)||isdigit(*str))str++;
 		for(;*str != '\0';str++){
  		if(isdigit(*str)||(*str=='-'))return atoi(str);
 	}
  	return 0; 
}


void interactive_main(int argc, char **argv){ 

	pixel_interleave_output();
 	apin();
 	init(&cs_state);
 	specify_color_balance(1);
 	if( (yyin = fopen("~/.coolrc","r"))) {
		printf("reading ~/.coolrc"); 
		yylex();
 	}
 	if ( argc > 1 )
          	yyin = fopen( argv[1], "r" );
        else
        	yyin = stdin;
 	fflush(stdout);
       	yylex();
 
}
