#ifndef __AS8000P_H
#define __AS8000P_H
/*
 * as8000P.h
 *
 * Copyright (c) 1994 Michael Beck and (c) 1996 Louis Bronne
 *
 */ 

#include <scanner.h>

#define AS8000P_SCANNER_NAME     "AS-8000P"
#define AS8000P_SCANNER_MAJOR	26	/* major device */
#define AS8000P_IOBASE		0x256	/* base address of scanner interface 
					   0x256, 0x296, 0x356 or 0x396	 */
#define AS8000P_DMA		3	/* used DMA channel  (1 or 3) */
#define DEFAULT_BUFLINES	25	/* default # of scanlines in buffer */

#define FREE_LN			2	/* count of lines for driver wakeup */
/*
 * DO NOT CHANGE any of the following lines 
 */

#define MAX_BUFSIZ	(1<<19)	/* max. buffer size (bytes), prevents one
				   from locking up all mem as scan buffer 8-) */

#define HEADERSIZ	12	/* size of buffer header */

/* the maximum buffersize */
#define MAX_BLK		(4072 - HEADERSIZ)

struct buffer_block {
	struct buffer_block *next;
	unsigned int blksiz;
	unsigned int blkoff;
	unsigned char data[MAX_BLK];
};

struct buffer_pointer {
	struct buffer_block *blkptr;
	unsigned int index;
};

#endif

