#ifndef __AC4096_H
#define __AC4096_H
/*
 * ac4096.h
 *
 * Copyright (c) 1994 Michael Beck
 *
 */ 

#include <scanner.h>

#define AC4096_SCANNER_NAME     "ac4096"
#define AC4096_SCANNER_MAJOR	26	/* major device */
#define AC4096_IOBASE		0x296	/* base address of scanner interface */
#define AC4096_DMA		1	/* used DMA channel  (1 or 3) */
#define DEFAULT_BUFLINES	25	/* default # of scanlines in buffer */

#define FREE_LN			2	/* count of lines for driver wakeup */
/*
 * DO NOT CHANGE any of the following lines 
 */

#define MAX_BUFSIZ	(1<<19)	/* max. buffer size (bytes), prevents one
				   from locking up all mem as scan buffer 8-) */

#define HEADERSIZ	12	/* size of buffer header */

/* the maximum buffersize */
#define MAX_BLK		(4072 - HEADERSIZ)

struct buffer_block {
	struct buffer_block *next;
	unsigned int blksiz;
	unsigned int blkoff;
	unsigned char data[MAX_BLK];
};

struct buffer_pointer {
	struct buffer_block *blkptr;
	unsigned int index;
};

#endif

