#if !defined(__string_h)
#define __string_h
/*  Project CADshell

     Design Automation Laboratory
     Dept. of Mechanical and Aerospace Engineering
     Arizona State University
     Copyright (C) 1998. All Rights Reserved.

     FILE:			WString.h
     MODULE:		none
     DEPENDS ON MODULE(S):	none
     AUTHOR(S):		Michael Tjahjadi

     OVERVIEW
     ========
     Class declaration for WString.

*/
//
//++++++++++++++++++++++++++++++++++++++++++++++++++++
// wm the above, is where the basic string code was grabbed from. Thanks
//++++++++++++++++++++++++++++++++++++++++++++++++++++
//

//#include <iostream>
#include <string>

class WString
{
    size_t      str_size;
    void        allocate_string(const size_t sz);

    public:
    	char        *str_element;
        //wm
        WString Left ( const int count );
        WString Right( const int count );
        char GetAt (int nIndex); // 0 based
        class StrErr {};
        int Find ( const char m_Char );
        int Find ( const char *m_Str );
        int Find ( const WString &Str);
        void  MakeUpper();
        void  MakeLower();
        //wm end
        WString();
        WString(const char c);
        WString(const char *str);
        WString(const WString &o);
        WString(const WString *o);

        ~WString() {free( this->str_element);}

        //        friend std::ostream &operator<<( std::ostream &stream, const WString &o);
        //        friend std::istream &operator>>(std::istream &stream, WString &o);

        WString& operator=(const char c);
        WString& operator=(const char *s);
        WString& operator=(const WString &o);

        WString operator+(const char  c);
        WString operator+(const char *s);
        WString operator+(const WString &o);
        friend WString operator+(const char  c, const WString &o);
        friend WString operator+(const char *s, const WString &o);

        WString& operator+=(const char  c);
        WString& operator+=(const char *s);
        WString& operator+=(const WString &o);

        int operator==(const WString &o){return !strcmp(this->str_element,o.str_element);}
        int operator!=(const WString &o){return strcmp(this->str_element,o.str_element);}
        int operator< (const WString &o){return strcmp(this->str_element,o.str_element)<0;}
        int operator> (const WString &o){return strcmp(this->str_element,o.str_element)>0;}
        int operator<=(const WString &o){return strcmp(this->str_element,o.str_element)<=0;}
        int operator>=(const WString &o){return strcmp(this->str_element,o.str_element)>=0;}

        int operator==(const char *s) {return !strcmp(this->str_element,s)     ;}
        int operator!=(const char *s) {return  strcmp(this->str_element,s)     ;}
        int operator< (const char *s) {return  strcmp(this->str_element,s) < 0 ;}
        int operator> (const char *s) {return  strcmp(this->str_element,s) > 0 ;}
        int operator<=(const char *s) {return  strcmp(this->str_element,s) <= 0;}
        int operator>=(const char *s) {return  strcmp(this->str_element,s) >= 0;}

//        size_t len()    {return strlen(this->str_element);}
//        size_t length() {return strlen(this->str_element);}
        size_t len()    {return ( this->str_size -1 );}
        size_t length() {return ( this->str_size -1 );}
        void make_str(char *s)  {strcpy(s,this->str_element);}
        operator char *() const {return this->str_element;}

        char operator[](int i) const;
};
#endif
