//WM_structures.h
#ifndef WM_STRUCT_H
#define WM_STRUCT_H
/***************************************************************************
                          WM_structures.h  -  description
                             -------------------
    Basic definitions of various structures and enumerations used:

    begin                : Sat May 25 06:57:50 PDT 2002
    copyright            : (C) 2002 by Wenny Macura
    email                : wmacu@telus.net
 ***************************************************************************
 */
#include "copyright.h"
typedef unsigned char   byte;
// various MS bitmap definitions START
typedef short           WORD;
typedef unsigned int    DWORD;
typedef unsigned char   BYTE;
typedef int             LONG;
// various MS bitmap definitions END

// Rotatet options
enum ROTATE
{
    NO_ACTION,
    CW90,
    CCW90,
    CW180,
    TOP_BOT,                     // flip top bottom
    LEFT_RIGHT                   // flip left to right
};
/*++++++++++++++++++++++++++++++++++++++++++++++++++
    Imagetype processed:
    To add another image type, best is to create a class for the particular image type

    The new XXXClass shouls contain at least the XXX_ReadImg ( ImgClass * Img ) procedure,
    where the XXX should uniquely identify the image type.

    if write is desired generate the XXX_ImgWrite(ImgClass Img ).
    Add the header for this ne image type to the ImgLib.cpp.
1]		Modify the IMG_TYPE bellow to add the image type
2]		Modify the Utility::GetImageType(char *FileName)
            to return the appropriate image type.
3]		Modify the
            bool    ImgLib::ReadImage( bool RGBSwap,ImgClass *Img )
            to do the reading.
4]		Modify the
            bool HdrClass::ProcHdr(char *InputFile)
            and
            bool HdrClass::ProcImgHdr(ImgClass *Img)
            to read the header info.
            probably,  best is to generate a procedure bool HdrClass::ProcXXXHdr(ImgClass *Img)
            and call it from HdrClass::ProcImgHdr(ImgClass *Img) and or HdrClass::ProcHdr(char *InputFile)

5]		Modify the Init_ImageLib() and Destroy_ImageLib()
		to create and delete the new class.

    and you should be done :-)
 *++++++++++++++++++++++++++++++++++++++++++++++++++*/

enum IMG_TYPE
{
    TIFF_FILE,                   // 0
    JPEG_FILE,                   // 1
    PPM_FILE,                    // 2
    PGM_FILE,                    // 3
    BMP_FILE,                    // 4
    TII_FILE,                    // 5 don't use to write, special format
    GIF_FILE,                    // 6 not used
    TARGA_FILE                   // 7
};
/*++++++++++++++++++++++++++++++++++++++++++++++++++*/
// MS
typedef struct tagRGBQUAD
{
    BYTE rgbBlue;
    BYTE rgbGreen;
    BYTE rgbRed;
    BYTE rgbReserved;
} RGBQUAD;
/*++++++++++++++++++++++++++++++++++++++++++++++++++*/
// Bitmap header
// this was grabbed from MS
typedef struct tagBITMAPFILEHEADER
{
    unsigned short bfType;       // 0,1
    unsigned int bfSize;         // 2,3,4,5
    short bfReserved1;           // 6,7
    short bfReserved2;           // 8,9
    unsigned int bfOffBits;      // 10,11,12,13
}  BITMAPFILEHEADER;
/*++++++++++++++++++++++++++++++++++++++++++++++++++*/
// MS bitmap info header
typedef struct tagBITMAPINFOHEADER
{
    DWORD biSize;
    LONG biWidth;
    LONG biHeight;
    WORD biPlanes;
    WORD biBitCount;
    DWORD biCompression;
    DWORD biSizeImage;
    LONG biXPelsPerMeter;
    LONG biYPelsPerMeter;
    DWORD biClrUsed;
    DWORD biClrImportant;
} BITMAPINFOHEADER;
/*++++++++++++++++++++++++++++++++++++++++++++++++++*/
// MS bitmap
typedef struct tagBITMAPINFO
{
    BITMAPINFOHEADER    bmiHeader;
    RGBQUAD             bmiColors[1];
} BITMAPINFO;

/*++++++++++++++++++++++++++++++++++++++++++++++++++*/
// definition of the header structure
typedef struct
{
    char    File[256];           // image file name
    int TYPE;                    // 0 =tiff, 1=JPEG 2= PGM 3=PPM 4=BMP
    short Compression;           // compression indicator as per tiff
    int LineSize;                // line size width*nCh alligned to 32
    short nCh;                   // number of color channels
    short nBits;                 // no of bits per channel
    unsigned Height;             // no of lines
    unsigned Width;              // no of pixels
    unsigned    ResUnit;         // Res unit as per tiff
    float       X_Res[2];        // Resolution as per tiff
    float       Y_Res[2];
}   IMAGE_HDR_t;

/*++++++++++++++++++++++++++++++++++++++++++++++++++*/
// definition of the image structure as displayed, NO LUTS
// Orig_x,Orig_y,pixels,lines    define a crop area of the Image.
// if Orig_x,Orig_y  are zero, hence No Crop.
// Make sure LineSize doesnot change, when definig Crop area.

typedef struct
{
    // File name
    //	IMAGE_HDR	Hdr;
    char File[256];              // byte pointer ti image data
    byte *ImgData;
    //***** Important Start******
    int LineSize;                // line size in bytes
    // LineSize must not change from the original image when crop is defined
    //***** Important End ******
    int pixels;                  // No of pixels, may define crop width
    int lines;                   // No of lines, may define crop height
    int nCh;                     // no of chanels per pixel 1 or 3
    int nBits;                   // no of bits per pixel component ( 1, 4, 8, 16 ), assume all chanels are same
    int Orig_x;                  //origin of the imgae in pixels, if non-zero, defines origin of crop
    int Orig_y;                  //origin of the image in lines, may define origin of crop

    int ResUnit;                 // Res unit is the same as per TIFF
    float   Res;                 // Assume X and Y have the same res

    unsigned char   BGR;         // keeps track of the RGB Swaps
    unsigned char   update;      // bitmap should be updated, also will indicate the file type after ReadImage(..)
    //***** Important Start******
    // will be set to 2 ( bit 1 set ) if the image is red in full, set by ReadImage
    // ReadImage reads one image at a time ???
    // Must be 2 ( bit 1 set ) in order to delete ImgData
    // >2 ~ ImgData has been changed, should be redisplayed
    // 1 ~ read image in progress ( bit 0 set )
    // Do not delete the image if mod != 2 ( bit 1 not set )
    unsigned char   mod;
    //***** Important End ******
    unsigned char   planar;      // write the TIFF image in separate planes (TII format special parameters,
    // will compress better but will not be able to read except this lib)
    int ShouldRotate;			// see ROTATE enum for types
	unsigned char   Rotated;	// the Image has been rotated by ShouldRotate
								// after rotation ShouldRotate = Rotated
    							// if rotated == Should rotate no action
    unsigned char   Xbitmap;     // the Image data is in XBitmap format (4 bytes)
								// The image date is set to 32 bits as XRGB
}   IMG_t;
#endif                           //WM_STRUCT_H
