// Utility.h : header file
#ifndef UTILITY_H
#define UTILITY_H
//
#include "copyright.h"

#include    <stdio.h>
#include    <stdlib.h>
#include    <ctype.h>

#include    <Tii/GlobDefine.h>
#include	<Tii/ImgClass.h>
/////////////////////////////////////////////////////////////////////////////
#define NO_COEF 1024

class Utility
{
	public:
		Utility();
		~Utility();
		int 	ScaleXS(ImgClass *From, double Scale, ImgClass *To);
		bool	CpyImg(ImgClass * To, ImgClass *From);
		bool	ScaleImage(ImgClass *From, double XScale, double YScale,  ImgClass *To);
		bool	ScaleImage(ImgClass *Img, int DestPixels, int DestLines,  ImgClass *To);
		bool	makeLocalThn(char *HeaderFile, char * OutFile, int Size, double Gamma);
		bool	makeLocalThn(ImgClass *In, ImgClass * Out, int Size,double Gamma);
		bool	makeLocalThn(char *HeaderFile, char * OutFile, int Size);
		void	CalcCoef();
		int		check_log();
		bool	isTiff(char * FileName);
		void	ChangeExt(char *FName, char *ext);
		bool	FileExists(char * Fname);
		void	RmCRLF(char * str);
		int		LongAllign(int size);
		char    *LogDate();
		void    RenameCommands( int instance,int SubInstance, char *Dir);
		void    Add_Log( int Err_flag, char *Msg, char *FileName);
		void    Add_Log( int Err_flag, char *Msg);
		void    RemFiles( unsigned long DelTime);
		int		GetWords(char * inp_line, char * sep, char words[][WORD_LNGTH]);
		bool	IsSep(char ch, char * Sep);
		char    *GetExt( char *File);
		char    *GetFileName( char *str);
		bool	CopyCropRect(ImgClass *Src, ImgClass *Dst, CRect *Rct);
		void	SubsampleLocalImage( ImgClass *In, ImgClass *Out,int OutX,int OutY);
		int		SwapRedBlue(ImgClass *In);
		void	KillZeros(ImgClass *Img);
		int		GetImageType(char *FileName);
		bool	RotateRight(ImgClass *In, ImgClass *Out);
		bool	RotateLeft(ImgClass *In, ImgClass *Out);
		bool	FlipHorizontal(ImgClass *In, ImgClass *Out);
		bool	FlipVertical(ImgClass *In);
		bool	FlipVertical(ImgClass *In, ImgClass *Out);
		bool	GetImgRect(char *File, CRect Rct, ImgClass *Img);
		bool	GetRectFromImg(CRect *Rct, ImgClass *From,ImgClass *To);
		char* 	GetWords(int index,char * inp_line, char * sep);
		bool	makeLocalThn(ImgClass *In, ImgClass * Out, int Size);
		void	GetSubRectFromImg(CRect *Rct, ImgClass *From,ImgClass *To,int Wdth, int Hght);
		bool	isGif( char *File);
		bool	ToXbm( ImgClass *Img);
		bool	XbmToRGB( ImgClass *Img);
		size_t	GetFileSize( char *Fname);
		int		ScaleLine(ImgClass *From, ImgClass *To, int FromLine, int ToLine, double Scale);
		int		GetColorPixel(int Color, ImgClass *Img, int Xpos, int Ypos);
		int		SlowScaleImage(bool Compress,ImgClass *Img, char *To, double XSc, double YSc);
		int		ScaleLineBW( int No_Pixels, double Scale, byte * SrcPtr, byte * DestPtr);
		int		ScaleLineCLR( int No_Pixels, double Scale, byte * SrcPtr, byte * DestPtr);
		int		ScaleLineCLR( ImgClass *Img, double Scale, int Line, byte * DestPtr);
		void	IntToRGB( int Src, byte *r, byte * g, byte *b);
		bool	WriteImage( ImgClass *Img);
		void	CreateHist( int Color, ImgClass *Img, int *Hist);
		void	HistMaxMin( int *Hist, int *MaxIndex, int *MinIndex);
		void	SetGamma(double Gamma, int *Gam_Array, int ArrSize);
		void	ApplyGamma(double *Gamma, ImgClass *Src, ImgClass *Dest);
		void	ApplyLut(ImgClass* Src, ImgClass *Dest);
		
};
#endif                           // UTILITY_H
