// TIFFClass.h: interface for the TIFFClass class.
//

#ifndef TIFFCLASS_H
#define TIFFCLASS_H

#include "copyright.h"
#include <Tii/ImgClass.h>
#include <Tii/CRect.h>

#include <tiffio.h>

#define PHOTOMETRIC_TII 15

class TIFFClass
{
    // Construction
    public:
        unsigned short SamplesPerPixel;
        unsigned short* rmap;
        unsigned short* gmap;
        unsigned short* bmap;

        bool    PLANAR;
        short   planar;
        unsigned        pixels;
        unsigned        lines;
        short   AllBits[4];
        short   nCh;
        short   Bits;
        unsigned short  Compression;
        short   Photometric;
        unsigned        LineSize;
        unsigned short  ResUnit;
        float   X_Res[2];
        float  Y_Res[2];
        TIFF    *tifIn;
        TIFF    *tifOut;

        TIFFClass();
        int SlowScaleImage(bool Compress,char *From, char *To, double XSc, double YSc,double Res);
        int checkcmap(int n );
        bool ReadTIFFtoMem(bool bgr,ImgClass *In);
        bool TIFFClass::WriteTIFFfromMemTii(bool compress, bool bgr,ImgClass * Out);
        bool TIFFClass::WriteTIFFfromMem(bool compress, bool bgr,ImgClass * Out);
        bool TIFFClass::TII_WriteTIFFfromMem(bool Tii, bool compress, bool bgr,ImgClass * Out);
        //	static	bool WriteTIFFfromMem( bool compress,bool bgr,ImgClass *Out);
        TIFF *Open_Write_Tiff(bool compress,ImgClass * Out);
        TIFF *Open_Write_Tiff_TII(bool compress,ImgClass * Out);
        TIFF *TII_Open_Write_Tiff(bool Tii, bool compress,ImgClass * Out);

        // Attributes
    public:

        // Operations
    public:
        bool TIFFClass::GetLineOddEvenPixels(int Odd, ImgClass *Img, int SrcLineIndex, int DestIndex, int Left, int Right);
        bool ReadOtherTiffs( ImgClass *In );
        bool GetLine ( ImgClass *Img, int SrcLineIndex, int DestIndex, int Left, int Right );
        bool Get_TIFF_Tag (char *ImgFile, unsigned short Tag, void *TagVal);
        short TIFF_GetBits();
//        bool TiffmakeLocalThn(char *FileName,char *OutFile);
		bool TiffmakeLocalThn(char *FileName,char *OutFile,double Gamma);
		bool TiffmakeLocalThn(int Size, char *FileName,ImgClass *Thnl,double Gamma);        bool TiffmakeLocalThn(int Size, char *FileName,ImgClass *OutImage);
        //	static	void KillZeros( ImgClass *Img );
        bool PutSingleColor(int color, ImgClass *Out,int line,byte *bfr);
        TIFF * OpenTiffFile(char *FName);
        bool GetSingleColor(int color, ImgClass *In, int line,byte *bfr);
        bool GetTIFFImgRect(char *File, CRect Rct, ImgClass *Img, unsigned ImgH);
        virtual ~TIFFClass();

        // Generated message map functions
    protected:
};
#endif                           // TIFFCLASS_H
