// StreamClass.h : header file
/*
 * Copyright (c) 2000-2001 Wenny Macura
 *
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL WENNY MACURA BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#ifndef STREAMCLASS_H
#define STREAMCLASS_H
#include "copyright.h"

#include <Tii/ImgClass.h>
#include <Tii/GlobDefine.h>
#include <Tii/ParameterClass.h>
#include <Tii/ImgList.h>
/////////////////////////////////////////////////////////////////////////////
// StreamClass window

class StreamClass                // :	 public CWnd
{
    // Construction
    public:
        StreamClass();
        void    ShowPar();
        int RctIndex;
        void DiffImage(ImgClass *Src1, ImgClass *Src2, ImgClass *Dst );
        void ProcessRemoteFiles();
        void ProcessLocalFile(char *File,char *Dir);
        bool StreamInit;
        void ResetPar();
        bool ThnFlag;
        void StrToNo( int Index);
        //	void ThnToMap(FILE *Strm,ImgClass *Img, ImgClass *Map);
        int JPEG_File;
        char    strHdr[128];
        void NewMap(char * File,ImgClass *map);
        int GetParIndex(int Ind,char *str);
        int GetFreeParIndex();
        void RmCRLF(char * str);
        void FillPar (char *str);
        ParameterClass *Param[NOPAR];
        void ProcStream();
//        void MakeStream();
		void MakeStream(char *Dir);
        virtual ~StreamClass();
        void RebuildBmp(ImgClass *Src, ImgClass *Bmp,int Val[],CRect *Crop);
        void BuildMap(ImgClass *Bmp,int Xsub, int XsubNo, int Ysub, int YsubNo,CRect *Crop);
        void GetSubsampledImage(ImgClass *Src, ImgClass *Dst, int *Val,CRect *Crop);
        void GetPixel(ImgClass *Src, int X, int Y, byte *r, byte *g, byte *b);
        void PutPixel(ImgClass *Dst, int X, int Y, byte *r, byte *g, byte *b);

    protected:
};
#endif                           // STREAMCLASS_H
