/*	Server.h	*/
/*
This is the actual Server class, there may be up to
NO_SERVERS instances of this class, the instances are executed sequentially
depending on a timer.
Hence in theory, there could be N instances running at the same time.
*/
#ifndef SERVER_H
#define SERVER_H
#include "copyright.h"

#include    <Tii/GlobDefine.h?
#include    <stdio.h>
#include    <stdlib.h>
#include    <Tii/StreamClass.h>
#include    <Tii/ImgList.h>
#include    <Tii/ImgUtility.h>
/*
#include	<Tii/TIFFClass.h>
#include	<Tii/JPGClass.h>
#include	<Tii/BmpClass.h>
#include	<Tii/PpmClass.h>
#include	<Tii/PgmClass.h>
#include	<Tii/TargaClass.h>
*/
class   Server
{
    public:
        ImgList     mImgList;    // each instance of the server can load images independently
        Server      *pServer;    // this should be a pointer to this server
        ImgUtility  *pImgUtility;// our own utilities
        //		ImgList     *pImgList;
        StreamClass m_StrCl;
        int         m_Busy;      // Server Busy flag
        int         ServerIndex;
        Server();
        virtual ~Server();
                                 // Add a click to a click log
        void    AddClick( char *File,int NoCliks);
        //        void    ResetPar();      // Reset all the parameters
                                 // Execute the command
        bool    ExecCommand( int index);
                                 // Crop the image, called form ExecCommand
        int     CropImgFile(char    *InFile);
                                 // Fill the parameter list from the command file
        //        void    FillPar(char * CmdFile);
                                 // Get the next free parameter index
        //        int     GetFreeParIndex();
                                 // parameter string to a number
        //        void    StrToNo(int Index);
                                 // get an index of a parameter, based on text
        //        int     GetParIndex(int Ind, char * PName);
        int     ProcesNoBitmap();// Simple case, don't regenerate the bitmap
        void    CreateEmptyFile( char *FileName);
        //		bool		ReadImage	( bool RGBSwap,ImgClass *Img );
};
#endif
