// MapClass.h : header file
//
/*
 * Copyright (c) 2000-2002 Wenny Macura
 *
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL WENNY MACURA BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#ifndef MAPCLASS_H
#define MAPCLASS_H

/////////////////////////////////////////////////////////////////////////////
// MapClass window
#include <Tii/ImgClass.h>
#include <Tii/CRect.h>

class MapClass                   // : public CWnd
{
    // Construction
    public:
//        ImgUtility  *pImgUtility;
        Utility  *pUtility;
        ImgClass    *pImgClass;
        MapClass();
        void DiffIncrBmp(ImgClass *Src, ImgClass *Dst, int *Value,CRect *Crop);
        void CreateBitmapForRect( ImgClass *Src, ImgClass *Dst, CRect Rct);
        byte Mask[8];
        void SetBitMapBit( ImgClass *BmpImg,int X, int Y);
        bool CheckBitMapBit( ImgClass *BmpImg, int X, int Y);
        bool CheckMapBit(byte Qual, int X, int Y);
        byte SetQuality();
        //	void CheckEmptyCrop();
        void NewBitmap(ImgClass *Bmp,char *File);
        //	int RctList[NO_CROPS][4];
        void AddRectToBitMap( ImgClass *BmpImg, CRect Rct);
        void AddRectToMap(ImgClass *Map,CRect Rct,byte Value);
        int GetParam(char *Str,char * Pname);
        bool ProcessRct( byte *BitBucket,char *Hdr,ImgClass *Img);
        //	void ProcessThn(FILE *Strm,char *Hdr);
        //	void StreamToImg(char *File);
        //	bool CmdCropToMap(int X, int Y, int W, int H,int ImgW, int ImgH,int Step);
        //	void SubsampleToMap(int SubW,int X, int Y, int W, int H, int ImgW, int ImgH);
                                 // entire image bitmap
        ImgClass    *ImgMap;
                                 // crop bitmap;
        ImgClass    *CropBmp;
                                 //difference between last two crop bitmaps
        ImgClass    *IncMap;
        virtual ~MapClass();

    protected:
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif                           //MAPCLASS_H
