//ImgList.h
//
/*
 * Copyright (c) 2000-2002 Wenny Macura
 *
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL WENNY MACURA BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#ifndef IMGLIST_H
#define IMGLIST_H

#include    <stdio.h>
#include    <time.h>
//#include    <Tii/Includes.h>
//#include    "ImgUtility.h"
//#include    <Tii/GlobDefine.h>
//#include	<Tii/Server.h>
// NO_IMAGES should be defined in GlobDefine.h to 1024;
#include    <Tii/TIFFClass.h>
#include    <Tii/JPGClass.h>
#include    <Tii/BmpClass.h>
#include    <Tii/PpmClass.h>
#include    <Tii/PgmClass.h>
#include    <Tii/TargaClass.h>

#ifndef NO_IMAGES
#define NO_IMAGES  1024
#endif

//  should be defined in the calling program;
                                 //the actual list is common to all Servers
extern        ImgClass    *Image[];

class   ImgList
{
    public:

        TIFFClass   *pTIFFClass; //local classes
        JPGClass    *pJPGClass;
        BmpClass    *pBmpClass;
        PpmClass    *pPpmClass;
        PgmClass    *pPgmClass;
        TargaClass  *pTargaClass;
        //       HdrClass		*pHdrClass;
        //		ImgUtility	*pImgUtility;	//local utilities
        ImgList();
        ~ImgList();
        //		int         LastIndex;		//last index
        void        AllocateList();
        void        SquishList();
        //pointer to the current Image;
        //  Create a new Imgae pointer and return its index
        int         AddImage();
        // Delete an image at index
        bool        DeleteImage( int index);
        bool        DeleteImage( char *ImgPath);
        // Obtain an index of an image.  ImgClass->ImgStruct.name == ImageName
        int         GetImageByName( char *ImageName );
        // Obtain an index of an oldest Image in the list
        int         FindOldestImage(time_t CurrentTime);
        // Load an image onto the list, index is returned
        // if the image is part of the list already,the index is returned
        int         LoadImage_to_List( char *ImgPath);
        void        AddClick( char *File,int NoCliks);
        bool        ReadImage   ( bool RGBSwap,ImgClass *Img );

};
#endif
